/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.sqlite;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.sqlite.SqliteDdlParsing;
import com.intellij.sql.dialects.sqlite.SqliteDialect;
import com.intellij.sql.dialects.sqlite.SqliteDmlParsing;
import com.intellij.sql.dialects.sqlite.SqliteExpressionParsing;
import com.intellij.sql.dialects.sqlite.SqliteGeneratedParser;
import com.intellij.sql.psi.impl.parser.SqlParser;
import com.intellij.sql.psi.impl.parser.SqlParserUtil;

public class SqliteParser
extends SqlParser {
    public SqliteParser() {
        super(SqliteDialect.INSTANCE);
    }

    @Override
    public boolean allowStringsAsIdentifiers() {
        return true;
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean b) {
        return false;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return SqliteGeneratedParser.statement(builder, level);
    }

    @Override
    protected boolean allowOdbcSequences() {
        return false;
    }

    @Override
    protected TokenSet[] getExtendsTokenSets() {
        return SqliteGeneratedParser.EXTENDS_SETS_;
    }

    @Override
    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return SqliteDmlParsing.top_query_expression(builder, level);
    }

    @Override
    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return SqliteDdlParsing.type_element(builder, level);
    }

    @Override
    protected boolean parseParameterReferenceInner(PsiBuilder builder, IElementType paramToken, IElementType resultType) {
        return super.parseParameterReferenceInner(builder, paramToken, (IElementType)SQL_PARAMETER_REFERENCE);
    }

    @Override
    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference(builder, level, SqliteExpressionParsing::evaluable_expression);
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result2 = super.consumeCustomParameterReference(builder);
        if (result2 != null) {
            return result2;
        }
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT)) {
            return null;
        }
        String text = builder.getTokenText();
        if (text != null && text.startsWith("$")) {
            result2 = SQL_PARAMETER_REFERENCE;
            SqlParserUtil.consumeToken(builder, (IElementType)SQL_IDENT);
            while (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_COLON)) {
                SqlParserUtil.consumeToken(builder, (IElementType)SQL_COLON);
                SqlParserUtil.consumeToken(builder, (IElementType)SQL_IDENT);
            }
            if (SqlParserUtil.consumeOptionalToken(builder, (IElementType)SQL_LEFT_PAREN)) {
                SqlParserUtil.consumeAllTokensUpTo(builder, new IElementType[]{SQL_RIGHT_PAREN, SQL_SEMICOLON});
                SqlParserUtil.consumeToken(builder, (IElementType)SQL_RIGHT_PAREN);
            }
        }
        return result2;
    }

    @Override
    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result2 = SqliteExpressionParsing.value_expression(builder, level);
        if (!result2 && !optional) {
            builder.error("<expression> expected");
        }
        return result2;
    }

    @Override
    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, SqliteExpressionParsing::parenthesized_query_or_values, SqliteDmlParsing::top_query_expression, SqliteParser::parseTopQueryExpressionTail, SqliteExpressionParsing::row_element_list, (b, l) -> SqliteExpressionParsing.root_expr_0(b, l, -1) && SqliteExpressionParsing.row_element_list_separator(b, l) && SqliteExpressionParsing.row_element_list(b, l));
    }

    @Override
    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict(builder, level, SqliteDmlParsing::parenthesized_aliased_join_expression, SqliteDmlParsing::top_query_expression, SqliteParser::parseTopQueryExpressionTail, SqliteDmlParsing::comma_join_expression, (b, l) -> SqliteDmlParsing.join_expression_0(b, l, -1));
    }

    private static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        SqliteDmlParsing.query_expression_0(builder, level, -1);
        return SqliteDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

