/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionDescriptorImpl
implements SqlCloseBlockProcessorImpl.SubstitutionDescriptor {
    private final IElementType[] myHier;
    protected final String myPrepend;
    protected final String myAppend;
    private final int myTailLevel;
    private final TailCheck[] myTailChecks;

    public SubstitutionDescriptorImpl(IElementType[] hier, String prepend, String append, int level, TailCheck ... tailChecks) {
        this.myHier = hier;
        this.myPrepend = prepend;
        this.myAppend = append;
        this.myTailLevel = level;
        this.myTailChecks = tailChecks;
    }

    @Override
    public boolean isExprRoot(@NotNull List<PsiElement> path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/editor/SubstitutionDescriptorImpl", "isExprRoot"));
        }
        PsiElement el = (PsiElement)ContainerUtil.getLastItem(path);
        for (int i2 = this.myTailLevel; i2 < this.myHier.length; ++i2) {
            if (el == null || el.getNode() == null || el.getNode().getElementType() != this.myHier[i2]) {
                return false;
            }
            el = el.getParent();
        }
        return true;
    }

    @Override
    @Nullable
    public PsiElement getExprRoot(@NotNull PsiElement trigger2) {
        if (trigger2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trigger", "com/intellij/sql/editor/SubstitutionDescriptorImpl", "getExprRoot"));
        }
        PsiElement el = trigger2;
        PsiElement res = null;
        for (int i2 = 0; i2 < this.myHier.length; ++i2) {
            if (el == null || el.getNode() == null || el.getNode().getElementType() != this.myHier[i2]) {
                return null;
            }
            if (i2 == this.myTailLevel) {
                res = el;
            }
            el = el.getParent();
        }
        return res;
    }

    private static boolean check(@NotNull List<PsiElement> path, final @NotNull TailCheck check) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/editor/SubstitutionDescriptorImpl", "check"));
        }
        if (check == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "check", "com/intellij/sql/editor/SubstitutionDescriptorImpl", "check"));
        }
        return new Object(){
            int tailIdx;
            {
                this.tailIdx = check.size() - 1;
            }

            boolean visit(PsiElement el, int depth) {
                block4: {
                    boolean opt;
                    if (StringUtil.isEmptyOrSpaces((String)el.getText())) {
                        return true;
                    }
                    if (depth != check.depth(this.tailIdx)) {
                        for (el = el.getLastChild(); el != null && this.tailIdx >= 0; el = el.getPrevSibling()) {
                            if (this.visit(el, depth + 1)) continue;
                            return false;
                        }
                        return true;
                    }
                    do {
                        Object[] expected = check.get(this.tailIdx);
                        opt = check.isOpt(this.tailIdx);
                        boolean matched = expected.length == 0 || el.getNode() != null && ArrayUtil.contains((Object)el.getNode().getElementType(), (Object[])expected);
                        --this.tailIdx;
                        if (matched) break block4;
                    } while (opt);
                    return false;
                }
                return true;
            }

            boolean getResult(PsiElement root2) {
                return this.visit(root2, 0) && this.tailIdx < 0;
            }
        }.getResult((PsiElement)ContainerUtil.getLastItem(path));
    }

    @Override
    public boolean needsSubstitution(@NotNull List<PsiElement> path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/editor/SubstitutionDescriptorImpl", "needsSubstitution"));
        }
        for (TailCheck myTailCheck : this.myTailChecks) {
            if (!SubstitutionDescriptorImpl.check(path, myTailCheck)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Pair<String, String> getSubstitution(@NotNull List<PsiElement> path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/editor/SubstitutionDescriptorImpl", "getSubstitution"));
        }
        Pair pair = Pair.create((Object)this.myPrepend, (Object)this.myAppend);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/editor/SubstitutionDescriptorImpl", "getSubstitution"));
        }
        return pair;
    }

    public static class DelimiterAware
    extends SubstitutionDescriptorImpl {
        public DelimiterAware(IElementType[] hier, String prepend, String append, int level, TailCheck ... tailChecks) {
            super(hier, prepend, append, level, tailChecks);
        }

        @Override
        @NotNull
        public Pair<String, String> getSubstitution(@NotNull List<PsiElement> path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/sql/editor/SubstitutionDescriptorImpl$DelimiterAware", "getSubstitution"));
            }
            String delim = DbSqlUtil.getDelimiterAt(path.isEmpty() ? null : path.get(0).getContainingFile(), path.isEmpty() ? 0 : path.get(0).getTextOffset());
            if (DbSqlUtil.delimiterNeedsSpacing(delim)) {
                delim = " " + delim;
            }
            Pair pair = Pair.create((Object)this.myPrepend, (Object)(this.myAppend + delim));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/editor/SubstitutionDescriptorImpl$DelimiterAware", "getSubstitution"));
            }
            return pair;
        }
    }

    public static class TailCheckBuilder {
        private List<IElementType[]> myTail = ContainerUtil.newArrayList();
        private List<Integer> myItemDepths = ContainerUtil.newArrayList();
        private List<Boolean> myMask = ContainerUtil.newArrayList();
        private int myWidth = 0;

        public TailCheckBuilder add(int depth, boolean mand, IElementType ... elementTypes) {
            this.myTail.add(elementTypes);
            this.myMask.add(mand);
            this.myItemDepths.add(depth);
            this.myWidth = Math.max(this.myWidth, elementTypes.length);
            return this;
        }

        public TailCheckBuilder add(boolean mand, IElementType ... elementTypes) {
            return this.add(1, mand, elementTypes);
        }

        public TailCheckBuilder man(IElementType ... elementTypes) {
            return this.add(true, elementTypes);
        }

        public TailCheckBuilder opt(IElementType ... elementTypes) {
            return this.add(false, elementTypes);
        }

        public TailCheck build() {
            int[] depths = new int[this.myItemDepths.size()];
            boolean[] mask = new boolean[this.myMask.size()];
            for (int i2 = 0; i2 < depths.length; ++i2) {
                depths[i2] = this.myItemDepths.get(i2);
                mask[i2] = this.myMask.get(i2);
            }
            return TailCheck.from((IElementType[][])this.myTail.toArray((T[])new IElementType[this.myTail.size()][]), depths, mask);
        }
    }

    public static class TailCheck {
        private IElementType[][] myTail;
        private int[] myItemDepths;
        private boolean[] myMask;

        private TailCheck(@NotNull IElementType[][] tail) {
            if (tail == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tail", "com/intellij/sql/editor/SubstitutionDescriptorImpl$TailCheck", "<init>"));
            }
            this.myTail = tail;
        }

        public static TailCheck tail(IElementType ... tail) {
            if (tail == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tail", "com/intellij/sql/editor/SubstitutionDescriptorImpl$TailCheck", "tail"));
            }
            IElementType[][] res = new IElementType[tail.length][];
            for (int i2 = 0; i2 < res.length; ++i2) {
                res[i2] = new IElementType[]{tail[i2]};
            }
            return new TailCheck(res);
        }

        private static TailCheck from(IElementType[][] tail, int[] depths, boolean[] mask) {
            TailCheck res = new TailCheck(tail);
            res.myMask = mask;
            res.myItemDepths = depths;
            return res;
        }

        public TailCheck mask(boolean ... mand) {
            if (mand == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mand", "com/intellij/sql/editor/SubstitutionDescriptorImpl$TailCheck", "mask"));
            }
            this.myMask = mand;
            return this;
        }

        public boolean isOpt(int i2) {
            return this.myMask != null && this.myMask.length > i2 && !this.myMask[i2];
        }

        public int depth(int i2) {
            return this.myItemDepths != null && this.myItemDepths.length > i2 ? this.myItemDepths[i2] : 1;
        }

        @NotNull
        public IElementType[] get(int i2) {
            IElementType[] iElementTypeArray = this.myTail[i2];
            if (iElementTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/editor/SubstitutionDescriptorImpl$TailCheck", "get"));
            }
            return iElementTypeArray;
        }

        public int size() {
            return this.myTail.length;
        }

        public static TailCheckBuilder builder() {
            return new TailCheckBuilder();
        }
    }
}

