/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.sql.formatter.settings.SqlCodeStyleMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProvider", "getLanguage"));
        }
        return sqlLanguage;
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text) {
        return SqlCodeStyleMainPanel.createSqlFile(project, text);
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProvider", "getCodeSample"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            return "SELECT\n  col_x * 100 AS iddd,\n  id / 100,\n  88 + 2000,\n  id + 7         i\nFROM guest.indexed\nWHERE id <> 1 OR id > 10 OR id = 1;\n\nSELECT\n  decode(message_type, '1' ) AS mess_type,\n  messages_data.*,\n  test_table,\n  mess_type                                          AS m\nFROM messages_data;\n\nDELIMITER //\n\nCREATE FUNCTION SimpleCompare(n INT, m INT)\n  RETURNS VARCHAR(20)\n\n  BEGIN\n    DECLARE s VARCHAR(20);\n\n    IF n > m\n    THEN SET s = '>';\n    ELSEIF n = m\n      THEN SET s = '=';\n    ELSE SET s = '<';\n    END IF;\n\n    SET s = CONCAT(n, ' ', s, ' ', m);\n\n    RETURN s;\n  END //\n\nDELIMITER ; SELECT *\n            FROM (SELECT\n                    decode(message_type, '1') AS mess_type,\n                    messages_data.*,\n                    test_table,\n                    mess_type                                          AS m\n                  FROM messages_data\n            );";
        }
        return "-- DDL statement\nCREATE TABLE example_table (\n  bank_id      int          NOT NULL,\n  object       int          NOT NULL,\n  version      int          NOT NULL,\n  templ_id     int          NOT NULL,\n  namespace_id int          NOT NULL,\n  noname       int          NOT NULL,\n  description  varchar(200) NOT NULL,\n--  maybe        varchar(255)?\n  idx          int          NOT NULL);\n\nCREATE TABLE another_example (templ_id int NOT NULL);\n\nINSERT INTO example_table (bank_id, object, version, templ_id, namespace_id, noname, description, idx) VALUES ((SELECT max(bank_id) + 1\n     FROM example_table\n     WHERE bank_id IS NOT\n           NULL AND\n           SUBSTRING(bank_id, '^\\d+*$') AND\n           instr(bank_id, 1) != 1),\n    LAST_INSERT_ID(),\n    1,\n    (SELECT templ_id\n     FROM another_example\n     WHERE namespace_id = 'ALB-alb' AND noname = 'Edit Document'), 'Apple', 'Star', 'Sun', 'Y');";
    }

    public CommonCodeStyleSettings getDefaultCommonSettings() {
        CommonCodeStyleSettings sqlSettings = new CommonCodeStyleSettings(this.getLanguage());
        sqlSettings.KEEP_FIRST_COLUMN_COMMENT = false;
        CommonCodeStyleSettings.IndentOptions indentOptions = sqlSettings.initIndentOptions();
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        indentOptions.TAB_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
        return sqlSettings;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsType", "com/intellij/sql/formatter/settings/SqlLanguageCodeStyleSettingsProvider", "customizeSettings"));
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_PARENTHESES", "SPACE_AFTER_COMMA", "SPACE_BEFORE_COMMA"});
            consumer.showCustomOption(SqlCodeStyleSettings.class, "SPACES_AROUND_OPERATORS", "Spaces around operators", CodeStyleSettingsCustomizable.SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_CALL_PARENTHESES", "Call parentheses");
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_CALL_PARENTHESES", "Call parentheses");
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_PARENTHESES", "Declaration parentheses");
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_PARENTHESES", "Declaration parentheses");
            consumer.renameStandardOption("SPACE_WITHIN_PARENTHESES", "Parentheses expression");
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT"});
        }
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    private static class ShortLowercaseCodeStyle
    extends PredefinedCodeStyle {
        public ShortLowercaseCodeStyle() {
            super("Short with Lowercase", (Language)SqlLanguage.INSTANCE);
        }

        public void apply(CodeStyleSettings settings) {
            SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlCodeStyleSettings.class);
            sqlSettings.KEYWORD_CASE = 1;
        }
    }

    private static class ShortUppercaseCodeStyle
    extends PredefinedCodeStyle {
        public ShortUppercaseCodeStyle() {
            super("Short with Uppercase", (Language)SqlLanguage.INSTANCE);
        }

        public void apply(CodeStyleSettings settings) {
            SqlCodeStyleSettings sqlSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlCodeStyleSettings.class);
            sqlSettings.KEYWORD_CASE = 0;
        }
    }
}

