/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.sql.util.NameTemplate;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBTextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class TemplateEditorWithHelp
extends JBTextField {
    private final String myHintText;
    private final NameTemplate myDefaultTemplate;
    private final String myShortcutHelp;

    public TemplateEditorWithHelp(@NotNull NameTemplate defaultTemplate) {
        if (defaultTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTemplate", "com/intellij/sql/formatter/settings/TemplateEditorWithHelp", "<init>"));
        }
        this.myDefaultTemplate = defaultTemplate;
        this.myHintText = TemplateEditorWithHelp.createHint(defaultTemplate);
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"QuickJavaDoc").getShortcuts();
        this.myShortcutHelp = shortcuts.length == 0 ? "" : "\n" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " for help";
        new AnAction("Help"){

            public void actionPerformed(AnActionEvent e) {
                TemplateEditorWithHelp.this.showHint();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts), (JComponent)((Object)this));
        this.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                TemplateEditorWithHelp.this.updateExample();
            }
        });
    }

    @NotNull
    private static String createHint(@NotNull NameTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/sql/formatter/settings/TemplateEditorWithHelp", "createHint"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Template can contain:<ul>");
        for (NameTemplate.Placeholder placeholder : template.allowed) {
            sb.append("<li><b>").append(placeholder.text).append("</b> - ").append(placeholder.desc).append(";</li>");
        }
        sb.append("</ul>");
        sb.append("Example: ").append(template.template);
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/TemplateEditorWithHelp", "createHint"));
        }
        return string;
    }

    public void showHint() {
        JBPopupFactory.getInstance().createBalloonBuilder(HintUtil.createInformationLabel((String)this.myHintText)).setFillColor(HintUtil.getInformationColor()).setHideOnClickOutside(true).setHideOnAction(true).setClickHandler(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/formatter/settings/TemplateEditorWithHelp$3", "actionPerformed"));
                }
            }
        }, true).createBalloon().show(RelativePoint.getSouthWestOf((JComponent)((Object)this)), Balloon.Position.below);
    }

    private void updateExample() {
        String tip = "Ex. name: " + NameTemplate.example((String)this.getText(), (NameTemplate.Placeholder[])this.myDefaultTemplate.allowed) + this.myShortcutHelp;
        this.setToolTipText(tip);
    }
}

