/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiReference;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralConcatenation;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlLiteralExpressionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralEscaper;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStringLiteralExpressionImpl
extends SqlLiteralExpressionImpl
implements SqlStringLiteralExpression,
PsiLiteralValue {
    public SqlStringLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl", "<init>"));
        }
        super(node);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlStringLiteralExpression((SqlStringLiteralExpression)this);
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlPrimitiveType sqlPrimitiveType = SqlType.STRING;
        if (sqlPrimitiveType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl", "getSqlType"));
        }
        return sqlPrimitiveType;
    }

    public PsiReference getReference() {
        ElementManipulator manipulator;
        final PsiElement parent = this.getParent();
        if (!(parent instanceof SqlOrderByClause) && !(parent instanceof SqlGroupByClause)) {
            return super.getReference();
        }
        if (parent instanceof SqlStringLiteralConcatenation) {
            return super.getReference();
        }
        final SqlStringTokenElement stringToken = SqlStringLiteralManipulator.getStringToken(this);
        SqlReferenceImpl reference = new SqlReferenceImpl((SqlElement)this, manipulator = ElementManipulators.getManipulator((PsiElement)this)){
            final /* synthetic */ ElementManipulator val$manipulator;
            {
                this.val$manipulator = elementManipulator;
                super(element);
            }

            @Override
            protected boolean shouldProcessFunctionVariants() {
                return false;
            }

            @Override
            public SqlExpression getQualifierExpression() {
                return parent instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getQualifierExpression() : null;
            }

            @Override
            public String getReferenceName() {
                return stringToken == null ? "" : stringToken.getTokenText();
            }

            public TextRange getRangeInElement() {
                return this.val$manipulator.getRangeInElement((PsiElement)SqlStringLiteralExpressionImpl.this);
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                return this.val$manipulator.handleContentChange((PsiElement)SqlStringLiteralExpressionImpl.this, newElementName);
            }
        };
        if (reference.resolve() != null) {
            return reference;
        }
        return super.getReference();
    }

    @Nullable
    public Object getValue() {
        SqlStringTokenElement stringToken = SqlStringLiteralManipulator.getStringToken(this);
        return stringToken == null ? null : stringToken.getTokenText();
    }

    public boolean isValidHost() {
        return true;
    }

    public SqlStringLiteralExpressionImpl updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl", "updateText"));
        }
        SqlExpression expression = SqlPsiElementFactory.createExpressionFromText(text, SqlImplUtil.getSqlDialectSafe((PsiElement)this), (PsiElement)this);
        assert (expression instanceof SqlStringLiteralExpression) : text + "-->" + expression;
        return (SqlStringLiteralExpressionImpl)this.replace((PsiElement)expression);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        SqlStringLiteralEscaper sqlStringLiteralEscaper = new SqlStringLiteralEscaper(this);
        if (sqlStringLiteralEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlStringLiteralExpressionImpl", "createLiteralTextEscaper"));
        }
        return sqlStringLiteralEscaper;
    }
}

