/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.parser;

import com.intellij.lang.ITokenTypeRemapper;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BidirectionalTokenMapper {
    private final ITokenTypeRemapper myDirect;
    private final ITokenTypeRemapper myReverse;

    @NotNull
    public static Builder builder() {
        Builder builder = new Builder();
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/BidirectionalTokenMapper", "builder"));
        }
        return builder;
    }

    @NotNull
    public ITokenTypeRemapper getDirect() {
        ITokenTypeRemapper iTokenTypeRemapper = this.myDirect;
        if (iTokenTypeRemapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/BidirectionalTokenMapper", "getDirect"));
        }
        return iTokenTypeRemapper;
    }

    @NotNull
    public ITokenTypeRemapper getReverse() {
        ITokenTypeRemapper iTokenTypeRemapper = this.myReverse;
        if (iTokenTypeRemapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/BidirectionalTokenMapper", "getReverse"));
        }
        return iTokenTypeRemapper;
    }

    private BidirectionalTokenMapper(Map<IElementType, IElementType> direct, Map<IElementType, IElementType> reverse) {
        this.myDirect = new MapTokenRemapper(direct);
        this.myReverse = new MapTokenRemapper(reverse);
    }

    private static class MapTokenRemapper
    implements ITokenTypeRemapper {
        private final Map<IElementType, IElementType> myMap;

        private MapTokenRemapper(Map<IElementType, IElementType> map) {
            this.myMap = map;
        }

        public IElementType filter(IElementType source, int start, int end, CharSequence text) {
            return this.myMap.containsKey(source) ? this.myMap.get(source) : source;
        }
    }

    public static class Builder {
        private final ContainerUtil.ImmutableMapBuilder<IElementType, IElementType> myDirect = ContainerUtil.immutableMapBuilder();
        private final ContainerUtil.ImmutableMapBuilder<IElementType, IElementType> myReverse = ContainerUtil.immutableMapBuilder();

        private Builder() {
        }

        @NotNull
        public Builder add(IElementType from, IElementType to) {
            this.myDirect.put((Object)from, (Object)to);
            this.myReverse.put((Object)to, (Object)from);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/BidirectionalTokenMapper$Builder", "add"));
            }
            return builder;
        }

        @NotNull
        public BidirectionalTokenMapper build() {
            BidirectionalTokenMapper bidirectionalTokenMapper = new BidirectionalTokenMapper(this.myDirect.build(), this.myReverse.build());
            if (bidirectionalTokenMapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/parser/BidirectionalTokenMapper$Builder", "build"));
            }
            return bidirectionalTokenMapper;
        }
    }
}

