/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.aspectj.highlight.analysis.ElementAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.aspect.AspectFullyParameterizedAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.aspect.GenericAspectAbstractAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.aspect.NestedAspectStaticAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.member.AspectConstructorParamsAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.member.DuplicateFieldsInAspectAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.member.DuplicateFieldsInClassAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.member.DuplicateMethodsInAspectAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.member.DuplicateMethodsInClassAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.member.InterTypeModifiersAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.member.SuperConstructorCallAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.ref.AspectInheritanceAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.ref.NonStaticAspectMemberAccessAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.ref.PrivateMemberAccessAnnotator;
import com.intellij.lang.aspectj.highlight.analysis.ref.TypeReferenceListAnnotator1;
import com.intellij.lang.aspectj.highlight.analysis.ref.TypeReferenceListAnnotator2;
import com.intellij.lang.aspectj.highlight.analysis.ref.WrongTargetAnnotator;
import com.intellij.lang.aspectj.psi.AjElementVisitor;
import com.intellij.lang.aspectj.psi.PsiAspect;
import com.intellij.lang.aspectj.psi.PsiInterTypeField;
import com.intellij.lang.aspectj.psi.PsiInterTypeMethod;
import com.intellij.lang.aspectj.psi.PsiInterTypeReference;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.List;

public class AjAnnotatingVisitor
extends AjElementVisitor {
    private static final List<? extends ElementAnnotator<PsiAspect>> ASPECT_ANNOTATORS = Arrays.asList(new NestedAspectStaticAnnotator(), new GenericAspectAbstractAnnotator(), new AspectFullyParameterizedAnnotator());
    private static final List<? extends ElementAnnotator<PsiField>> IT_FIELD_ANNOTATORS = Arrays.asList(new InterTypeModifiersAnnotator(), new DuplicateFieldsInClassAnnotator());
    private static final List<? extends ElementAnnotator<PsiField>> FIELD_ANNOTATORS = Arrays.asList(new DuplicateFieldsInAspectAnnotator());
    private static final List<? extends ElementAnnotator<PsiMethod>> IT_METHOD_ANNOTATORS = Arrays.asList(new InterTypeModifiersAnnotator(), new DuplicateMethodsInClassAnnotator(), new SuperConstructorCallAnnotator());
    private static final List<? extends ElementAnnotator<PsiMethod>> METHOD_ANNOTATORS = Arrays.asList(new AspectConstructorParamsAnnotator(), new DuplicateMethodsInAspectAnnotator());
    private static final List<? extends ElementAnnotator<PsiInterTypeReference>> IT_ANNOTATORS = Arrays.asList(new TypeReferenceListAnnotator2());
    private static final List<? extends ElementAnnotator<PsiJavaCodeReferenceElement>> REF_ANNOTATORS = Arrays.asList(new PrivateMemberAccessAnnotator(), new AspectInheritanceAnnotator(), new WrongTargetAnnotator(), new NonStaticAspectMemberAccessAnnotator());
    private static final List<? extends ElementAnnotator<PsiIdentifier>> ID_ANNOTATORS = Arrays.asList(new TypeReferenceListAnnotator1());
    private final AnnotationHolder myHolder;

    public AjAnnotatingVisitor(AnnotationHolder holder) {
        this.myHolder = holder;
    }

    @Override
    public void visitAspect(PsiAspect aspect) {
        super.visitAspect(aspect);
        ElementAnnotator.annotate(ASPECT_ANNOTATORS, this.myHolder, aspect);
    }

    @Override
    public void visitInterTypeField(PsiInterTypeField field) {
        super.visitInterTypeField(field);
        ElementAnnotator.annotate(IT_FIELD_ANNOTATORS, this.myHolder, field);
    }

    public void visitField(PsiField field) {
        super.visitField(field);
        ElementAnnotator.annotate(FIELD_ANNOTATORS, this.myHolder, field);
    }

    @Override
    public void visitInterTypeMethod(PsiInterTypeMethod method) {
        super.visitInterTypeMethod(method);
        ElementAnnotator.annotate(IT_METHOD_ANNOTATORS, this.myHolder, method);
    }

    public void visitMethod(PsiMethod method) {
        super.visitMethod(method);
        ElementAnnotator.annotate(METHOD_ANNOTATORS, this.myHolder, method);
    }

    @Override
    public void visitInterTypeReference(PsiInterTypeReference reference) {
        super.visitInterTypeReference(reference);
        ElementAnnotator.annotate(IT_ANNOTATORS, this.myHolder, reference);
    }

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        super.visitReferenceElement(reference);
        if (reference.getParent() instanceof PsiJavaCodeReferenceElement) {
            return;
        }
        ElementAnnotator.annotate(REF_ANNOTATORS, this.myHolder, reference);
    }

    public void visitIdentifier(PsiIdentifier identifier) {
        super.visitIdentifier(identifier);
        ElementAnnotator.annotate(ID_ANNOTATORS, this.myHolder, identifier);
    }
}

