/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.Cache;
import android.support.constraint.solver.SolverVariable;
import java.util.Arrays;

class ArrayBackedVariables {
    private static final boolean DEBUG = false;
    private SolverVariable[] variables = new SolverVariable[this.maxSize];
    private float[] values = new float[this.maxSize];
    private int[] indexes = new int[this.maxSize];
    private final int threshold = 16;
    private int maxSize = 4;
    private int currentSize = 0;
    private int currentWriteSize = 0;
    private SolverVariable candidate = null;

    public ArrayBackedVariables(ArrayRow arrayRow, Cache cache) {
    }

    public SolverVariable getPivotCandidate() {
        if (this.candidate == null) {
            for (int i = 0; i < this.currentSize; ++i) {
                int idx = this.indexes[i];
                if (!(this.values[idx] < 0.0f)) continue;
                this.candidate = this.variables[idx];
                break;
            }
        }
        return this.candidate;
    }

    void increaseSize() {
        this.maxSize *= 2;
        this.variables = Arrays.copyOf(this.variables, this.maxSize);
        this.values = Arrays.copyOf(this.values, this.maxSize);
        this.indexes = Arrays.copyOf(this.indexes, this.maxSize);
    }

    public final int size() {
        return this.currentSize;
    }

    public final SolverVariable getVariable(int index) {
        return this.variables[this.indexes[index]];
    }

    public final float getVariableValue(int index) {
        return this.values[this.indexes[index]];
    }

    public final void updateArray(ArrayBackedVariables target, float amount) {
        if (amount == 0.0f) {
            return;
        }
        for (int i = 0; i < this.currentSize; ++i) {
            int idx = this.indexes[i];
            SolverVariable v = this.variables[idx];
            float value = this.values[idx];
            target.add(v, value * amount);
        }
    }

    public void setVariable(int index, float value) {
        int idx = this.indexes[index];
        this.values[idx] = value;
        if (value < 0.0f) {
            this.candidate = this.variables[idx];
        }
    }

    public final float get(SolverVariable v) {
        if (this.currentSize < 16) {
            for (int i = 0; i < this.currentSize; ++i) {
                int idx = this.indexes[i];
                if (this.variables[idx] != v) continue;
                return this.values[idx];
            }
        } else {
            int start = 0;
            int end = this.currentSize - 1;
            while (start <= end) {
                int index = start + (end - start) / 2;
                int idx = this.indexes[index];
                SolverVariable current = this.variables[idx];
                if (current == v) {
                    return this.values[idx];
                }
                if (current.id < v.id) {
                    start = index + 1;
                    continue;
                }
                end = index - 1;
            }
        }
        return 0.0f;
    }

    public void put(SolverVariable variable, float value) {
        if (value == 0.0f) {
            this.remove(variable);
            return;
        }
        while (true) {
            int firstEmptyIndex = -1;
            for (int i = 0; i < this.currentWriteSize; ++i) {
                if (this.variables[i] == variable) {
                    this.values[i] = value;
                    if (value < 0.0f) {
                        this.candidate = variable;
                    }
                    return;
                }
                if (firstEmptyIndex != -1 || this.variables[i] != null) continue;
                firstEmptyIndex = i;
            }
            if (firstEmptyIndex == -1 && this.currentWriteSize < this.maxSize) {
                firstEmptyIndex = this.currentWriteSize;
            }
            if (firstEmptyIndex != -1) {
                this.variables[firstEmptyIndex] = variable;
                this.values[firstEmptyIndex] = value;
                boolean inserted = false;
                for (int j = 0; j < this.currentSize; ++j) {
                    int index = this.indexes[j];
                    if (this.variables[index].id <= variable.id) continue;
                    System.arraycopy(this.indexes, j, this.indexes, j + 1, this.currentSize - j);
                    this.indexes[j] = firstEmptyIndex;
                    inserted = true;
                    break;
                }
                if (!inserted) {
                    this.indexes[this.currentSize] = firstEmptyIndex;
                }
                ++this.currentSize;
                if (firstEmptyIndex + 1 > this.currentWriteSize) {
                    this.currentWriteSize = firstEmptyIndex + 1;
                }
                if (value < 0.0f) {
                    this.candidate = variable;
                }
                return;
            }
            this.increaseSize();
        }
    }

    public void add(SolverVariable variable, float value) {
        if (value == 0.0f) {
            return;
        }
        while (true) {
            int firstEmptyIndex = -1;
            for (int i = 0; i < this.currentWriteSize; ++i) {
                if (this.variables[i] == variable) {
                    int n = i;
                    this.values[n] = this.values[n] + value;
                    if (value < 0.0f) {
                        this.candidate = variable;
                    }
                    if (this.values[i] == 0.0f) {
                        this.remove(variable);
                    }
                    return;
                }
                if (firstEmptyIndex != -1 || this.variables[i] != null) continue;
                firstEmptyIndex = i;
            }
            if (firstEmptyIndex == -1 && this.currentWriteSize < this.maxSize) {
                firstEmptyIndex = this.currentWriteSize;
            }
            if (firstEmptyIndex != -1) {
                this.variables[firstEmptyIndex] = variable;
                this.values[firstEmptyIndex] = value;
                boolean inserted = false;
                for (int j = 0; j < this.currentSize; ++j) {
                    int index = this.indexes[j];
                    if (this.variables[index].id <= variable.id) continue;
                    System.arraycopy(this.indexes, j, this.indexes, j + 1, this.currentSize - j);
                    this.indexes[j] = firstEmptyIndex;
                    inserted = true;
                    break;
                }
                if (!inserted) {
                    this.indexes[this.currentSize] = firstEmptyIndex;
                }
                ++this.currentSize;
                if (firstEmptyIndex + 1 > this.currentWriteSize) {
                    this.currentWriteSize = firstEmptyIndex + 1;
                }
                if (value < 0.0f) {
                    this.candidate = variable;
                }
                return;
            }
            this.increaseSize();
        }
    }

    public void clear() {
        int length = this.variables.length;
        for (int i = 0; i < length; ++i) {
            this.variables[i] = null;
        }
        this.currentSize = 0;
        this.currentWriteSize = 0;
    }

    public boolean containsKey(SolverVariable variable) {
        if (this.currentSize < 8) {
            for (int i = 0; i < this.currentSize; ++i) {
                if (this.variables[this.indexes[i]] != variable) continue;
                return true;
            }
        } else {
            int start = 0;
            int end = this.currentSize - 1;
            while (start <= end) {
                int index = start + (end - start) / 2;
                SolverVariable current = this.variables[this.indexes[index]];
                if (current == variable) {
                    return true;
                }
                if (current.id < variable.id) {
                    start = index + 1;
                    continue;
                }
                end = index - 1;
            }
        }
        return false;
    }

    public float remove(SolverVariable variable) {
        if (this.candidate == variable) {
            this.candidate = null;
        }
        for (int i = 0; i < this.currentWriteSize; ++i) {
            int idx = this.indexes[i];
            if (this.variables[idx] != variable) continue;
            float amount = this.values[idx];
            this.variables[idx] = null;
            System.arraycopy(this.indexes, i + 1, this.indexes, i, this.currentWriteSize - i - 1);
            --this.currentSize;
            return amount;
        }
        return 0.0f;
    }

    public int sizeInBytes() {
        int size = 0;
        size += this.maxSize * 4;
        size += this.maxSize * 4;
        size += this.maxSize * 4;
        return size += 16;
    }

    public void display() {
        int count = this.size();
        System.out.print("{ ");
        for (int i = 0; i < count; ++i) {
            System.out.print(this.getVariable(i) + " = " + this.getVariableValue(i) + " ");
        }
        System.out.println(" }");
    }

    private String getInternalArrays() {
        int i;
        String str = "";
        int count = this.size();
        str = str + "idx { ";
        for (i = 0; i < count; ++i) {
            str = str + this.indexes[i] + " ";
        }
        str = str + "}\n";
        str = str + "obj { ";
        for (i = 0; i < count; ++i) {
            str = str + this.variables[i] + ":" + this.values[i] + " ";
        }
        str = str + "}\n";
        return str;
    }

    public void displayInternalArrays() {
        int i;
        int count = this.size();
        System.out.print("idx { ");
        for (i = 0; i < count; ++i) {
            System.out.print(this.indexes[i] + " ");
        }
        System.out.println("}");
        System.out.print("obj { ");
        for (i = 0; i < count; ++i) {
            System.out.print(this.variables[i] + ":" + this.values[i] + " ");
        }
        System.out.println("}");
    }

    public void updateFromRow(ArrayRow arrayRow, ArrayRow definition) {
    }

    public SolverVariable pickPivotCandidate() {
        return null;
    }

    public void updateFromSystem(ArrayRow goal, ArrayRow[] mRows) {
    }

    public void divideByAmount(float amount) {
    }

    public void updateClientEquations(ArrayRow arrayRow) {
    }

    public boolean hasAtLeastOnePositiveVariable() {
        return false;
    }

    public void invert() {
    }
}

