/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.impl.contextchooser;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsp.impl.contextchooser.JspContextChooserPanel;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.JspContextManager;
import com.intellij.psi.jsp.BaseJspFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspContextChooserPanelProvider
implements HectorComponentPanelsProvider {
    private final JspContextManager myContextManager;

    public JspContextChooserPanelProvider(JspContextManager contextManager) {
        this.myContextManager = contextManager;
    }

    @Nullable
    public HectorComponentPanel createConfigurable(@NotNull PsiFile file) {
        boolean isJsp;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsp/impl/contextchooser/JspContextChooserPanelProvider", "createConfigurable"));
        }
        Language language = file.getLanguage();
        boolean bl = isJsp = StdLanguages.JSPX == language || StdLanguages.JSP == language;
        if (isJsp || StdLanguages.HTML == language || StdLanguages.XHTML == language) {
            BaseJspFile[] contextFiles = this.myContextManager.getSuitableContextFiles(file);
            WebFacet webFacet = WebUtil.getWebFacet((PsiElement)file);
            if (isJsp || webFacet != null && WebUtil.isInsideWebRoots((VirtualFile)file.getVirtualFile(), (List)webFacet.getWebRoots()) && WebUtil.getWebUtil().getParentWebDirectory(file) != null) {
                return new JspContextChooserPanel(file, contextFiles, this.myContextManager);
            }
        }
        return null;
    }
}

