/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.jsp.impl.TldTagDescriptor;
import com.intellij.lang.jsp.BaseJspManager;
import com.intellij.lang.jsp.JspVersion;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.TaglibIndex;
import com.intellij.psi.impl.source.jsp.TaglibUriCacheProvider;
import com.intellij.psi.impl.source.jsp.TaglibsModificationTracker;
import com.intellij.psi.impl.source.jsp.TldProcessorFactory;
import com.intellij.psi.impl.source.jsp.TldProvider;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="JspManager")
public class JspManagerImpl
extends JspManager
implements PersistentStateComponent<State> {
    @NonNls
    private static final String RELATIVE_PATH_NS_PREFIX = "urn:jsptld:";
    @NonNls
    public static final String[] myTagLibProviderNames = new String[]{"function-class", "tag-class", "tei-class", "variable-class", "type", "path", "function-signature", "name", "name-given", "handler-class", "library-class", "tag-name", "function-name", "source"};
    private final UserDataCache<CachedValue<UriFactoryMap>, Module, JspFile> myTaglibsUriProvider;
    private final UserDataCache<CachedValue<UriFactoryMap>, JspFile, Module> myLocalTaglibsUriProvider;
    private final UserDataCache<CachedValue<MultiMap<String, String>>, Module, JspFile> myTagNamesMap;
    private final Project myProject;
    private final State myState = new State();

    public XmlNSDescriptor getActionsLibrary(@NotNull PsiFile containingFile) {
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getActionsLibrary"));
        }
        return BaseJspManager.getInstance(this.myProject).getActionsLibrary(this.getJspVersion((PsiFileSystemItem)containingFile));
    }

    public XmlElementDescriptor getDirectiveDescriptorByName(String name, @NotNull PsiFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getDirectiveDescriptorByName"));
        }
        return BaseJspManager.getInstance(this.myProject).getDirectiveDescriptorByName(name, this.getJspVersion((PsiFileSystemItem)context));
    }

    public static JspManagerImpl getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getInstance"));
        }
        return (JspManagerImpl)JspManager.getInstance((Project)project);
    }

    private void visitTaglibFiles(@NotNull JspFile context, TaglibFileVisitor visitor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "visitTaglibFiles"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module != null) {
            Collection<XmlFile> files = this.getPossibleTldFiles(module);
            for (XmlFile file : files) {
                TldDescriptor xmlNSDescriptor;
                String uri = TaglibUriCacheProvider.getUri(file);
                XmlDocument document = file.getDocument();
                if (uri == null || document == null || (xmlNSDescriptor = (TldDescriptor)document.getMetaData()) == null) continue;
                visitor.visit(uri, xmlNSDescriptor, document);
            }
        }
    }

    @NotNull
    public Set<String> getNamespacesByTagName(final @NotNull String tagName, @NotNull JspFile context, boolean showProgress) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getNamespacesByTagName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getNamespacesByTagName"));
        }
        final LinkedHashSet<String> strings = new LinkedHashSet<String>();
        this.visitTaglibFiles(context, new TaglibFileVisitor(){

            @Override
            public void visit(@NotNull String uri, @NotNull TldDescriptor descriptor, @NotNull XmlDocument document) {
                XmlElementDescriptor[] descriptors;
                if (uri == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/psi/impl/source/jsp/JspManagerImpl$1", "visit"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/impl/source/jsp/JspManagerImpl$1", "visit"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/jsp/JspManagerImpl$1", "visit"));
                }
                for (XmlElementDescriptor elementDescriptor : descriptors = descriptor.getRootElementsDescriptors(document)) {
                    if (!(elementDescriptor instanceof TldTagDescriptor) || !tagName.equals(elementDescriptor.getDefaultName())) continue;
                    strings.add(uri);
                }
            }
        });
        LinkedHashSet<String> linkedHashSet = strings;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getNamespacesByTagName"));
        }
        return linkedHashSet;
    }

    @NotNull
    public Set<String> getNamespacesByFunctionName(final @NotNull String functionName, @NotNull JspFile context, boolean showProgress) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getNamespacesByFunctionName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getNamespacesByFunctionName"));
        }
        final LinkedHashSet<String> strings = new LinkedHashSet<String>();
        this.visitTaglibFiles(context, new TaglibFileVisitor(){

            @Override
            public void visit(@NotNull String uri, @NotNull TldDescriptor descriptor, @NotNull XmlDocument document) {
                String[] names;
                if (uri == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/psi/impl/source/jsp/JspManagerImpl$2", "visit"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/impl/source/jsp/JspManagerImpl$2", "visit"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/jsp/JspManagerImpl$2", "visit"));
                }
                for (String name : names = descriptor.getFunctionNames()) {
                    if (name == null || !name.equals(functionName)) continue;
                    strings.add(uri);
                    break;
                }
            }
        });
        LinkedHashSet<String> linkedHashSet = strings;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getNamespacesByFunctionName"));
        }
        return linkedHashSet;
    }

    public ModificationTracker getRootsModificationTracker() {
        return ProjectRootManager.getInstance((Project)this.myProject);
    }

    public JspManagerImpl(Project project, final CachedValuesManager valuesManager) {
        this.myProject = project;
        TaglibsModificationTracker taglibsModificationTracker = new TaglibsModificationTracker(project);
        final Object[] dependencies = new Object[]{this.getRootsModificationTracker(), taglibsModificationTracker, ExternalResourceManager.getInstance()};
        this.myTaglibsUriProvider = new UserDataCache<CachedValue<UriFactoryMap>, Module, JspFile>(){

            protected CachedValue<UriFactoryMap> compute(Module module, JspFile context) {
                SmartPsiElementPointer pointer = context == null ? null : SmartPointerManager.getInstance((Project)JspManagerImpl.this.myProject).createSmartPsiElementPointer((PsiElement)context);
                return valuesManager.createCachedValue((CachedValueProvider)new UriFactoryMapCachedValueProvider(module, pointer, dependencies), false);
            }
        };
        this.myLocalTaglibsUriProvider = new UserDataCache<CachedValue<UriFactoryMap>, JspFile, Module>(){

            protected CachedValue<UriFactoryMap> compute(@NotNull JspFile context, Module module) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspManagerImpl$4", "compute"));
                }
                SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)JspManagerImpl.this.myProject).createSmartPsiElementPointer((PsiElement)context);
                return valuesManager.createCachedValue(() -> {
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspManagerImpl$4", "lambda$compute$0"));
                    }
                    if (module == null) {
                        return new CachedValueProvider.Result(null, dependencies);
                    }
                    WebFacet webFacet = WebUtil.getWebFacet((PsiElement)context);
                    if (webFacet == null) {
                        return new CachedValueProvider.Result(null, dependencies);
                    }
                    return new CachedValueProvider.Result((Object)new UriFactoryMap(module, (SmartPsiElementPointer<JspFile>)pointer, TldProvider.MAPPED, TldProvider.LOCAL, TldProvider.WEB), new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, JspManagerImpl.this.getRootsModificationTracker(), ExternalResourceManager.getInstance()});
                }, false);
            }
        };
        this.myTagNamesMap = new UserDataCache<CachedValue<MultiMap<String, String>>, Module, JspFile>("jsp tag names"){

            protected CachedValue<MultiMap<String, String>> compute(Module module, JspFile p) {
                return valuesManager.createCachedValue(() -> new CachedValueProvider.Result((Object)JspManagerImpl.this.computeTagNames(module), dependencies), false);
            }
        };
    }

    private MultiMap<String, String> computeTagNames(Module module) {
        Collection<XmlFile> files = this.getPossibleTldFiles(module);
        ConcurrentMultiMap map = new ConcurrentMultiMap();
        for (XmlFile file : files) {
            XmlElementDescriptor[] descriptors;
            String uri = TaglibUriCacheProvider.getUri(file);
            if (StringUtil.isEmpty((String)uri)) continue;
            XmlDocument document = file.getDocument();
            assert (document != null);
            XmlNSDescriptor xmlNSDescriptor = (XmlNSDescriptor)document.getMetaData();
            if (xmlNSDescriptor == null) continue;
            for (XmlElementDescriptor elementDescriptor : descriptors = xmlNSDescriptor.getRootElementsDescriptors(document)) {
                if (!(elementDescriptor instanceof TldTagDescriptor)) continue;
                map.putValue((Object)elementDescriptor.getDefaultName(), (Object)uri);
            }
        }
        return map;
    }

    public Project getProject() {
        return this.myProject;
    }

    private UriFactoryMap getTaglibUrisMap(Module module, @Nullable JspFile context) {
        Key<CachedValue<UriFactoryMap>> key = TldProcessorFactory.getUserDataKey(context);
        UriFactoryMap map = (UriFactoryMap)((Object)((CachedValue)this.myTaglibsUriProvider.get(key, (UserDataHolder)module, (Object)context)).getValue());
        assert (map != null);
        return map;
    }

    @NotNull
    public JspVersion getJspVersion(@NotNull PsiFileSystemItem file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getJspVersion"));
        }
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)file.getVirtualFile(), (Project)file.getProject());
        JspVersion jspVersion = webFacet == null ? JspVersion.MAX_VERSION : webFacet.getWebAppVersion().getJspVersion();
        if (jspVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getJspVersion"));
        }
        return jspVersion;
    }

    public boolean isElIgnored(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "isElIgnored"));
        }
        return WebUtil.processMatchingJspGroups((PsiFile)file, group -> {
            Boolean value = (Boolean)group.getElIgnored().getValue();
            return value == null || value == false;
        });
    }

    public XmlFile getImplicitXmlTagLibraryFile() {
        return BaseJspUtil.getResource("jspxml.tld", this.myProject, ((Object)((Object)this)).getClass());
    }

    public String[] getPossibleTldUris(JspFile context) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        UriFactoryMap map = this.getTaglibUrisMap(module, context);
        if (!map.isCompleted()) {
            JspManagerImpl.processUris(module, map, context);
        }
        return map.getUris();
    }

    @NotNull
    public MultiMap<String, String> getAvailableTagNames(@NotNull JspFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getAvailableTagNames"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            MultiMap multiMap = new MultiMap();
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getAvailableTagNames"));
            }
            return multiMap;
        }
        MultiMap map = (MultiMap)((CachedValue)this.myTagNamesMap.get((UserDataHolder)module, (Object)context)).getValue();
        MultiMap multiMap = map == null ? new MultiMap() : map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getAvailableTagNames"));
        }
        return multiMap;
    }

    @NotNull
    public List<Pair<String, String>> getAvailableFunctions(@NotNull JspFile context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getAvailableFunctions"));
        }
        final ArrayList<Pair<String, String>> set = new ArrayList<Pair<String, String>>();
        this.visitTaglibFiles(context, new TaglibFileVisitor(){

            @Override
            public void visit(@NotNull String uri, @NotNull TldDescriptor descriptor, @NotNull XmlDocument document) {
                String[] names;
                if (uri == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/psi/impl/source/jsp/JspManagerImpl$6", "visit"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/psi/impl/source/jsp/JspManagerImpl$6", "visit"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/psi/impl/source/jsp/JspManagerImpl$6", "visit"));
                }
                for (String name : names = descriptor.getFunctionNames()) {
                    set.add(Pair.create((Object)name, (Object)uri));
                }
            }
        });
        ArrayList<Pair<String, String>> arrayList = set;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getAvailableFunctions"));
        }
        return arrayList;
    }

    public String getPrefixForNamespace(@NotNull String namespaceUri, @NotNull JspFile context) {
        if (namespaceUri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespaceUri", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getPrefixForNamespace"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getPrefixForNamespace"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context);
        if (module == null) {
            return null;
        }
        UriFactoryMap map = this.getTaglibUrisMap(module, context);
        XmlFile xmlFile = map.get(namespaceUri);
        return xmlFile == null ? null : this.getDefaultPrefix(xmlFile);
    }

    public String getDefaultPrefix(@NotNull XmlFile taglibFile) {
        TldDescriptor descriptor;
        if (taglibFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taglibFile", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getDefaultPrefix"));
        }
        XmlDocument document = taglibFile.getDocument();
        if (document != null && (descriptor = (TldDescriptor)document.getMetaData()) != null) {
            return descriptor.getDefaultPrefix();
        }
        return null;
    }

    public String[] getPossibleTldUris(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getPossibleTldUris"));
        }
        UriFactoryMap map = this.getTaglibUrisMap(module, null);
        if (!map.isCompleted()) {
            JspManagerImpl.processUris(module, map, null);
        }
        return map.getUris();
    }

    @NotNull
    public Collection<XmlFile> getPossibleTldFiles(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getPossibleTldFiles"));
        }
        UriFactoryMap map = this.getTaglibUrisMap(module, null);
        if (!map.isCompleted()) {
            JspManagerImpl.processUris(module, map, null);
        }
        Collection collection = map.notNullValues();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getPossibleTldFiles"));
        }
        return collection;
    }

    @Nullable
    public String getTaglibUri(@NotNull XmlFile taglibFile) {
        if (taglibFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taglibFile", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getTaglibUri"));
        }
        return TaglibUriCacheProvider.getUri(taglibFile);
    }

    private static void processUris(@NotNull Module module, UriFactoryMap map, @Nullable JspFile context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "processUris"));
        }
        for (TldProvider provider : TldProvider.ALL) {
            provider.collectUris(module, map, context);
        }
        map.setCompleted(true);
    }

    @Nullable
    public XmlFile getTldFileByUri(String uri, @NotNull JspFile jspFile) {
        if (jspFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jspFile", "com/intellij/psi/impl/source/jsp/JspManagerImpl", "getTldFileByUri"));
        }
        return this.getTldFileByUri(uri, ModuleUtilCore.findModuleForPsiElement((PsiElement)jspFile), jspFile);
    }

    @Nullable
    public synchronized XmlFile getTldFileByUri(String uri, @Nullable Module module, @Nullable JspFile context) {
        XmlFile xmlFile;
        UriFactoryMap map;
        if (module == null || module.isDisposed()) {
            return null;
        }
        boolean local = StringUtil.startsWithChar((CharSequence)uri, (char)'.');
        if (!local && uri.startsWith(RELATIVE_PATH_NS_PREFIX)) {
            uri = uri.substring(RELATIVE_PATH_NS_PREFIX.length());
            local = true;
        }
        if (!local && (map = this.getTaglibUrisMap(module, context)) != null && (xmlFile = (XmlFile)map.get(uri)) != null) {
            return xmlFile;
        }
        if (context != null) {
            Key<CachedValue<UriFactoryMap>> key = TldProcessorFactory.getUserDataKey(context);
            CachedValue cachedValue = (CachedValue)this.myLocalTaglibsUriProvider.get(key, (UserDataHolder)context, (Object)module);
            FactoryMap map2 = (FactoryMap)cachedValue.getValue();
            return map2 == null ? null : (XmlFile)map2.get((Object)uri);
        }
        return null;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this.myState);
    }

    public static class State {
        public boolean searchForPrefixedReferences = true;
    }

    private static class UriFactoryMapCachedValueProvider
    implements CachedValueProvider<UriFactoryMap> {
        private final Module myModule;
        private final SmartPsiElementPointer<JspFile> myContext;
        private final Object[] myDependencies;

        private UriFactoryMapCachedValueProvider(Module module, @Nullable SmartPsiElementPointer<JspFile> context, Object[] dependencies) {
            this.myModule = module;
            this.myContext = context;
            this.myDependencies = dependencies;
        }

        public CachedValueProvider.Result<UriFactoryMap> compute() {
            UriFactoryMap map = new UriFactoryMap(this.myModule, this.myContext, TldProvider.ALL);
            return new CachedValueProvider.Result((Object)map, this.myDependencies);
        }
    }

    public static class UriFactoryMap
    extends FactoryMap<String, XmlFile> {
        private final Module myModule;
        private final SmartPsiElementPointer<JspFile> myContext;
        private final TldProvider[] myProviders;
        private boolean myCompleted;

        public UriFactoryMap(Module module, SmartPsiElementPointer<JspFile> context, TldProvider ... providers) {
            this.myModule = module;
            this.myContext = context;
            this.myProviders = providers;
        }

        protected Map<String, XmlFile> createMap() {
            return Collections.synchronizedMap(super.createMap());
        }

        @Nullable
        public XmlFile get(Object uri) {
            XmlFile xmlFile = (XmlFile)super.get(uri);
            if (xmlFile != null && !TaglibUriCacheProvider.isUpToDate(xmlFile)) {
                this.remove(uri);
                return (XmlFile)super.get(uri);
            }
            return xmlFile;
        }

        @Nullable
        public XmlFile put(String key, XmlFile value) {
            VirtualFile file;
            if (value == null) {
                return null;
            }
            if ("http://java.sun.com/JSP/Page".equals(key) && ((file = value.getVirtualFile()) == null || TaglibIndex.isFaceletsTaglib(file))) {
                return value;
            }
            return (XmlFile)super.put((Object)key, (Object)value);
        }

        protected XmlFile create(String key) {
            for (TldProvider provider : this.myProviders) {
                VirtualFile virtualFile;
                XmlFile file = provider.getTldFileByUri(key, this.myModule, this.myContext == null ? null : (JspFile)this.myContext.getElement());
                if (file == null || "http://java.sun.com/JSP/Page".equals(key) && ((virtualFile = file.getVirtualFile()) == null || TaglibIndex.isFaceletsTaglib(virtualFile))) continue;
                return file;
            }
            return null;
        }

        String[] getUris() {
            ArrayList set = new ArrayList(this.keySet());
            ArrayList<String> list = new ArrayList<String>(set.size());
            for (String s : set) {
                if (this.get(s) == null) continue;
                list.add(s);
            }
            return ArrayUtil.toStringArray(list);
        }

        public boolean isCompleted() {
            return this.myCompleted;
        }

        public void setCompleted(boolean completed) {
            this.myCompleted = completed;
        }
    }

    private static interface TaglibFileVisitor {
        public void visit(@NotNull String var1, @NotNull TldDescriptor var2, @NotNull XmlDocument var3);
    }
}

