/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.profile;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.aliasFor.SpringAliasFor;
import com.intellij.spring.model.aliasFor.SpringAliasForUtils;
import com.intellij.spring.model.jam.profile.SpringContextProfile;
import com.intellij.spring.model.jam.profile.SpringJamProfile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomContextProfile
implements SpringContextProfile {
    public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = CONTEXT_PROFILE_JAM_ANNOTATION_KEY.subKey("CustomContextProfile", new SemKey[0]);
    public static final SemKey<CustomContextProfile> JAM_KEY = CONTEXT_PROFILE_JAM_KEY.subKey("CustomContextProfile", new SemKey[0]);
    public static final SemKey<JamMemberMeta<PsiMember, CustomContextProfile>> META_KEY = CONTEXT_PROFILE_META_KEY.subKey("CustomContextProfile", new SemKey[0]);
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final AnnotationChildLink myAnnotationChildLink;
    private final PsiAnchor myPsiMemberAnchor;
    private final NullableLazyValue<SpringJamProfile> myDefiningMetaAnnotation;

    public CustomContextProfile(@NotNull String anno, @NotNull PsiMember psiMember) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/spring/model/jam/profile/CustomContextProfile", "<init>"));
        }
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "com/intellij/spring/model/jam/profile/CustomContextProfile", "<init>"));
        }
        this.myDefiningMetaAnnotation = new NullableLazyValue<SpringJamProfile>(){

            @Nullable
            protected SpringJamProfile compute() {
                PsiClass annotationType;
                PsiMember element = CustomContextProfile.this.getPsiElement();
                if (element == null) {
                    return null;
                }
                PsiAnnotation definingMetaAnnotation = SpringAliasForUtils.findDefiningMetaAnnotation((PsiElement)element, CustomContextProfile.this.myAnnotationChildLink.getAnnotationQualifiedName(), "org.springframework.context.annotation.Profile");
                if (definingMetaAnnotation != null && (annotationType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)definingMetaAnnotation, PsiClass.class, (boolean)true)) != null) {
                    return (SpringJamProfile)SpringJamProfile.META.getJamElement((PsiModifierListOwner)annotationType);
                }
                return null;
            }
        };
        this.myAnnotationChildLink = new AnnotationChildLink(anno);
        this.myPsiMemberAnchor = PsiAnchor.create((PsiElement)psiMember);
        this.myPsiAnnotation = this.myAnnotationChildLink.createChildRef((PsiElement)psiMember);
    }

    @Override
    public PsiMember getPsiElement() {
        return (PsiMember)this.myPsiMemberAnchor.retrieve();
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    @Override
    @Nullable
    public PsiElement getIdentifyingPsiElement() {
        return this.getPsiElement();
    }

    @Override
    @NotNull
    public Set<String> getNames() {
        HashSet profiles = ContainerUtil.newHashSet();
        SpringAliasFor aliasFor = this.getAliasAttribute("value");
        if (aliasFor != null) {
            for (JamStringAttributeElement element : JamAttributeMeta.collectionString((String)aliasFor.getMethodName()).getJam(this.myPsiAnnotation)) {
                ContainerUtil.addIfNotNull((Collection)profiles, (Object)element.getValue());
            }
        } else {
            SpringJamProfile definingProfile = (SpringJamProfile)this.myDefiningMetaAnnotation.getValue();
            if (definingProfile != null) {
                Set<String> set = definingProfile.getNames();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/profile/CustomContextProfile", "getNames"));
                }
                return set;
            }
        }
        HashSet hashSet = profiles;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/profile/CustomContextProfile", "getNames"));
        }
        return hashSet;
    }

    @Nullable
    private SpringAliasFor getAliasAttribute(@NotNull String attrName) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/spring/model/jam/profile/CustomContextProfile", "getAliasAttribute"));
        }
        PsiMember element = this.getPsiElement();
        return element == null ? null : SpringAliasForUtils.findAliasFor((PsiElement)element, this.myAnnotationChildLink.getAnnotationQualifiedName(), "org.springframework.context.annotation.Profile", attrName);
    }
}

