/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex;

import com.intellij.codeInsight.documentation.AbstractExternalFilter;
import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.javascript.flex.FlexDocumentationBuilder;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.actionscript.psi.impl.ActionScriptFunctionImpl;
import com.intellij.lang.actionscript.psi.impl.ActionScriptVariableImpl;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import gnu.trove.THashMap;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexDocumentationProvider
extends JSDocumentationProvider {
    private static final Pattern ourMainContentDiv = Pattern.compile("<div.*?class=\"MainContent\">", 2);
    private static final Pattern ourDetailBodyDiv = Pattern.compile("<div.*?class=\"detailBody\">", 2);
    private static final Pattern ourEventDetailTd = Pattern.compile("<td.*?class=\"summaryTableDescription\">", 2);
    private static final Pattern ourOpeningDiv = Pattern.compile("<div.*?>", 2);
    private static final Pattern ourClosingDiv = Pattern.compile("</div>", 2);
    private static final Pattern ourOpeningTd = Pattern.compile("<td.*?>", 2);
    private static final Pattern ourClosingTd = Pattern.compile("</td>", 2);
    private static final Pattern ourSeeAlsoDiv = Pattern.compile("<p>[ \r\n\t]*?<span .*?>See also</span>[ \r\n\t]*?</p>[ \r\n\t]*?<div .*?class=\"seeAlso\".*?>", 2);
    private static final Pattern ourLabelSpan = Pattern.compile("<span .*?class=\"label\".*?>(.*?)</span>", 34);
    private static final Pattern[] ourStrip = new Pattern[]{Pattern.compile("<span[^>]*style=\"display:none\"[^>]*>.*?</span>", 34), Pattern.compile("<p></p>", 2), Pattern.compile("<hr>", 2), Pattern.compile("[ ]?class=\".*?\"", 2), Pattern.compile("<!--.*?-->"), Pattern.compile("<script.*?</script>", 34), Pattern.compile("<a[^>]*onclick=[^>]*>.*?</a>", 34)};
    private static final Pattern ourLinebreakInText = Pattern.compile("([^ \t\r\n>][ \t]*)([\r\n]+[ \t]*[^ \t\r\n<])");
    private static final Pattern ourLinebreakBeforeCode = Pattern.compile("(</code>[ \t]*?)([\r\n]+[ \t]*?[^ \t\r\n<])", 2);
    private static final Pattern ourLinebreakAfterCode = Pattern.compile("([^ \t\r\n>][ \t]*)([\r\n]+[ \t]*?<code>)", 2);
    private static final String ourInsertBr = "$1<br>$2";
    private static final String DISPLAY_NAME_MARKER = "$$$$DISPLAY_NAME$$$$";
    private final Pattern ourDetailHeaderTable = Pattern.compile("<table .*?class=\"classHeaderTable\".*?>.*?</table>", 34);
    private static final Pattern ourClassHeaderTable = Pattern.compile("<table .*?class=\"classHeaderTable\".*?>.*?</table>", 34);
    private static final Pattern ourLinkPattern = Pattern.compile("<a.*?href=\"(.*?)\".*?>(.*?)</a>", 2);
    @NonNls
    private static final Pattern ourHREFselector = Pattern.compile("<a.*?href=\"([^>\"]*)\"", 2);
    @NonNls
    private static final Pattern ourIMGselector = Pattern.compile("<img.*?src=\"([^>\"]*)\"", 34);
    @NonNls
    private static final String PACKAGE = "package";
    @NonNls
    private static final String HTML_EXTENSION = ".html";
    @NonNls
    private static final String PACKAGE_FILE = "package.html";
    private static final Map<String, String> DOCUMENTED_ATTRIBUTES = new THashMap();

    public String generateDoc(PsiElement _element, PsiElement originalElement) {
        String doc = super.generateDoc(_element, originalElement);
        if (doc != null) {
            return doc;
        }
        if (_element instanceof JSOffsetBasedImplicitElement) {
            _element = ((JSOffsetBasedImplicitElement)_element).getElementAtOffset();
        }
        XmlTag parent = null;
        if (_element instanceof XmlBackedJSClassImpl) {
            parent = ((XmlBackedJSClassImpl)_element).getParent();
        } else if (_element instanceof XmlToken) {
            parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)_element, XmlTag.class);
        }
        if (parent != null) {
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)parent);
            while (prev instanceof PsiWhiteSpace || prev instanceof XmlComment && !prev.getText().startsWith("<!---")) {
                if (!((prev = PsiTreeUtil.prevLeaf((PsiElement)prev)) instanceof XmlToken)) continue;
                prev = prev.getParent();
            }
            if (prev instanceof XmlComment) {
                return this.doGetCommentTextFromComment((PsiComment)prev, originalElement);
            }
        }
        final PsiElement elementToShowDoc = FlexDocumentationProvider.findElementToShowDoc(_element);
        AbstractExternalFilter docFilter = new AbstractExternalFilter(){
            private final AbstractExternalFilter.RefConvertor[] myReferenceConvertors = new AbstractExternalFilter.RefConvertor[]{new AbstractExternalFilter.RefConvertor(FlexDocumentationProvider.access$000()){

                protected String convertReference(String origin, String link) {
                    if (BrowserUtil.isAbsoluteURL((String)link)) {
                        return link;
                    }
                    String resolved = FlexDocumentationProvider.getSeeAlsoLinkResolved(elementToShowDoc, link);
                    if (resolved != null) {
                        return "psi_element://" + resolved;
                    }
                    String originFile = ourAnchorSuffix.matcher(origin).replaceAll("");
                    if (StringUtil.startsWithChar((CharSequence)link, (char)'#')) {
                        return originFile + link;
                    }
                    String originPath = originFile.contains("/") ? originFile.substring(0, originFile.lastIndexOf("/")) : originFile;
                    return 1.doAnnihilate((String)(originPath + "/" + link));
                }
            }, new AbstractExternalFilter.RefConvertor(FlexDocumentationProvider.access$400()){

                protected String convertReference(String root, String href) {
                    if (StringUtil.startsWithChar((CharSequence)href, (char)'#')) {
                        return root + href;
                    }
                    if (root.startsWith("file://") && SystemInfo.isWindows) {
                        root = "file:///" + root.substring("file://".length());
                    }
                    return 1.doAnnihilate((String)(ourHtmlFileSuffix.matcher(root).replaceAll("/") + href));
                }
            }};

            protected AbstractExternalFilter.RefConvertor[] getRefConverters() {
                return this.myReferenceConvertors;
            }

            public String getExternalDocInfoForElement(String docURL, final PsiElement element) throws Exception {
                String result = super.getExternalDocInfoForElement(docURL, element);
                if (StringUtil.isNotEmpty((String)result)) {
                    result = result.replace(FlexDocumentationProvider.DISPLAY_NAME_MARKER, (CharSequence)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CharSequence>(){

                        public CharSequence compute() {
                            return FlexDocumentationProvider.getDisplayName(element);
                        }
                    }));
                }
                return result;
            }

            protected void doBuildFromStream(String url, Reader reader, StringBuilder result) throws IOException {
                TextRange seeAlso;
                int startOffset;
                String input = StreamUtil.readTextFrom((Reader)reader);
                Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
                Pair mainContentPatterns = Pair.create((Object)ourOpeningDiv, (Object)ourClosingDiv);
                if (anchorMatcher.find()) {
                    String name = anchorMatcher.group(1);
                    Pattern detailPattern = ourDetailBodyDiv;
                    for (Map.Entry e : DOCUMENTED_ATTRIBUTES.entrySet()) {
                        if (!name.startsWith((String)e.getValue())) continue;
                        if ("Event".equals(e.getKey())) break;
                        detailPattern = ourEventDetailTd;
                        mainContentPatterns = Pair.create((Object)ourOpeningTd, (Object)ourClosingTd);
                        break;
                    }
                    name = name.replaceAll("\\)", "\\\\)").replaceAll("\\(", "\\\\(");
                    Matcher m = Pattern.compile("<a name=\"" + name + "\"").matcher(input);
                    if (!m.find()) {
                        return;
                    }
                    int offset = m.end();
                    m = detailPattern.matcher(input);
                    if (!m.find(offset)) {
                        return;
                    }
                    startOffset = m.start();
                } else {
                    Matcher m = ourMainContentDiv.matcher(input);
                    if (!m.find()) {
                        return;
                    }
                    startOffset = m.start();
                }
                TextRange description = FlexDocumentationProvider.getRangeBetweenNested(input, new TextRange(startOffset, input.length()), (Pattern)mainContentPatterns.first, (Pattern)mainContentPatterns.second);
                if (description == null) {
                    return;
                }
                Matcher m = ourSeeAlsoDiv.matcher(input);
                if (FlexDocumentationProvider.findIn(m, description)) {
                    seeAlso = FlexDocumentationProvider.getRangeBetweenNested(input, new TextRange(m.start(), description.getEndOffset()), ourOpeningDiv, ourClosingDiv);
                    description = new TextRange(description.getStartOffset(), m.start());
                } else {
                    seeAlso = null;
                }
                String text = description.substring(input);
                text = FlexDocumentationProvider.this.ourDetailHeaderTable.matcher(text).replaceAll("");
                text = ourClassHeaderTable.matcher(text).replaceAll("");
                result.append("<HTML>").append("<PRE><b>").append(FlexDocumentationProvider.DISPLAY_NAME_MARKER);
                result.append("</b></PRE>");
                result.append(FlexDocumentationProvider.prettyPrint(text));
                if (seeAlso != null) {
                    result.append("<DL><DT><b>See also:</b></DT>");
                    int pos = seeAlso.getStartOffset();
                    Matcher br = Pattern.compile("<br/?>", 2).matcher(input);
                    while (FlexDocumentationProvider.findIn(br, new TextRange(pos, seeAlso.getEndOffset()))) {
                        TextRange item = new TextRange(pos, br.start());
                        result.append("<DD>").append(FlexDocumentationProvider.makeLink(item.substring(input))).append("</DD>");
                        pos = br.end();
                    }
                    result.append("<DD>").append(FlexDocumentationProvider.makeLink(input.substring(pos, seeAlso.getEndOffset()))).append("</DD></DL>");
                }
                result.append("</HTML>");
            }
        };
        for (String docURL : FlexDocumentationProvider.findUrls(elementToShowDoc)) {
            try {
                String javadoc = docFilter.getExternalDocInfoForElement(docURL, elementToShowDoc);
                if (!StringUtil.isNotEmpty((String)javadoc)) continue;
                return javadoc;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @NotNull
    private static PsiElement findElementToShowDoc(PsiElement _element) {
        PsiElement navigationElement = FlexDocumentationProvider.findNavigationElement(_element);
        if (navigationElement == null) {
            navigationElement = _element instanceof JSQualifiedNamedElement ? FlexDocumentationProvider.findTopLevelNavigationElement((JSQualifiedNamedElement)_element) : _element.getNavigationElement();
        }
        PsiElement psiElement = navigationElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexDocumentationProvider", "findElementToShowDoc"));
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement findNavigationElement(PsiElement element) {
        JSAttributeNameValuePair namePair;
        String type;
        JSQualifiedNamedElement parentQualifiedElement = FlexDocumentationProvider.findParentQualifiedElement(element);
        if (parentQualifiedElement == null) {
            return null;
        }
        PsiElement navElement = FlexDocumentationProvider.findTopLevelNavigationElement(parentQualifiedElement);
        if (element instanceof JSClass) {
            return navElement;
        }
        if (element instanceof JSFunction && JSResolveUtil.findParent((PsiElement)element) instanceof JSClass && navElement instanceof JSClass) {
            return ((JSClass)navElement).findFunctionByNameAndKind(((JSFunction)element).getName(), ((JSFunction)element).getKind());
        }
        if (element instanceof JSVariable && JSResolveUtil.findParent((PsiElement)element) instanceof JSClass && navElement instanceof JSClass) {
            return ((JSClass)navElement).findFieldByName(((JSVariable)element).getName());
        }
        JSAttribute attribute = null;
        if (element instanceof JSAttributeNameValuePair) {
            attribute = (JSAttribute)element.getParent();
        }
        if (element instanceof JSAttribute) {
            attribute = (JSAttribute)element;
        }
        if (attribute != null && navElement instanceof JSClass && DOCUMENTED_ATTRIBUTES.containsKey(type = attribute.getName()) && (namePair = attribute.getValueByName("name")) != null) {
            return FlexDocumentationProvider.findNamedAttribute((JSClass)navElement, type, namePair.getSimpleValue());
        }
        if (element.getClass() == navElement.getClass()) {
            return navElement;
        }
        return null;
    }

    @NotNull
    public static PsiElement findTopLevelNavigationElement(JSQualifiedNamedElement element) {
        if (element.getName() == null) {
            JSQualifiedNamedElement jSQualifiedNamedElement = element;
            if (jSQualifiedNamedElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexDocumentationProvider", "findTopLevelNavigationElement"));
            }
            return jSQualifiedNamedElement;
        }
        Ref withAsdoc = new Ref();
        PsiElement sourceElement = JSPsiImplUtils.findTopLevelNavigatableElementWithSource((JSQualifiedNamedElement)element, candidate -> {
            if (withAsdoc.isNull()) {
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)candidate.getProject()).getFileIndex();
                String relPath = FlexDocumentationProvider.getAsDocRelativePath(candidate);
                PsiFile file = candidate.getContainingFile();
                if (file == null) {
                    return;
                }
                VirtualFile containingFile = file.getVirtualFile();
                if (containingFile == null || projectFileIndex.getClassRootForFile(containingFile) == null) {
                    return;
                }
                List orderEntries = projectFileIndex.getOrderEntriesForFile(containingFile);
                for (OrderEntry orderEntry : orderEntries) {
                    String[] roots = JavadocOrderRootType.getUrls((OrderEntry)orderEntry);
                    if (PlatformDocumentationUtil.getHttpRoots((String[])FlexDocumentationProvider.correctHttpRoots(roots), (String)relPath) == null) continue;
                    withAsdoc.set(candidate);
                }
            }
        });
        if (sourceElement != null) {
            PsiElement psiElement = sourceElement;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexDocumentationProvider", "findTopLevelNavigationElement"));
            }
            return psiElement;
        }
        if (!withAsdoc.isNull()) {
            PsiElement psiElement = (PsiElement)withAsdoc.get();
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexDocumentationProvider", "findTopLevelNavigationElement"));
            }
            return psiElement;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = element;
        if (jSQualifiedNamedElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexDocumentationProvider", "findTopLevelNavigationElement"));
        }
        return jSQualifiedNamedElement;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        List url = super.getUrlFor(element, originalElement);
        if (url != null) {
            return url;
        }
        PsiElement elementToShowDoc = FlexDocumentationProvider.findElementToShowDoc(element);
        List<String> urls = FlexDocumentationProvider.findUrls(elementToShowDoc);
        return urls != null && !urls.isEmpty() ? urls : null;
    }

    private static String makeLink(String input) {
        Matcher link = ourLinkPattern.matcher(input = input.trim());
        if (link.matches()) {
            String href = link.group(1);
            return "<a href=\"" + href + "\">" + link.group(2) + "</a>";
        }
        if (StringUtil.containsAnyChar((String)input, (String)"\t \"-\\/<>*")) {
            if (input.indexOf("\"") == input.length() - 1) {
                input = input.substring(0, input.length() - 1);
            }
            return input;
        }
        input = StringUtil.escapeXml((String)input);
        return "<a href=\"" + input + "\">" + input + "</a>";
    }

    private static String prettyPrint(String text) {
        text = ourLabelSpan.matcher(text).replaceAll("<br><b>$1</b>");
        for (Pattern pattern : ourStrip) {
            text = pattern.matcher(text).replaceAll("");
        }
        text = FlexDocumentationProvider.replaceInPlainText(text, ourInsertBr, ourLinebreakInText);
        text = FlexDocumentationProvider.replaceInPlainText(text, ourInsertBr, ourLinebreakAfterCode);
        text = FlexDocumentationProvider.replaceInPlainText(text, ourInsertBr, ourLinebreakBeforeCode);
        return text;
    }

    private static String replaceInPlainText(String input, String replacement, Pattern p) {
        Matcher m = p.matcher(input);
        boolean result = m.find();
        int prevpos = 0;
        boolean isInTag = false;
        boolean isInPre = false;
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String s = input.substring(prevpos, m.start());
                isInTag = FlexDocumentationProvider.endIsBetween(s, "<", ">", isInTag);
                isInPre = FlexDocumentationProvider.endIsBetween(s, "<pre>", "</pre>", isInPre);
                prevpos = m.end();
                m.appendReplacement(sb, isInTag || isInPre ? "$0" : replacement);
            } while (result = m.find());
            m.appendTail(sb);
            return sb.toString();
        }
        return input;
    }

    private static boolean endIsBetween(String s, String open, String close, boolean defaultValue) {
        int openPos = s.lastIndexOf(open);
        int closePos = s.lastIndexOf(close);
        if (openPos == -1) {
            return closePos == -1 && defaultValue;
        }
        return closePos == -1 || closePos < openPos;
    }

    private static String getAsDocRelativePath(JSQualifiedNamedElement element) {
        String qName = element.getQualifiedName();
        if (qName == null) {
            qName = "";
        }
        String shortName = element instanceof JSClass ? StringUtil.getShortName((String)qName) : PACKAGE;
        String packageName = StringUtil.getPackageName((String)qName);
        packageName = packageName.replace('.', '/');
        return packageName.length() > 0 ? packageName + "/" + shortName + HTML_EXTENSION : shortName + HTML_EXTENSION;
    }

    private static List<String> findUrlsForClass(JSQualifiedNamedElement aClass) {
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return Collections.emptyList();
        }
        PsiFile file = aClass.getContainingFile();
        if (!(file instanceof JSFile)) {
            return Collections.emptyList();
        }
        PsiFile containingFile = aClass.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        return FlexDocumentationProvider.findUrlForVirtualFile(containingFile.getProject(), virtualFile, FlexDocumentationProvider.getAsDocRelativePath(aClass));
    }

    private static List<String> findUrls(PsiElement element) {
        JSAttributeNameValuePair namePair;
        JSQualifiedNamedElement clazz = FlexDocumentationProvider.findParentQualifiedElement(element);
        if (clazz == null) {
            return Collections.emptyList();
        }
        String anchor = null;
        if (element instanceof JSFunction || element instanceof JSVariable) {
            anchor = ((JSNamedElement)element).getName();
            if (element instanceof JSFunction && !((JSFunction)element).isGetProperty() && !((JSFunction)element).isSetProperty()) {
                anchor = anchor + "()";
            }
        } else if (element instanceof JSAttributeNameValuePair) {
            String type = ((JSAttribute)element.getParent()).getName();
            JSAttributeNameValuePair namePair2 = ((JSAttribute)element.getParent()).getValueByName("name");
            if (namePair2 != null) {
                anchor = DOCUMENTED_ATTRIBUTES.get(type) + namePair2.getSimpleValue();
            }
        } else if (element instanceof JSAttribute && (namePair = ((JSAttribute)element).getValueByName("name")) != null) {
            String type = ((JSAttribute)element).getName();
            anchor = DOCUMENTED_ATTRIBUTES.get(type) + namePair.getSimpleValue();
        }
        List<String> urls = FlexDocumentationProvider.findUrlsForClass(clazz);
        if (anchor != null) {
            ArrayList<String> anchored = new ArrayList<String>(urls.size());
            for (String url : urls) {
                anchored.add(url + "#" + anchor);
            }
            return anchored;
        }
        return urls;
    }

    private static TextRange getRangeBetweenNested(String input, @Nullable TextRange within, Pattern openPattern, Pattern closePattern) {
        int closePos;
        Matcher open = openPattern.matcher(input);
        Matcher close = closePattern.matcher(input);
        if (!open.find(within != null ? within.getStartOffset() : 0)) {
            return null;
        }
        int contentsStart = open.end();
        int nesting = 0;
        int pos = contentsStart;
        while (true) {
            if (within != null && !within.contains(pos) || !close.find(pos)) {
                return null;
            }
            closePos = close.start();
            if (open.find(pos) && open.start() < closePos) {
                ++nesting;
                pos = open.end();
                continue;
            }
            if (nesting <= 0) break;
            --nesting;
            pos = close.end();
        }
        return new TextRange(contentsStart, closePos);
    }

    private static boolean findIn(Matcher m, TextRange within) {
        return m.find(within.getStartOffset()) && within.contains(m.start());
    }

    private static String getDisplayName(PsiElement element) {
        if (element instanceof JSClass) {
            return ((JSClass)element).getQualifiedName();
        }
        if (element instanceof JSFunction || element instanceof JSVariable) {
            PsiElement parent = JSResolveUtil.findParent((PsiElement)element);
            String result = parent instanceof JSClass ? ((JSClass)parent).getQualifiedName() + "." + ((JSNamedElement)element).getName() : ((JSQualifiedNamedElement)element).getQualifiedName();
            if (element instanceof JSFunction && !((JSFunction)element).isGetProperty() && !((JSFunction)element).isSetProperty()) {
                result = result + "()";
            }
            return result;
        }
        JSAttribute attribute = null;
        if (element instanceof JSAttributeNameValuePair) {
            attribute = (JSAttribute)element.getParent();
        }
        if (element instanceof JSAttribute) {
            attribute = (JSAttribute)element;
        }
        if (attribute != null && DOCUMENTED_ATTRIBUTES.containsKey(attribute.getName())) {
            JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
            JSAttributeNameValuePair namePair = attribute.getValueByName("name");
            if (jsClass != null && namePair != null) {
                return attribute.getName() + " " + jsClass.getQualifiedName() + "." + namePair.getSimpleValue();
            }
        }
        return null;
    }

    @NotNull
    private static List<String> findUrlForVirtualFile(Project project, VirtualFile virtualFile, String relPath) {
        String[] javadocPaths;
        List httpRoots;
        VirtualFile jar;
        VirtualFileSystem fs;
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        Module module = fileIndex.getModuleForFile(virtualFile);
        if (module == null && (fs = virtualFile.getFileSystem()) instanceof JarFileSystem && (jar = ((JarFileSystem)fs).getVirtualFileForJar(virtualFile)) != null) {
            module = fileIndex.getModuleForFile(jar);
        }
        if (module != null && (httpRoots = PlatformDocumentationUtil.getHttpRoots((String[])FlexDocumentationProvider.correctHttpRoots(javadocPaths = JavaModuleExternalPaths.getInstance((Module)module).getJavadocUrls()), (String)relPath)) != null) {
            List list = httpRoots;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexDocumentationProvider", "findUrlForVirtualFile"));
            }
            return list;
        }
        List orderEntries = fileIndex.getOrderEntriesForFile(virtualFile);
        for (OrderEntry orderEntry : orderEntries) {
            String[] files = JavadocOrderRootType.getUrls((OrderEntry)orderEntry);
            List httpRoot = PlatformDocumentationUtil.getHttpRoots((String[])FlexDocumentationProvider.correctHttpRoots(files), (String)relPath);
            if (httpRoot == null) continue;
            List list = httpRoot;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexDocumentationProvider", "findUrlForVirtualFile"));
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexDocumentationProvider", "findUrlForVirtualFile"));
        }
        return list;
    }

    private static String[] correctHttpRoots(String[] roots) {
        String[] result = (String[])roots.clone();
        for (int i = 0; i < result.length; ++i) {
            if (!result[i].startsWith("http://")) continue;
            result[i] = StringUtil.trimEnd((String)StringUtil.trimEnd((String)result[i], (String)"index.html"), (String)"index.htm");
        }
        return result;
    }

    private static String getLinkToResolve(JSQualifiedNamedElement origin, String link) {
        String qname;
        String linkAnchor;
        String originQname = origin.getQualifiedName();
        if (link.length() == 0) {
            return originQname;
        }
        if (StringUtil.startsWithChar((CharSequence)link, (char)'#')) {
            if (origin instanceof JSClass) {
                return originQname + "." + link.substring(1);
            }
            String aPackage = StringUtil.getPackageName((String)originQname);
            return aPackage + "." + link.substring(1);
        }
        String linkFile = link.contains("#") ? link.substring(0, link.lastIndexOf(35)) : link;
        String string = linkAnchor = link.contains("#") ? link.substring(link.lastIndexOf(35) + 1) : null;
        if (StringUtil.endsWithIgnoreCase((String)linkFile, (String)HTML_EXTENSION)) {
            String linkFilename;
            String prefix = StringUtil.getPackageName((String)originQname);
            while (linkFile.startsWith("../")) {
                linkFile = linkFile.substring("../".length());
                prefix = StringUtil.getPackageName((String)prefix);
            }
            if (linkFile.endsWith(PACKAGE_FILE)) {
                linkFilename = StringUtil.trimEnd((String)linkFile, (String)PACKAGE_FILE);
                linkFilename = StringUtil.trimEnd((String)linkFilename, (String)"/");
            } else {
                linkFilename = linkFile.substring(0, linkFile.lastIndexOf("."));
            }
            qname = linkFilename.length() > 0 ? (prefix.length() > 0 ? prefix + "." : prefix) + linkFilename.replaceAll("/", ".") : prefix;
        } else {
            qname = linkFile;
        }
        return linkAnchor != null ? (qname.length() > 0 ? qname + "." : qname) + linkAnchor : qname;
    }

    @Nullable
    private static JSQualifiedNamedElement findParentQualifiedElement(PsiElement element) {
        JSClass jsClass;
        PsiElement e;
        PsiElement parent;
        if (element instanceof JSClass) {
            return (JSClass)element;
        }
        if (element instanceof XmlComment && (parent = element.getParent()) instanceof XmlProlog && (e = parent.getNextSibling()) instanceof XmlTag) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)((XmlElement)e));
        }
        if (element instanceof JSFunction || element instanceof JSVariable) {
            parent = JSResolveUtil.findParent((PsiElement)element);
            if (parent instanceof JSClass) {
                return (JSClass)parent;
            }
            if (parent instanceof JSFile || parent instanceof JSPackage) {
                return (JSQualifiedNamedElement)element;
            }
        }
        JSAttribute attribute = null;
        if (element instanceof JSAttribute) {
            attribute = (JSAttribute)element;
        } else if (element instanceof JSAttributeNameValuePair) {
            attribute = (JSAttribute)element.getParent();
        }
        if (attribute != null && DOCUMENTED_ATTRIBUTES.containsKey(attribute.getName()) && (jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class)) != null) {
            return jsClass;
        }
        return null;
    }

    @Nullable
    private static String getSeeAlsoLinkResolved(PsiElement originElement, String link) {
        JSQualifiedNamedElement qualifiedElement = FlexDocumentationProvider.findParentQualifiedElement(originElement);
        if (qualifiedElement == null) {
            return null;
        }
        String linkToResolve = FlexDocumentationProvider.getLinkToResolve(qualifiedElement, link);
        PsiElement resolvedElement = FlexDocumentationProvider.getDocumentationElementForLinkStatic(originElement.getManager(), linkToResolve, originElement);
        if (resolvedElement != null) {
            return linkToResolve;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return FlexDocumentationProvider.getDocumentationElementForLinkStatic(psiManager, link, context);
    }

    @Nullable
    private static PsiElement getDocumentationElementForLinkStatic(PsiManager psiManager, String link, PsiElement context) {
        PsiElement resolve;
        PsiReference[] references;
        String qname;
        PsiElement clazz;
        int delimiterIndex = link.lastIndexOf(58);
        JavaScriptIndex index = JavaScriptIndex.getInstance((Project)psiManager.getProject());
        String attributeType = null;
        String attributeName = null;
        for (Map.Entry<String, String> e : DOCUMENTED_ATTRIBUTES.entrySet()) {
            String pattern = "." + e.getValue();
            if (!link.contains(pattern)) continue;
            attributeType = e.getKey();
            attributeName = StringUtil.substringAfter((String)link, (String)pattern);
            link = link.substring(0, link.indexOf(pattern));
            break;
        }
        if (delimiterIndex != -1 && attributeType == null) {
            return FlexDocumentationProvider.resolveDocumentLink((PsiManager)psiManager, (String)link, (int)delimiterIndex);
        }
        if (attributeType != null) {
            clazz = ActionScriptClassResolver.findClassByQName(link, index, context != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)context) : null);
            if (!(clazz instanceof JSClass)) {
                return null;
            }
            return FlexDocumentationProvider.findNamedAttribute((JSClass)clazz, attributeType, attributeName);
        }
        clazz = ActionScriptClassResolver.findClassByQName(link, index, context != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)context) : null);
        if (clazz == null && link.contains(".") && (clazz = ActionScriptClassResolver.findClassByQName(qname = link.substring(0, link.lastIndexOf(46)), index, context != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)context) : null)) instanceof JSClass) {
            JSClass jsClass = (JSClass)clazz;
            String member = link.substring(link.lastIndexOf(46) + 1);
            if (member.endsWith("()")) {
                PsiElement result = FlexDocumentationProvider.findMethod(jsClass, member = member.substring(0, member.length() - 2));
                if (result == null) {
                    result = FlexDocumentationProvider.findProperty(jsClass, member);
                }
                return result;
            }
            JSField result = jsClass.findFieldByName(member);
            if (result == null) {
                result = FlexDocumentationProvider.findProperty(jsClass, member);
            }
            if (result == null) {
                result = FlexDocumentationProvider.findMethod(jsClass, member);
            }
            return result;
        }
        if (clazz instanceof JSVariable) {
            return clazz;
        }
        if (link.endsWith("()") && (clazz = ActionScriptClassResolver.findClassByQName(link = link.substring(0, link.length() - 2), index, context != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)context) : null)) instanceof JSFunction) {
            return clazz;
        }
        if (clazz == null && context != null && (references = new JSDocReferenceSet(context, link, 0, false).getReferences()).length > 0 && (resolve = references[references.length - 1].resolve()) != null) {
            return resolve;
        }
        return clazz;
    }

    @Nullable
    private static JSAttributeNameValuePair findNamedAttribute(JSClass clazz, final String type, final String name) {
        final Ref attribute = new Ref();
        ActionScriptResolveUtil.processMetaAttributesForClass((PsiElement)clazz, (ActionScriptResolveUtil.MetaDataProcessor)new ActionScriptResolveUtil.MetaDataProcessor(){

            public boolean process(@NotNull JSAttribute jsAttribute) {
                JSAttributeNameValuePair jsAttributeNameValuePair;
                if (jsAttribute == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsAttribute", "com/intellij/javascript/flex/FlexDocumentationProvider$2", "process"));
                }
                if (type.equals(jsAttribute.getName()) && (jsAttributeNameValuePair = jsAttribute.getValueByName("name")) != null && name.equals(jsAttributeNameValuePair.getSimpleValue())) {
                    attribute.set((Object)jsAttributeNameValuePair);
                    return false;
                }
                return true;
            }

            public boolean handleOtherElement(PsiElement el, PsiElement context, @Nullable Ref<PsiElement> continuePassElement) {
                return true;
            }
        });
        return (JSAttributeNameValuePair)attribute.get();
    }

    private static PsiElement findProperty(JSClass jsClass, String name) {
        JSFunction result = jsClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.GETTER);
        if (result == null) {
            result = jsClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.SETTER);
        }
        return result;
    }

    private static PsiElement findMethod(JSClass jsClass, String name) {
        JSFunction result = jsClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.CONSTRUCTOR);
        if (result == null) {
            result = jsClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.SIMPLE);
        }
        return result;
    }

    @Nullable
    public String tryGetSeeAlsoLink(String remainingLineContent, PsiElement element) {
        String qname;
        String aPackage;
        String resolvedLink;
        JSQualifiedNamedElement qualifiedElement;
        if (!remainingLineContent.contains(".") && !remainingLineContent.startsWith("#") && (qualifiedElement = FlexDocumentationProvider.findParentQualifiedElement(element)) != null && (resolvedLink = FlexDocumentationProvider.getSeeAlsoLinkResolved(element, (aPackage = (qname = qualifiedElement.getQualifiedName()).contains(".") ? qname.substring(0, qname.lastIndexOf(46) + 1) : "") + remainingLineContent)) != null) {
            return resolvedLink;
        }
        return FlexDocumentationProvider.getSeeAlsoLinkResolved(element, remainingLineContent);
    }

    @NotNull
    protected JSDocumentationBuilder createDocumentationBuilder(@NotNull PsiElement element, PsiElement _contextElement, boolean showNamedItem) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexDocumentationProvider", "createDocumentationBuilder"));
        }
        FlexDocumentationBuilder flexDocumentationBuilder = new FlexDocumentationBuilder(element, _contextElement, showNamedItem, this);
        if (flexDocumentationBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/FlexDocumentationProvider", "createDocumentationBuilder"));
        }
        return flexDocumentationBuilder;
    }

    protected void appendParentInfo(PsiElement parent, @NotNull StringBuilder builder, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javascript/flex/FlexDocumentationProvider", "appendParentInfo"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/FlexDocumentationProvider", "appendParentInfo"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/javascript/flex/FlexDocumentationProvider", "appendParentInfo"));
        }
        if (parent instanceof JSClass) {
            builder.append(((JSClass)parent).getQualifiedName()).append("\n");
        } else if (parent instanceof JSPackageStatement) {
            builder.append(((JSPackageStatement)parent).getQualifiedName()).append("\n");
        } else if (parent instanceof JSFile) {
            if (parent.getContext() != null) {
                String mxmlPackage = ActionScriptResolveUtil.findPackageForMxml((PsiElement)parent);
                if (mxmlPackage != null) {
                    builder.append(mxmlPackage).append(mxmlPackage.length() > 0 ? "." : "").append(parent.getContext().getContainingFile().getName()).append("\n");
                }
            } else {
                boolean foundQualified = false;
                if (element instanceof ActionScriptFunctionImpl && ((ActionScriptFunctionImpl)element).hasQualifiedName() || element instanceof ActionScriptVariableImpl && ((ActionScriptVariableImpl)element).hasQualifiedName()) {
                    JSQualifiedName namespace = ((JSQualifiedNamedElement)element).getNamespace();
                    assert (namespace != null) : "null namespace of element having qualified name";
                    builder.append(namespace.getQualifiedName()).append("\n");
                    foundQualified = true;
                }
                if (!foundQualified) {
                    builder.append(parent.getContainingFile().getName()).append("\n");
                }
            }
        }
    }

    protected void appendFunctionInfoDoc(@NotNull JSFunction function, @NotNull StringBuilder builder) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/javascript/flex/FlexDocumentationProvider", "appendFunctionInfoDoc"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/javascript/flex/FlexDocumentationProvider", "appendFunctionInfoDoc"));
        }
        JSType type = JSPsiImplUtils.getTypeFromDeclaration((JSElement)function);
        if (type != null && !"void".equals(type.getTypeText()) && !function.isGetProperty()) {
            builder.append("* @return ");
            builder.append("\n");
        }
    }

    static /* synthetic */ Pattern access$000() {
        return ourHREFselector;
    }

    static /* synthetic */ Pattern access$400() {
        return ourIMGselector;
    }

    static {
        DOCUMENTED_ATTRIBUTES.put("Event", "event:");
        DOCUMENTED_ATTRIBUTES.put("Style", "style:");
        DOCUMENTED_ATTRIBUTES.put("Effect", "effect:");
    }
}

