/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.completion;

import com.intellij.lang.javascript.completion.JSCompletionContributor;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSKeywordsCompletionProvider;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ActionScriptCompletionKeywordsContributor
extends JSCompletionKeywordsContributor {
    @NonNls
    private static final String[] accessModifiers = new String[]{"public", "private", "protected", "internal"};

    public boolean process(KeywordCompletionConsumer consumer, PsiElement context) {
        PsiElement grandGrandParent;
        if (JSCompletionContributor.getInstance().isDoingSmartCodeCompleteAction()) {
            return false;
        }
        PsiElement parent = context.getParent();
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        PsiElement psiElement = grandGrandParent = grandParent != null ? grandParent.getParent() : null;
        if (parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null && (JSResolveUtil.isExprInTypeContext((JSReferenceExpression)((JSReferenceExpression)parent)) || grandParent instanceof JSExpressionStatement && (JSResolveUtil.isPlaceWhereNsCanBe((PsiElement)grandParent) || grandGrandParent instanceof JSFile && grandGrandParent.getContext() == null) || grandParent instanceof JSAttributeList || parent instanceof JSAttributeNameValuePair)) {
            if (!(grandParent instanceof JSImportStatement || !(grandParent instanceof JSAttributeList) && !JSResolveUtil.isPlaceWhereNsCanBe((PsiElement)grandParent) && !(grandGrandParent instanceof JSFile) || grandParent instanceof JSFunction && ((JSFunction)grandParent).getReturnTypeElement() == parent)) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, accessModifiers);
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, new String[]{"class", "function", "interface", "namespace", "package", "extends", "implements", "import", "override", "static", "dynamic", "var", "const", "use", "final"});
            }
            return false;
        }
        if (JSResolveUtil.isInPlaceWhereTypeCanBeDuringCompletion((PsiElement)parent) && JSResolveUtil.isPlaceWhereNsCanBe((PsiElement)grandParent)) {
            consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, false, JSKeywordsCompletionProvider.TYPE_LITERAL_VALUES);
            consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, false, new String[]{"function"});
            consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, accessModifiers);
            consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, new String[]{"extends", "implements", "include", "import", "static", "override", "namespace", "class", "interface", "var", "use"});
            return false;
        }
        return true;
    }

    public void appendSpecificKeywords(@NotNull KeywordCompletionConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/flex/completion/ActionScriptCompletionKeywordsContributor", "appendSpecificKeywords"));
        }
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, new String[]{"is", "as", "class", "interface", "internal", "public", "protected", "native", "override", "dynamic", "extends", "implements", "import", "static", "namespace", "use", "super", "include", "package"});
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, new String[]{"int", "uint"});
    }
}

