/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml.schema;

import com.intellij.codeInsight.daemon.IdeValidationHost;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.javascript.flex.mxml.MxmlLanguageInjector;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlNamespaceHelper;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MxmlLanguageTagsUtil {
    static final String NAME_ATTRIBUTE = "name";
    private static final String[] LANGUAGE_TAGS_ALLOWED_UNDER_ROOT_TAG = new String[]{"Binding", "Declarations", "Library", "Metadata", "Private", "Script", "Style"};
    private static final String[] LANGUAGE_TAGS_ALLOWED_UNDER_INLINE_COMPONENT_ROOT_TAG = new String[]{"Binding", "Declarations", "Metadata", "Script", "Style"};

    private MxmlLanguageTagsUtil() {
    }

    static boolean isComponentTag(XmlTag tag) {
        return tag != null && XmlBackedJSClassImpl.isComponentTag((XmlTag)tag);
    }

    static boolean isFxPrivateTag(XmlTag tag) {
        return MxmlLanguageInjector.isFxPrivateTag(tag);
    }

    static boolean isXmlOrXmlListTag(XmlTag tag) {
        return tag != null && ("XML".equals(tag.getLocalName()) || "XMLList".equals(tag.getLocalName())) && JavaScriptSupportLoader.isLanguageNamespace((String)tag.getNamespace());
    }

    static boolean isFxLibraryTag(XmlTag tag) {
        return MxmlJSClass.isFxLibraryTag(tag);
    }

    static boolean isFxDefinitionTag(XmlTag tag) {
        return tag != null && "Definition".equals(tag.getLocalName()) && "http://ns.adobe.com/mxml/2009".equals(tag.getNamespace());
    }

    static boolean isFxDeclarationsTag(XmlTag tag) {
        return tag != null && "Declarations".equals(tag.getLocalName()) && "http://ns.adobe.com/mxml/2009".equals(tag.getNamespace());
    }

    public static boolean isFxReparentTag(XmlTag tag) {
        return tag != null && "Reparent".equals(tag.getLocalName()) && "http://ns.adobe.com/mxml/2009".equals(tag.getNamespace());
    }

    public static boolean isScriptTag(XmlTag tag) {
        return tag != null && "Script".equals(tag.getLocalName()) && JavaScriptSupportLoader.isLanguageNamespace((String)tag.getNamespace());
    }

    public static boolean isDesignLayerTag(XmlTag tag) {
        return tag != null && "DesignLayer".equals(tag.getLocalName()) && "http://ns.adobe.com/mxml/2009".equals(tag.getNamespace());
    }

    public static boolean isLanguageTagAllowedUnderRootTag(XmlTag tag) {
        return tag != null && ("http://ns.adobe.com/mxml/2009".equals(tag.getNamespace()) || "http://www.adobe.com/2006/mxml".equals(tag.getNamespace())) && ArrayUtil.contains((String)tag.getLocalName(), (String[])LANGUAGE_TAGS_ALLOWED_UNDER_ROOT_TAG);
    }

    public static boolean isLanguageTagAllowedUnderInlineComponentRootTag(XmlTag tag) {
        return tag != null && ("http://ns.adobe.com/mxml/2009".equals(tag.getNamespace()) || "http://www.adobe.com/2006/mxml".equals(tag.getNamespace())) && ArrayUtil.contains((String)tag.getLocalName(), (String[])LANGUAGE_TAGS_ALLOWED_UNDER_INLINE_COMPONENT_ROOT_TAG);
    }

    static void validateFxPrivateTag(XmlTag tag, Validator.ValidationHost host) {
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null || !(parentTag.getParent() instanceof XmlDocument) || tag != parentTag.getSubTags()[parentTag.getSubTags().length - 1]) {
            MxmlLanguageTagsUtil.addErrorMessage((XmlElement)tag, JSBundle.message((String)"javascript.validation.tag.must.be.last.child.of.root.tag", (Object[])new Object[]{tag.getName()}), host, new IntentionAction[0]);
        }
    }

    static void validateFxLibraryTag(XmlTag tag, Validator.ValidationHost host) {
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null || !(parentTag.getParent() instanceof XmlDocument) || tag != parentTag.getSubTags()[0]) {
            MxmlLanguageTagsUtil.addErrorMessage((XmlElement)tag, JSBundle.message((String)"javascript.validation.tag.must.be.first.child.of.root.tag", (Object[])new Object[]{tag.getName()}), host, new IntentionAction[0]);
            return;
        }
        for (XmlAttribute xmlAttribute : tag.getAttributes()) {
            MxmlLanguageTagsUtil.addErrorMessage((XmlElement)xmlAttribute, XmlErrorMessages.message((String)"attribute.is.not.allowed.here", (Object[])new Object[]{xmlAttribute.getName()}), host, new IntentionAction[0]);
        }
        for (XmlAttribute xmlAttribute : tag.getSubTags()) {
            if (MxmlLanguageTagsUtil.isFxDefinitionTag((XmlTag)xmlAttribute)) continue;
            String prefix = tag.getNamespacePrefix();
            String fxDefinitionTag = StringUtil.isEmpty((String)prefix) ? "Definition" : prefix + ":" + "Definition";
            MxmlLanguageTagsUtil.addErrorMessage((XmlElement)xmlAttribute, JSBundle.message((String)"javascript.validation.only.this.tag.is.allowed.here", (Object[])new Object[]{fxDefinitionTag}), host, new IntentionAction[0]);
        }
    }

    static void validateFxDefinitionTag(XmlTag tag, Validator.ValidationHost host) {
        XmlTag parentTag = tag.getParentTag();
        if (!MxmlLanguageTagsUtil.isFxLibraryTag(parentTag)) {
            String prefix = tag.getNamespacePrefix();
            String fxLibraryTag = StringUtil.isEmpty((String)prefix) ? "Library" : prefix + ":" + "Library";
            MxmlLanguageTagsUtil.addErrorMessage((XmlElement)tag, JSBundle.message((String)"javascript.validation.tag.must.be.direct.child.of.fx.library.tag", (Object[])new Object[]{tag.getName(), fxLibraryTag}), host, new IntentionAction[0]);
            return;
        }
        if (tag.getAttribute(NAME_ATTRIBUTE) == null) {
            MxmlLanguageTagsUtil.addErrorMessage((XmlElement)tag, XmlErrorMessages.message((String)"element.doesnt.have.required.attribute", (Object[])new Object[]{tag.getName(), NAME_ATTRIBUTE}), host, new IntentionAction[0]);
            return;
        }
        if (tag.getSubTags().length != 1) {
            MxmlLanguageTagsUtil.addErrorMessage((XmlElement)tag, JSBundle.message((String)"javascript.validation.tag.must.have.exactly.one.child.tag", (Object[])new Object[]{tag.getName()}), host, new IntentionAction[0]);
        }
    }

    static void validateFxReparentTag(XmlTag tag, Validator.ValidationHost host) {
        if (tag.getAttribute("target") == null) {
            MxmlLanguageTagsUtil.addErrorMessage((XmlElement)tag, XmlErrorMessages.message((String)"element.doesnt.have.required.attribute", (Object[])new Object[]{tag.getName(), "target"}), host, new IntentionAction[0]);
            return;
        }
        if (tag.getAttribute("includeIn") == null && tag.getAttribute("excludeFrom") == null) {
            MxmlLanguageTagsUtil.addErrorMessage((XmlElement)tag, JSBundle.message((String)"javascript.validation.tag.must.have.attribute.includein.or.excludefrom", (Object[])new Object[]{tag.getName()}), host, new IntentionAction[0]);
        }
    }

    public static void checkFlex4Attributes(@NotNull XmlTag tag, @NotNull Validator.ValidationHost host, boolean checkStateSpecificAttrs) {
        String[] knownNamespaces;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil", "checkFlex4Attributes"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil", "checkFlex4Attributes"));
        }
        XmlAttribute flex3NamespaceDeclaration = null;
        XmlAttribute flex4NamespaceDeclaration = null;
        XmlAttribute itemCreationPolicyAttr = null;
        XmlAttribute itemDestructionPolicyAttr = null;
        boolean includeInOrExcludeFromAttrPresent = false;
        for (XmlAttribute attribute : tag.getAttributes()) {
            String name = attribute.getName();
            if (attribute.isNamespaceDeclaration()) {
                String namespace = attribute.getValue();
                if ("http://www.adobe.com/2006/mxml".equals(namespace)) {
                    flex3NamespaceDeclaration = attribute;
                    continue;
                }
                if (!"http://ns.adobe.com/mxml/2009".equals(namespace)) continue;
                flex4NamespaceDeclaration = attribute;
                continue;
            }
            if (!checkStateSpecificAttrs) continue;
            if ("includeIn".equals(name) || "excludeFrom".equals(name)) {
                includeInOrExcludeFromAttrPresent = true;
                continue;
            }
            if ("itemCreationPolicy".equals(name)) {
                itemCreationPolicyAttr = attribute;
                continue;
            }
            if (!"itemDestructionPolicy".equals(name)) continue;
            itemDestructionPolicyAttr = attribute;
        }
        if (tag.getParent() instanceof XmlDocument) {
            if (flex3NamespaceDeclaration == null && flex4NamespaceDeclaration == null) {
                IntentionAction[] intentionActionArray;
                knownNamespaces = tag.knownNamespaces();
                boolean suggestFlex3Namespace = true;
                for (String flex4Namespace : MxmlJSClass.FLEX_4_NAMESPACES) {
                    if (!ArrayUtil.contains((String)flex4Namespace, (String[])knownNamespaces)) continue;
                    suggestFlex3Namespace = false;
                    break;
                }
                DeclareNamespaceIntention flex4Intention = new DeclareNamespaceIntention(tag, "fx", "http://ns.adobe.com/mxml/2009");
                if (suggestFlex3Namespace) {
                    IntentionAction[] intentionActionArray2 = new IntentionAction[2];
                    intentionActionArray2[0] = flex4Intention;
                    intentionActionArray = intentionActionArray2;
                    intentionActionArray2[1] = new DeclareNamespaceIntention(tag, "mx", "http://www.adobe.com/2006/mxml");
                } else {
                    IntentionAction[] intentionActionArray3 = new IntentionAction[1];
                    intentionActionArray = intentionActionArray3;
                    intentionActionArray3[0] = flex4Intention;
                }
                IntentionAction[] intentions = intentionActionArray;
                MxmlLanguageTagsUtil.addErrorMessage((XmlElement)tag, FlexBundle.message("root.tag.must.contain.language.namespace", new Object[0]), host, intentions);
            } else if (flex3NamespaceDeclaration != null && flex4NamespaceDeclaration != null) {
                MxmlLanguageTagsUtil.addErrorMessage((XmlElement)flex3NamespaceDeclaration.getValueElement(), FlexBundle.message("different.language.namespaces", new Object[0]), host, new RemoveNamespaceDeclarationIntention(flex3NamespaceDeclaration));
                MxmlLanguageTagsUtil.addErrorMessage((XmlElement)flex4NamespaceDeclaration.getValueElement(), FlexBundle.message("different.language.namespaces", new Object[0]), host, new RemoveNamespaceDeclarationIntention(flex4NamespaceDeclaration));
            }
        } else {
            knownNamespaces = tag.knownNamespaces();
            if (flex3NamespaceDeclaration != null && ArrayUtil.contains((String)"http://ns.adobe.com/mxml/2009", (String[])knownNamespaces)) {
                MxmlLanguageTagsUtil.addErrorMessage((XmlElement)flex3NamespaceDeclaration.getValueElement(), FlexBundle.message("different.language.namespaces", new Object[0]), host, new RemoveNamespaceDeclarationIntention(flex3NamespaceDeclaration));
            }
            if (flex4NamespaceDeclaration != null && ArrayUtil.contains((String)"http://www.adobe.com/2006/mxml", (String[])knownNamespaces)) {
                MxmlLanguageTagsUtil.addErrorMessage((XmlElement)flex4NamespaceDeclaration.getValueElement(), FlexBundle.message("different.language.namespaces", new Object[0]), host, new RemoveNamespaceDeclarationIntention(flex4NamespaceDeclaration));
            }
        }
        if (checkStateSpecificAttrs && !includeInOrExcludeFromAttrPresent) {
            if (itemCreationPolicyAttr != null) {
                MxmlLanguageTagsUtil.addErrorMessage((XmlElement)itemCreationPolicyAttr, FlexBundle.message("must.accompany.includein.or.excludefrom.attribute", itemCreationPolicyAttr.getName()), host, new IntentionAction[0]);
            }
            if (itemDestructionPolicyAttr != null) {
                MxmlLanguageTagsUtil.addErrorMessage((XmlElement)itemDestructionPolicyAttr, FlexBundle.message("must.accompany.includein.or.excludefrom.attribute", itemDestructionPolicyAttr.getName()), host, new IntentionAction[0]);
            }
        }
    }

    private static void addErrorMessage(XmlElement element, String message, Validator.ValidationHost host, IntentionAction ... intentionActions) {
        if (intentionActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionActions", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil", "addErrorMessage"));
        }
        XmlElement target = element;
        XmlToken secondaryTarget = null;
        if (element instanceof XmlAttributeValue) {
            ASTNode value;
            ASTNode node = element.getNode();
            ASTNode aSTNode = value = node == null ? null : XmlChildRole.ATTRIBUTE_VALUE_VALUE_FINDER.findChild(node);
            if (value instanceof PsiElement) {
                target = (PsiElement)value;
            }
        } else if (element instanceof XmlAttributeImpl) {
            target = ((XmlAttributeImpl)element).getNameElement();
        } else if (element instanceof XmlTag) {
            target = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)element));
            secondaryTarget = XmlTagUtil.getEndTagNameElement((XmlTag)((XmlTag)element));
        }
        if (host instanceof IdeValidationHost) {
            if (target != null) {
                ((IdeValidationHost)host).addMessageWithFixes((PsiElement)target, message, Validator.ValidationHost.ErrorType.ERROR, intentionActions);
            }
            if (secondaryTarget != null) {
                ((IdeValidationHost)host).addMessageWithFixes((PsiElement)secondaryTarget, message, Validator.ValidationHost.ErrorType.ERROR, intentionActions);
            }
        } else {
            if (target != null) {
                host.addMessage((PsiElement)target, message, Validator.ValidationHost.ErrorType.ERROR);
            }
            if (secondaryTarget != null) {
                host.addMessage((PsiElement)secondaryTarget, message, Validator.ValidationHost.ErrorType.ERROR);
            }
        }
    }

    private static class DeclareNamespaceIntention
    implements IntentionAction {
        private final XmlTag myRootTag;
        private final String myDefaultPrefix;
        private final String myNamespace;

        private DeclareNamespaceIntention(XmlTag rootTag, String defaultPrefix, String namespace) {
            this.myRootTag = rootTag;
            this.myDefaultPrefix = defaultPrefix;
            this.myNamespace = namespace;
        }

        @NotNull
        public String getText() {
            String string = FlexBundle.message("declare.namespace", this.myNamespace);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil$DeclareNamespaceIntention", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Declare namespace" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil$DeclareNamespaceIntention", "getFamilyName"));
            }
            return "Declare namespace";
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil$DeclareNamespaceIntention", "isAvailable"));
            }
            return this.myRootTag.isValid();
        }

        public boolean startInWriteAction() {
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil$DeclareNamespaceIntention", "invoke"));
            }
            if (!this.myRootTag.isValid()) {
                return;
            }
            Set usedPrefixes = this.myRootTag.getLocalNamespaceDeclarations().keySet();
            int postfix = 1;
            String nsPrefix = this.myDefaultPrefix;
            while (usedPrefixes.contains(nsPrefix)) {
                nsPrefix = this.myDefaultPrefix + postfix++;
            }
            XmlNamespaceHelper.getHelper((PsiFile)file).insertNamespaceDeclaration((XmlFile)file, editor, Collections.singleton(this.myNamespace), nsPrefix, null);
        }
    }

    public static class RemoveNamespaceDeclarationIntention
    implements IntentionAction {
        private final XmlAttribute myAttribute;

        public RemoveNamespaceDeclarationIntention(@NotNull XmlAttribute attribute) {
            if (attribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil$RemoveNamespaceDeclarationIntention", "<init>"));
            }
            this.myAttribute = attribute;
        }

        @NotNull
        public String getText() {
            String string = FlexBundle.message("remove.namespace.declaration", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil$RemoveNamespaceDeclarationIntention", "getText"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = XmlErrorMessages.message((String)"remove.attribute.quickfix.family", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil$RemoveNamespaceDeclarationIntention", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil$RemoveNamespaceDeclarationIntention", "isAvailable"));
            }
            return this.myAttribute.isValid();
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/flex/mxml/schema/MxmlLanguageTagsUtil$RemoveNamespaceDeclarationIntention", "invoke"));
            }
            int offset = RemoveNamespaceDeclarationIntention.removeXmlAttribute(this.myAttribute);
            if (offset != -1) {
                editor.getCaretModel().moveToOffset(offset);
            }
        }

        public static int removeXmlAttribute(XmlAttribute attribute) {
            XmlTag tag = attribute.getParent();
            XmlAttribute nextAttribute = RemoveNamespaceDeclarationIntention.deleteWhiteSpaceTillNextAttribute(attribute);
            if (nextAttribute == null) {
                RemoveNamespaceDeclarationIntention.deletePreviousWhiteSpaces(attribute);
            }
            attribute.delete();
            XmlUtil.reformatTagStart((XmlTag)tag);
            if (nextAttribute != null) {
                return nextAttribute.getTextRange().getStartOffset();
            }
            return -1;
        }

        @Nullable
        private static XmlAttribute deleteWhiteSpaceTillNextAttribute(XmlAttribute attribute) {
            PsiElement nextSibling = attribute.getNextSibling();
            while (nextSibling instanceof PsiWhiteSpace) {
                PsiElement whiteSpace = nextSibling;
                nextSibling = nextSibling.getNextSibling();
                whiteSpace.delete();
            }
            return nextSibling instanceof XmlAttribute ? (XmlAttribute)nextSibling : null;
        }

        @Nullable
        private static PsiElement deletePreviousWhiteSpaces(XmlAttribute attribute) {
            PsiElement prevSibling = attribute.getPrevSibling();
            while (prevSibling instanceof PsiWhiteSpace) {
                PsiElement whiteSpace = prevSibling;
                prevSibling = prevSibling.getPrevSibling();
                whiteSpace.delete();
            }
            return prevSibling;
        }

        public boolean startInWriteAction() {
            return true;
        }
    }
}

