/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.DebuggerCommand;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;

public class SendCommandToDebuggerAction
extends AnAction {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        boolean internal = ApplicationManagerEx.getApplicationEx().isInternal();
        e.getPresentation().setVisible(internal);
        e.getPresentation().setEnabled(internal && XDebuggerManager.getInstance((Project)project).getCurrentSession() != null);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        new MyDialogWrapper(project, xDebugSession).show();
    }

    static class MyDialogWrapper
    extends DialogWrapper {
        private final XDebugSession session;
        private JPanel myPanel;
        private JTextArea myResultArea;
        private JTextArea myCommandArea;

        protected MyDialogWrapper(Project project, XDebugSession xDebugSession) {
            super(project, false);
            this.session = xDebugSession;
            this.$$$setupUI$$$();
            this.setOKButtonText("Send");
            this.setTitle("Send Commands to Flex Debugger");
            this.setModal(false);
            this.init();
        }

        protected String getDimensionServiceKey() {
            return "flex.debug.send.commands.to.flex.debugger.service.key";
        }

        protected void doOKAction() {
            this.getOKAction().setEnabled(false);
            ((FlexDebugProcess)this.session.getDebugProcess()).sendCommand(new DebuggerCommand(this.myCommandArea.getText(), CommandOutputProcessingType.SPECIAL_PROCESSING){

                @Override
                CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        myResultArea.setText(s);
                        this.getOKAction().setEnabled(true);
                    }, ModalityState.defaultModalityState());
                    return CommandOutputProcessingMode.DONE;
                }
            });
        }

        protected JComponent createCenterPanel() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextArea jTextArea;
            JTextArea jTextArea2;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBScrollPane jBScrollPane = new JBScrollPane();
            jPanel.add((Component)jBScrollPane, new GridConstraints(1, 1, 1, 1, 0, 3, 7, 7, null, null, null));
            this.myResultArea = jTextArea2 = new JTextArea();
            jTextArea2.setText("");
            jTextArea2.setEditable(false);
            jBScrollPane.setViewportView(jTextArea2);
            JBScrollPane jBScrollPane2 = new JBScrollPane();
            jPanel.add((Component)jBScrollPane2, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 7, null, null, null));
            this.myCommandArea = jTextArea = new JTextArea();
            jBScrollPane2.setViewportView(jTextArea);
            JLabel jLabel = new JLabel();
            jLabel.setText("Command");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Result");
            jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            jLabel2.setLabelFor(jTextArea2);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }
    }
}

