/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunConfiguration;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitRunnerParameters;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.WhatToTestForm;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.run.BCCombo;
import com.intellij.lang.javascript.flex.run.FlashRunConfigurationForm;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlexLauncherDialog;
import com.intellij.lang.javascript.flex.run.LauncherParameters;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class FlexUnitRunConfigurationForm
extends SettingsEditor<FlexUnitRunConfiguration> {
    private JPanel myMainPanel;
    private BCCombo myBCCombo;
    private WhatToTestForm myWhatToTestForm;
    private JCheckBox myShowLogCheckBox;
    private JComboBox myLogLevelCombo;
    private JLabel myLauncherParametersLabel;
    private TextFieldWithBrowseButton myLauncherParametersTextWithBrowse;
    private JCheckBox myRunTrustedCheckBox;
    private JBLabel myEmulatorAdlOptionsLabel;
    private RawCommandLineEditor myEmulatorAdlOptionsEditor;
    private JLabel myAppDescriptorForEmulatorLabel;
    private JComboBox myAppDescriptorForEmulatorCombo;
    private final Project myProject;
    private LauncherParameters myLauncherParameters;

    public FlexUnitRunConfigurationForm(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myBCCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlexUnitRunConfigurationForm.this.myWhatToTestForm.updateOnBCChange(FlexUnitRunConfigurationForm.this.myBCCombo.getBC(), FlexUnitRunConfigurationForm.this.myBCCombo.getModule());
                FlexUnitRunConfigurationForm.this.myAppDescriptorForEmulatorCombo.repaint();
                FlexUnitRunConfigurationForm.this.updateControls();
            }
        });
        this.initLogLevelControls();
        this.initLaunchWithTextWithBrowse();
        FlashRunConfigurationForm.initAppDescriptorForEmulatorCombo(this.myAppDescriptorForEmulatorCombo, (NullableComputable<FlexBuildConfiguration>)((NullableComputable)() -> this.myBCCombo.getBC()));
    }

    private void initLogLevelControls() {
        this.myShowLogCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FlexUnitRunConfigurationForm.this.myShowLogCheckBox.isSelected()) {
                    IdeFocusManager.getInstance((Project)FlexUnitRunConfigurationForm.this.myProject).requestFocus((Component)FlexUnitRunConfigurationForm.this.myLogLevelCombo, false);
                }
                FlexUnitRunConfigurationForm.this.updateControls();
            }
        });
        this.myLogLevelCombo.setModel(new EnumComboBoxModel(FlexUnitRunnerParameters.OutputLogLevel.class));
    }

    private void initLaunchWithTextWithBrowse() {
        this.myLauncherParametersTextWithBrowse.getTextField().setEditable(false);
        this.myLauncherParametersTextWithBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlexLauncherDialog dialog = new FlexLauncherDialog(FlexUnitRunConfigurationForm.this.myProject, FlexUnitRunConfigurationForm.this.myLauncherParameters);
                if (dialog.showAndGet()) {
                    FlexUnitRunConfigurationForm.this.myLauncherParameters = dialog.getLauncherParameters();
                    FlexUnitRunConfigurationForm.this.updateControls();
                }
            }
        });
    }

    private void updateControls() {
        FlexBuildConfiguration bc;
        if (this.myShowLogCheckBox.isSelected()) {
            this.myLogLevelCombo.setEnabled(true);
            if (this.myLogLevelCombo.getSelectedItem() == null) {
                this.myLogLevelCombo.setSelectedItem((Object)FlexUnitRunnerParameters.OutputLogLevel.values()[0]);
            }
        } else {
            this.myLogLevelCombo.setEnabled(false);
        }
        boolean webPlatform = (bc = this.myBCCombo.getBC()) != null && bc.getTargetPlatform() == TargetPlatform.Web;
        boolean mobilePlatform = bc != null && bc.getTargetPlatform() == TargetPlatform.Mobile;
        boolean app = bc != null && bc.getOutputType() == OutputType.Application;
        this.myLauncherParametersLabel.setVisible(webPlatform);
        this.myLauncherParametersTextWithBrowse.setVisible(webPlatform);
        this.myRunTrustedCheckBox.setVisible(webPlatform);
        this.myEmulatorAdlOptionsLabel.setVisible(mobilePlatform);
        this.myEmulatorAdlOptionsEditor.setVisible(mobilePlatform);
        this.myAppDescriptorForEmulatorLabel.setVisible(app && mobilePlatform);
        this.myAppDescriptorForEmulatorCombo.setVisible(app && mobilePlatform);
        if (webPlatform) {
            this.myLauncherParametersTextWithBrowse.getTextField().setText(this.myLauncherParameters.getPresentableText());
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfigurationForm", "createEditor"));
        }
        return jPanel;
    }

    protected void resetEditorFrom(@NotNull FlexUnitRunConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfigurationForm", "resetEditorFrom"));
        }
        FlexUnitRunnerParameters params = config.getRunnerParameters();
        this.myLauncherParameters = params.getLauncherParameters().clone();
        this.myBCCombo.resetFrom(params);
        this.myWhatToTestForm.resetFrom(this.myBCCombo.getModule(), this.myBCCombo.getBC(), params);
        this.myShowLogCheckBox.setSelected(params.getOutputLogLevel() != null);
        this.myLogLevelCombo.setEnabled(params.getOutputLogLevel() != null);
        this.myLogLevelCombo.setSelectedItem((Object)(params.getOutputLogLevel() == null ? null : params.getOutputLogLevel()));
        this.myRunTrustedCheckBox.setSelected(params.isTrusted());
        this.myEmulatorAdlOptionsEditor.setText(params.getEmulatorAdlOptions());
        this.myAppDescriptorForEmulatorCombo.setSelectedItem((Object)params.getAppDescriptorForEmulator());
    }

    protected void applyEditorTo(@NotNull FlexUnitRunConfiguration config) throws ConfigurationException {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/javascript/flex/flexunit/FlexUnitRunConfigurationForm", "applyEditorTo"));
        }
        FlexUnitRunnerParameters params = config.getRunnerParameters();
        this.myBCCombo.applyTo(params);
        this.myWhatToTestForm.applyTo(params);
        FlexUnitRunnerParameters.OutputLogLevel logLevel = this.myShowLogCheckBox.isSelected() ? (FlexUnitRunnerParameters.OutputLogLevel)((Object)this.myLogLevelCombo.getSelectedItem()) : null;
        params.setOutputLogLevel(logLevel);
        params.setLauncherParameters(this.myLauncherParameters);
        params.setTrusted(this.myRunTrustedCheckBox.isSelected());
        params.setEmulatorAdlOptions(this.myEmulatorAdlOptionsEditor.getText().trim());
        params.setAppDescriptorForEmulator((FlashRunnerParameters.AppDescriptorForEmulator)((Object)this.myAppDescriptorForEmulatorCombo.getSelectedItem()));
    }

    protected void disposeEditor() {
        this.myBCCombo.dispose();
        this.myWhatToTestForm.dispose();
    }

    private void createUIComponents() {
        this.myBCCombo = new BCCombo(this.myProject);
        this.myWhatToTestForm = new WhatToTestForm(this.myProject, (ThrowableComputable<Module, RuntimeConfigurationError>)((ThrowableComputable)() -> {
            Module module = this.myBCCombo.getModule();
            if (module != null) {
                return module;
            }
            throw new RuntimeConfigurationError(FlexBundle.message("bc.not.specified", new Object[0]));
        }), (ThrowableComputable<FlexUnitSupport, RuntimeConfigurationError>)((ThrowableComputable)() -> {
            FlexBuildConfiguration bc = this.myBCCombo.getBC();
            if (bc == null) {
                throw new RuntimeConfigurationError(FlexBundle.message("bc.not.specified", new Object[0]));
            }
            FlexUnitSupport support = FlexUnitSupport.getSupport(bc, this.myBCCombo.getModule());
            if (support != null) {
                return support;
            }
            throw new RuntimeConfigurationError(FlexBundle.message("flexunit.not.found.for.bc", bc.getName()));
        }));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JBLabel jBLabel;
        JComboBox jComboBox;
        RawCommandLineEditor rawCommandLineEditor;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        JCheckBox jCheckBox2;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Build configuration:");
        jLabel3.setDisplayedMnemonic('C');
        jLabel3.setDisplayedMnemonicIndex(6);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        BCCombo bCCombo = this.myBCCombo;
        jPanel.add((Component)bCCombo, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        WhatToTestForm whatToTestForm = this.myWhatToTestForm;
        JComponent jComponent = whatToTestForm.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Options", (int)0, (int)0, null, null));
        this.myLogLevelCombo = jComboBox2 = new JComboBox();
        jComboBox2.setToolTipText("Log messages with level equal or higher than specified will be shown");
        jPanel2.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(100, -1), null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myShowLogCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Show test log output:");
        jCheckBox2.setMnemonic('W');
        jCheckBox2.setDisplayedMnemonicIndex(3);
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLauncherParametersLabel = jLabel2 = new JLabel();
        jLabel2.setText("Launch with:");
        jLabel2.setDisplayedMnemonic('N');
        jLabel2.setDisplayedMnemonicIndex(3);
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLauncherParametersTextWithBrowse = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myRunTrustedCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/lang/javascript/flex/FlexBundle").getString("run.trusted"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myEmulatorAdlOptionsEditor = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("ADL Options");
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(3, 1, 1, 2, 8, 1, 6, 0, null, null, null));
        this.myAppDescriptorForEmulatorCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(4, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEmulatorAdlOptionsLabel = jBLabel = new JBLabel();
        jBLabel.setText("ADL options:");
        jBLabel.setDisplayedMnemonic('O');
        jBLabel.setDisplayedMnemonicIndex(4);
        jPanel4.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAppDescriptorForEmulatorLabel = jLabel = new JLabel();
        jLabel.setText("App descriptor:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel3.setLabelFor(bCCombo);
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel.setLabelFor((Component)rawCommandLineEditor);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

