/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.ComponentSet;
import com.intellij.flex.model.bc.LinkageType;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.library.FlexLibraryProperties;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.FlexBCConfigurator;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.BuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.Dependencies;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableBuildConfigurationEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencies;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyType;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableSharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SdkEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.Factory;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexLibraryIdGenerator;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.projectStructure.ui.AddItemPopupAction;
import com.intellij.lang.javascript.flex.projectStructure.ui.ChooseBuildConfigurationDialog;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompositeConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.EditableTreeTable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexProjectStructureUtil;
import com.intellij.lang.javascript.flex.sdk.FlexSdkType2;
import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.lang.javascript.flex.sdk.FlexmojosSdkType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.UIRootConfigurationAccessor;
import com.intellij.openapi.roots.ui.configuration.classpath.CreateModuleLibraryChooser;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.EditExistingLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.GlobalLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.ChooseLibrariesFromTablesDialog;
import icons.FlexIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesConfigurable
extends NamedConfigurable<Dependencies>
implements Place.Navigator {
    private static final Logger LOG = Logger.getInstance((String)DependenciesConfigurable.class.getName());
    public static final String TAB_NAME = FlexBundle.message("bc.tab.dependencies.display.name", new Object[0]);
    private static final Icon MISSING_BC_ICON = null;
    private JPanel myMainPanel;
    private JdkComboBox mySdkCombo;
    private JLabel myTargetPlayerLabel;
    private JComboBox myTargetPlayerCombo;
    private JLabel myTargetPlayerWarning;
    private JLabel myComponentSetLabel;
    private JComboBox myComponentSetCombo;
    private JLabel myFrameworkLinkageLabel;
    private JComboBox myFrameworkLinkageCombo;
    private JLabel myWarning;
    private JPanel myTablePanel;
    private JButton myNewButton;
    private JButton myEditButton;
    private JLabel mySdkLabel;
    private final EditableTreeTable<MyTableItem> myTable;
    private final Project myProject;
    private final ModifiableDependencies myDependencies;
    private AddItemPopupAction[] myPopupActions;
    private final Disposable myDisposable;
    private final BuildConfigurationNature myNature;
    private final FlexProjectConfigurationEditor myConfigEditor;
    private final ProjectSdksModel mySkdsModel;
    private boolean myFreeze;
    private final EventDispatcher<ChangeListener> mySdkChangeDispatcher;
    private final EventDispatcher<UserActivityListener> myUserActivityDispatcher;
    private boolean myReset;
    private static final TableCellRenderer LINKAGE_TYPE_RENDERER = new DefaultTableCellRenderer(){
        private ComboBoxTableRenderer<LinkageType> myComboBoxTableRenderer = new ComboBoxTableRenderer(null);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object tableItem = ((EditableTreeTable)((Object)table)).getItemAt(row);
            if (tableItem instanceof MyTableItem && ((MyTableItem)tableItem).isLinkageEditable()) {
                this.myComboBoxTableRenderer.setFont(table.getFont());
                return this.myComboBoxTableRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    };
    private static final DefaultTableCellRenderer ANE_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setText("ANE");
            return component;
        }
    };
    private static final DefaultTableCellRenderer EMPTY_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            component.setText("");
            return component;
        }
    };
    private static final AbstractTableCellEditor LINKAGE_TYPE_EDITOR = new AbstractTableCellEditor(){
        private JBComboBoxTableCellEditorComponent myCombo;

        public Object getCellEditorValue() {
            return this.myCombo.getEditorValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myCombo = new JBComboBoxTableCellEditorComponent(table);
            this.myCombo.setCell(table, row, column);
            this.myCombo.setOptions((Object[])LinkageType.getSwcLinkageValues());
            this.myCombo.setDefaultValue(value);
            this.myCombo.setToString(o -> ((LinkageType)o).getShortText());
            return this.myCombo;
        }
    };
    private static final ColumnInfo<MyTableItem, LinkageType> DEPENDENCY_TYPE_COLUMN = new ColumnInfo<MyTableItem, LinkageType>("Linkage"){

        public LinkageType valueOf(MyTableItem item) {
            return item.getLinkageType();
        }

        public void setValue(MyTableItem item, LinkageType linkageType) {
            item.setLinkageType(linkageType);
        }

        public TableCellRenderer getRenderer(MyTableItem item) {
            return item.showLinkage() ? (item.isANE() ? ANE_RENDERER : LINKAGE_TYPE_RENDERER) : EMPTY_RENDERER;
        }

        public TableCellEditor getEditor(MyTableItem item) {
            return LINKAGE_TYPE_EDITOR;
        }

        public boolean isCellEditable(MyTableItem item) {
            return item.isLinkageEditable();
        }

        public int getWidth(JTable table) {
            return new JLabel((String)LinkageType.External.getShortText()).getPreferredSize().width + 20;
        }
    };

    public DependenciesConfigurable(ModifiableFlexBuildConfiguration bc, Project project, @NotNull FlexProjectConfigurationEditor configEditor, final ProjectSdksModel sdksModel) {
        if (configEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configEditor", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable", "<init>"));
        }
        this.mySkdsModel = sdksModel;
        this.myConfigEditor = configEditor;
        this.$$$setupUI$$$();
        this.myDependencies = bc.getDependencies();
        this.myProject = project;
        this.myNature = bc.getNature();
        this.mySdkChangeDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myDisposable = Disposer.newDisposable();
        final SdkModel.Listener listener = new SdkModel.Listener(){

            public void sdkAdded(Sdk sdk) {
                DependenciesConfigurable.this.rebuildSdksModel();
            }

            public void beforeSdkRemove(Sdk sdk) {
                DependenciesConfigurable.this.rebuildSdksModel();
            }

            public void sdkChanged(Sdk sdk, String previousName) {
                DependenciesConfigurable.this.rebuildSdksModel();
            }

            public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
                DependenciesConfigurable.this.rebuildSdksModel();
            }
        };
        sdksModel.addListener(listener);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                sdksModel.removeListener(listener);
            }
        });
        this.mySdkCombo.setSetupButton(this.myNewButton, this.myProject, sdksModel, (JdkComboBox.JdkComboBoxItem)new JdkComboBox.NoneJdkComboBoxItem(), null, FlexBundle.message("set.up.sdk.title", new Object[0]));
        this.mySdkCombo.setEditButton(this.myEditButton, this.myProject, (Computable)((NullableComputable)() -> this.mySdkCombo.getSelectedJdk()));
        this.mySdkLabel.setLabelFor((Component)this.mySdkCombo);
        this.mySdkCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DependenciesConfigurable.this.myFreeze) {
                    return;
                }
                DependenciesConfigurable.this.updateOnSelectedSdkChange();
            }
        });
        this.myComponentSetCombo.setModel(new DefaultComboBoxModel<ComponentSet>(ComponentSet.values()));
        this.myComponentSetCombo.setRenderer(new ListCellRendererWrapper<ComponentSet>(){

            public void customize(JList list, ComponentSet value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentableText());
            }
        });
        this.myFrameworkLinkageCombo.setRenderer(new ListCellRendererWrapper<LinkageType>(){

            public void customize(JList list, LinkageType value, int index, boolean selected, boolean hasFocus) {
                if (value == LinkageType.Default) {
                    Sdk sdk = DependenciesConfigurable.this.mySdkCombo.getSelectedJdk();
                    String sdkVersion = sdk != null ? sdk.getVersionString() : null;
                    this.setText(sdkVersion == null ? "Default" : MessageFormat.format("Default ({0})", FlexCommonUtils.getDefaultFrameworkLinkage((String)sdkVersion, (BuildConfigurationNature)DependenciesConfigurable.this.myNature).getLongText()));
                } else {
                    this.setText(value.getLongText());
                }
            }
        });
        this.myFrameworkLinkageCombo.setModel(new DefaultComboBoxModel<LinkageType>(BCUtils.getSuitableFrameworkLinkages(this.myNature)));
        ItemListener updateSdkItemsListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (DependenciesConfigurable.this.myFreeze) {
                    return;
                }
                DefaultMutableTreeNode sdkNode = DependenciesConfigurable.this.findSdkNode();
                Sdk currentSdk = DependenciesConfigurable.this.mySdkCombo.getSelectedJdk();
                if (sdkNode != null && currentSdk != null) {
                    DependenciesConfigurable.this.updateSdkEntries(sdkNode, currentSdk);
                    DependenciesConfigurable.this.myTable.refresh();
                }
            }
        };
        this.myTargetPlayerCombo.addItemListener(updateSdkItemsListener);
        this.myComponentSetCombo.addItemListener(updateSdkItemsListener);
        this.myFrameworkLinkageCombo.addItemListener(updateSdkItemsListener);
        this.myTargetPlayerWarning.setIcon(FlexIcons.Flex.SmallWarning);
        this.myWarning.setIcon(UIUtil.getBalloonWarningIcon());
        this.myTable = new EditableTreeTable<MyTableItem>("", new ColumnInfo[]{DEPENDENCY_TYPE_COLUMN}){

            @Override
            protected void render(SimpleColoredComponent c, MyTableItem item) {
                if (item != null) {
                    item.getPresentableText().appendToComponent((ColoredTextContainer)c);
                    c.setIcon(item.getIcon());
                }
            }
        };
        this.myTable.setRootVisible(false);
        this.myTable.getTree().setShowsRootHandles(true);
        this.myTable.getTree().setLineStyleAngled();
        this.myTablePanel.add((Component)ToolbarDecorator.createDecorator(this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                DependenciesConfigurable.this.addItem(button);
            }
        }).setAddActionName(FlexBundle.message("add.dependency.action.name", new Object[0])).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                DependenciesConfigurable.this.removeSelection();
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                MyTableItem item = (MyTableItem)DependenciesConfigurable.this.myTable.getItemAt(DependenciesConfigurable.this.myTable.getSelectedRow());
                if (item instanceof SharedLibraryItem) {
                    DependenciesConfigurable.this.editLibrary((SharedLibraryItem)item);
                }
                if (item instanceof ModuleLibraryItem) {
                    DependenciesConfigurable.this.editLibrary((ModuleLibraryItem)item);
                }
            }
        }).setRemoveActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                if (DependenciesConfigurable.this.myTable.getSelectedRowCount() == 0) {
                    return false;
                }
                for (int row : DependenciesConfigurable.this.myTable.getSelectedRows()) {
                    MyTableItem item = (MyTableItem)DependenciesConfigurable.this.myTable.getItemAt(row);
                    if (!(item instanceof SdkItem) && !(item instanceof SdkEntryItem)) continue;
                    return false;
                }
                return true;
            }
        }).setEditActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                MyTableItem item = (MyTableItem)DependenciesConfigurable.this.myTable.getItemAt(DependenciesConfigurable.this.myTable.getSelectedRow());
                return item != null && item.canEdit();
            }
        }).disableUpDownActions().createPanel(), "Center");
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                if (DependenciesConfigurable.this.myTable.getSelectedRowCount() == 1) {
                    ((MyTableItem)DependenciesConfigurable.this.myTable.getItemAt(DependenciesConfigurable.this.myTable.getSelectedRow())).onDoubleClick();
                    return true;
                }
                return false;
            }
        }.installOn(this.myTable);
        FlexBuildConfigurationsExtension.getInstance().getConfigurator().addListener(new FlexBCConfigurator.Listener(){

            @Override
            public void moduleRemoved(Module module) {
                HashSet<MyTableItem> itemsToRemove = new HashSet<MyTableItem>();
                for (int row = 0; row < DependenciesConfigurable.this.myTable.getRowCount(); ++row) {
                    FlexBCConfigurable configurable;
                    MyTableItem item = (MyTableItem)DependenciesConfigurable.this.myTable.getItemAt(row);
                    if (!(item instanceof BCItem) || (configurable = ((BCItem)item).configurable) == null || configurable.getModule() != module) continue;
                    itemsToRemove.add(item);
                }
                DependenciesConfigurable.this.removeItems(itemsToRemove, true);
            }

            @Override
            public void buildConfigurationRemoved(FlexBCConfigurable configurable) {
                Pair<BCItem, Integer> item = this.findDependencyItem(configurable);
                if (item != null) {
                    DependenciesConfigurable.this.removeItems(Collections.singleton(item.first), true);
                }
            }

            @Override
            public void buildConfigurationRenamed(FlexBCConfigurable configurable) {
                Pair<BCItem, Integer> item = this.findDependencyItem(configurable);
                if (item != null) {
                    DependenciesConfigurable.this.myTable.refreshItemAt((Integer)item.second);
                }
            }

            @Override
            public void natureChanged(FlexBCConfigurable configurable) {
                Pair<BCItem, Integer> item = this.findDependencyItem(configurable);
                if (item != null) {
                    BuildConfigurationNature dependencyNature = ((BCItem)item.first).configurable.getEditableObject().getNature();
                    if (!FlexCommonUtils.checkDependencyType((OutputType)((DependenciesConfigurable)DependenciesConfigurable.this).myNature.outputType, (OutputType)dependencyNature.outputType, (LinkageType)((BCItem)item.first).getLinkageType())) {
                        DependenciesConfigurable.this.removeItems(Collections.singleton(item.first), true);
                    }
                }
            }

            @Nullable
            private Pair<BCItem, Integer> findDependencyItem(FlexBCConfigurable configurable) {
                if (configurable.isParentFor(DependenciesConfigurable.this)) {
                    return null;
                }
                for (int row = 0; row < DependenciesConfigurable.this.myTable.getRowCount(); ++row) {
                    MyTableItem item = (MyTableItem)DependenciesConfigurable.this.myTable.getItemAt(row);
                    if (!(item instanceof BCItem) || ((BCItem)item).configurable != configurable) continue;
                    return Pair.create((Object)((BCItem)item), (Object)row);
                }
                return null;
            }
        }, this.myDisposable);
        this.myConfigEditor.addModulesModelChangeListener(new FlexProjectConfigurationEditor.ModulesModelChangeListener(){

            @Override
            public void modulesModelsChanged(Collection<Module> modules) {
                FlexBCConfigurator configurator = FlexBuildConfigurationsExtension.getInstance().getConfigurator();
                for (Module module : modules) {
                    for (CompositeConfigurable configurable : configurator.getBCConfigurables(module)) {
                        FlexBCConfigurable flexBCConfigurable = FlexBCConfigurable.unwrap(configurable);
                        if (!flexBCConfigurable.isParentFor(DependenciesConfigurable.this)) continue;
                        DependenciesConfigurable.this.resetTable(DependenciesConfigurable.this.myDependencies.getSdkEntry(), true);
                    }
                }
            }
        }, this.myDisposable);
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myMainPanel);
        this.myUserActivityDispatcher = EventDispatcher.create(UserActivityListener.class);
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                if (DependenciesConfigurable.this.myFreeze) {
                    return;
                }
                ((UserActivityListener)DependenciesConfigurable.this.myUserActivityDispatcher.getMulticaster()).stateChanged();
            }
        }, this.myDisposable);
    }

    private void rebuildSdksModel() {
        JdkComboBox.JdkComboBoxItem selectedItem = this.mySdkCombo.getSelectedItem();
        JdkComboBox.NoneJdkComboBoxItem noneSdkItem = new JdkComboBox.NoneJdkComboBoxItem();
        this.myFreeze = true;
        try {
            this.mySdkCombo.reloadModel((JdkComboBox.JdkComboBoxItem)noneSdkItem, this.myProject);
        }
        finally {
            this.myFreeze = false;
        }
        if (selectedItem instanceof JdkComboBox.NoneJdkComboBoxItem) {
            this.mySdkCombo.setSelectedItem((Object)noneSdkItem);
        } else {
            String selectedSdkName = selectedItem.getSdkName();
            if (selectedSdkName != null) {
                Sdk sdk = this.mySkdsModel.findSdk(selectedSdkName);
                if (sdk != null) {
                    this.mySdkCombo.setSelectedJdk(sdk);
                } else {
                    this.mySdkCombo.setInvalidJdk(selectedSdkName);
                }
            } else {
                this.mySdkCombo.setSelectedItem((Object)noneSdkItem);
            }
        }
        if (this.mySdkCombo.getSelectedJdk() != selectedItem.getJdk()) {
            this.updateOnSelectedSdkChange();
        }
        ((ChangeListener)this.mySdkChangeDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    @Nullable
    Sdk getCurrentSdk() {
        return this.mySdkCombo.getSelectedJdk();
    }

    ComponentSet getCurrentComponentSet() {
        return (ComponentSet)this.myComponentSetCombo.getSelectedItem();
    }

    void addSdkChangeListener(ChangeListener changeListener) {
        this.mySdkChangeDispatcher.addListener((EventListener)changeListener);
    }

    @Nullable
    private DefaultMutableTreeNode findSdkNode() {
        for (int row = 0; row < this.myTable.getRowCount(); ++row) {
            MyTableItem item = this.myTable.getItemAt(row);
            if (!(this.myTable.getItemAt(row) instanceof SdkItem) || !(item instanceof SdkItem)) continue;
            return (DefaultMutableTreeNode)this.myTable.getRoot().getChildAt(row);
        }
        return null;
    }

    private void editLibrary(SharedLibraryItem item) {
        Library liveLibrary = item.findLiveLibrary();
        if (liveLibrary != null) {
            GlobalLibrariesConfigurable librariesConfigurable = "application".equals(liveLibrary.getTable().getTableLevel()) ? GlobalLibrariesConfigurable.getInstance((Project)this.myProject) : ProjectLibrariesConfigurable.getInstance((Project)this.myProject);
            Place place = new Place().putPath("category", (Object)librariesConfigurable).putPath("treeObject", (Object)liveLibrary);
            ProjectStructureConfigurable.getInstance((Project)this.myProject).navigateTo(place, true);
        }
    }

    private void editLibrary(ModuleLibraryItem item) {
        if (!item.canEdit()) {
            return;
        }
        LibraryOrderEntry entry = item.orderEntry;
        assert (entry != null);
        Library library = entry.getLibrary();
        if (library == null) {
            return;
        }
        LibraryTablePresentation presentation = new LibraryTablePresentation(){

            public String getDisplayName(boolean plural) {
                return FlexBundle.message(plural ? "library.editor.title.plural" : "library.editor.title.singular", new Object[0]);
            }

            public String getDescription() {
                return ProjectBundle.message((String)"libraries.node.text.module", (Object[])new Object[0]);
            }

            public String getLibraryTableEditorTitle() {
                return "Configure Library";
            }
        };
        LibraryTableModifiableModelProvider provider = new LibraryTableModifiableModelProvider(){

            public LibraryTable.ModifiableModel getModifiableModel() {
                return DependenciesConfigurable.this.myConfigEditor.getLibraryModel(DependenciesConfigurable.this.myDependencies);
            }
        };
        StructureConfigurableContext context = ModuleStructureConfigurable.getInstance((Project)this.myProject).getContext();
        EditExistingLibraryDialog dialog = EditExistingLibraryDialog.createDialog((Component)this.myMainPanel, (LibraryTableModifiableModelProvider)provider, (Library)library, (Project)this.myProject, (LibraryTablePresentation)presentation, (StructureConfigurableContext)context);
        dialog.setContextModule(this.myConfigEditor.getModule(this.myDependencies));
        dialog.show();
        this.myTable.refresh();
    }

    private void addItem(AnActionButton button) {
        this.initPopupActions();
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AddItemPopupAction>(FlexBundle.message("add.dependency.popup.title", new Object[0]), this.myPopupActions){

            public Icon getIconFor(AddItemPopupAction aValue) {
                return aValue.getIcon();
            }

            public boolean hasSubstep(AddItemPopupAction selectedValue) {
                return selectedValue.hasSubStep();
            }

            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }

            public PopupStep onChosen(AddItemPopupAction selectedValue, boolean finalChoice) {
                if (selectedValue.hasSubStep()) {
                    return selectedValue.createSubStep();
                }
                return this.doFinalStep(() -> selectedValue.run());
            }

            @NotNull
            public String getTextFor(AddItemPopupAction value) {
                String string = "&" + value.getIndex() + "  " + value.getTitle();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$24", "getTextFor"));
                }
                return string;
            }
        });
        popup.show(button.getPreferredPopupPoint());
    }

    private void removeSelection() {
        TableUtil.stopEditing(this.myTable);
        int[] selectedRows = this.myTable.getSelectedRows();
        HashSet<MyTableItem> itemsToRemove = new HashSet<MyTableItem>(selectedRows.length);
        for (int row : selectedRows) {
            itemsToRemove.add(this.myTable.getItemAt(row));
        }
        this.removeItems(itemsToRemove, true);
        if (this.myTable.getRowCount() > 0) {
            int toSelect = Math.min(this.myTable.getRowCount() - 1, selectedRows[0]);
            this.myTable.clearSelection();
            this.myTable.getSelectionModel().addSelectionInterval(toSelect, toSelect);
        }
    }

    private void removeItems(Set<? extends MyTableItem> itemsToDelete, boolean refresh) {
        if (itemsToDelete.isEmpty()) {
            return;
        }
        DefaultMutableTreeNode root = this.myTable.getRoot();
        int i = 0;
        while (i < root.getChildCount()) {
            Object item = ((DefaultMutableTreeNode)root.getChildAt(i)).getUserObject();
            if (itemsToDelete.contains((MyTableItem)item)) {
                root.remove(i);
                continue;
            }
            ++i;
        }
        if (refresh) {
            this.myTable.refresh();
        }
    }

    private void moveSelection(int delta) {
        DefaultMutableTreeNode child;
        int row;
        int i;
        int[] selectedRows = this.myTable.getSelectedRows();
        Arrays.sort(selectedRows);
        DefaultMutableTreeNode root = this.myTable.getRoot();
        if (delta < 0) {
            for (i = 0; i < selectedRows.length; ++i) {
                row = selectedRows[i];
                child = (DefaultMutableTreeNode)root.getChildAt(row);
                root.remove(row);
                root.insert(child, row + delta);
            }
        } else {
            for (i = selectedRows.length - 1; i >= 0; --i) {
                row = selectedRows[i];
                child = (DefaultMutableTreeNode)root.getChildAt(row);
                root.remove(row);
                root.insert(child, row + delta);
            }
        }
        this.myTable.refresh();
        this.myTable.clearSelection();
        for (int selectedRow : selectedRows) {
            this.myTable.getSelectionModel().addSelectionInterval(selectedRow + delta, selectedRow + delta);
        }
    }

    @Nls
    public String getDisplayName() {
        return TAB_NAME;
    }

    public void setDisplayName(String name) {
    }

    public String getBannerSlogan() {
        return this.getDisplayName();
    }

    public Dependencies getEditableObject() {
        return this.myDependencies;
    }

    public String getHelpTopic() {
        return "BuildConfigurationPage.Dependencies";
    }

    public JComponent createOptionsPanel() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        JdkComboBox.JdkComboBoxItem selectedItem = this.mySdkCombo.getSelectedItem();
        String currentSdkName = selectedItem.getSdkName();
        SdkEntry sdkEntry = this.myDependencies.getSdkEntry();
        if (currentSdkName != null) {
            if (sdkEntry == null) {
                return this.mySdkCombo.getSelectedJdk() != null;
            }
            if (!currentSdkName.equals(sdkEntry.getName())) {
                return true;
            }
        } else if (sdkEntry != null) {
            return true;
        }
        String targetPlayer = (String)this.myTargetPlayerCombo.getSelectedItem();
        if (this.myTargetPlayerCombo.isVisible() && targetPlayer != null && !this.myDependencies.getTargetPlayer().equals(targetPlayer)) {
            return true;
        }
        if (this.myComponentSetCombo.isVisible() && this.myDependencies.getComponentSet() != this.myComponentSetCombo.getSelectedItem()) {
            return true;
        }
        if (this.myFrameworkLinkageCombo.isVisible() && this.myDependencies.getFrameworkLinkage() != this.myFrameworkLinkageCombo.getSelectedItem()) {
            return true;
        }
        List items = this.myTable.getItems();
        items = ContainerUtil.filter(items, item -> !(item instanceof SdkItem) && !(item instanceof SdkEntryItem));
        DependencyEntry[] entries = this.myDependencies.getEntries();
        if (items.size() != entries.length) {
            return true;
        }
        for (int i = 0; i < items.size(); ++i) {
            DependencyEntry entry;
            MyTableItem item2 = (MyTableItem)items.get(i);
            if (!item2.isModified(entry = entries[i])) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        Object targetPlayer = this.myTargetPlayerCombo.getSelectedItem();
        if (this.myTargetPlayerCombo.isVisible() && targetPlayer != null) {
            this.myDependencies.setTargetPlayer((String)targetPlayer);
        }
        if (this.myComponentSetCombo.isVisible()) {
            this.myDependencies.setComponentSet((ComponentSet)this.myComponentSetCombo.getSelectedItem());
        }
        if (this.myFrameworkLinkageCombo.isVisible()) {
            this.myDependencies.setFrameworkLinkage((LinkageType)this.myFrameworkLinkageCombo.getSelectedItem());
        }
        List<MyTableItem> items = this.myTable.getItems();
        ArrayList<ModifiableDependencyEntry> newEntries = new ArrayList<ModifiableDependencyEntry>();
        for (MyTableItem item : items) {
            ModifiableDependencyEntry entry = item.apply(this.myDependencies);
            if (entry == null) continue;
            newEntries.add(entry);
        }
        this.myConfigEditor.setEntries(this.myDependencies, newEntries);
        JdkComboBox.JdkComboBoxItem currentSdk = this.mySdkCombo.getSelectedItem();
        if (currentSdk != null) {
            String sdkName = currentSdk.getSdkName();
            if (sdkName != null) {
                SdkEntry sdkEntry = Factory.createSdkEntry(sdkName);
                this.myDependencies.setSdkEntry(sdkEntry);
            } else {
                this.myDependencies.setSdkEntry(null);
            }
        } else {
            this.myDependencies.setSdkEntry(null);
        }
    }

    public void reset() {
        this.myReset = true;
        SdkEntry sdkEntry = this.myDependencies.getSdkEntry();
        this.myFreeze = true;
        try {
            this.mySdkCombo.reloadModel((JdkComboBox.JdkComboBoxItem)new JdkComboBox.NoneJdkComboBoxItem(), this.myProject);
            if (sdkEntry != null) {
                Sdk sdk = this.mySkdsModel.findSdk(sdkEntry.getName());
                if (sdk != null && (sdk.getSdkType() == FlexSdkType2.getInstance() || sdk.getSdkType() == FlexmojosSdkType.getInstance())) {
                    this.mySdkCombo.setSelectedJdk(sdk);
                } else {
                    this.mySdkCombo.setInvalidJdk(sdkEntry.getName());
                }
            } else {
                this.mySdkCombo.setSelectedJdk(null);
            }
            BCUtils.updateAvailableTargetPlayers(this.mySdkCombo.getSelectedJdk(), this.myTargetPlayerCombo);
            this.myTargetPlayerCombo.setSelectedItem(this.myDependencies.getTargetPlayer());
            this.overriddenTargetPlayerChanged(null);
            this.updateComponentSetCombo();
            this.myComponentSetCombo.setSelectedItem(this.myDependencies.getComponentSet());
            this.myFrameworkLinkageCombo.setSelectedItem(this.myDependencies.getFrameworkLinkage());
            this.resetTable(sdkEntry, false);
            this.updateControls();
        }
        finally {
            this.myFreeze = false;
        }
    }

    private void updateControls() {
        Sdk sdk = this.mySdkCombo.getSelectedJdk();
        boolean flexmojos = sdk != null && sdk.getSdkType() instanceof FlexmojosSdkType;
        this.myTargetPlayerLabel.setVisible(this.myNature.isWebPlatform() && !flexmojos);
        this.myTargetPlayerCombo.setVisible(this.myNature.isWebPlatform() && !flexmojos);
        if (!this.myTargetPlayerCombo.isVisible()) {
            this.myTargetPlayerWarning.setVisible(false);
            this.myWarning.setVisible(false);
        }
        boolean airSdk = FlexSdkUtils.isAirSdkWithoutFlex(sdk);
        boolean visible = sdk != null && !flexmojos && !this.myNature.isMobilePlatform() && !this.myNature.pureAS && !airSdk && StringUtil.compareVersionNumbers((String)sdk.getVersionString(), (String)"4") >= 0;
        this.myComponentSetLabel.setVisible(visible);
        this.myComponentSetCombo.setVisible(visible);
        this.myFrameworkLinkageLabel.setVisible(!this.myNature.pureAS && !flexmojos && !airSdk);
        this.myFrameworkLinkageCombo.setVisible(!this.myNature.pureAS && !flexmojos && !airSdk);
    }

    private void resetTable(SdkEntry sdkEntry, boolean keepSelection) {
        Sdk flexSdk;
        int[] selectedRows = keepSelection ? this.myTable.getSelectedRows() : new int[]{};
        DefaultMutableTreeNode root = this.myTable.getRoot();
        root.removeAllChildren();
        if (sdkEntry != null && (flexSdk = FlexSdkUtils.findFlexOrFlexmojosSdk(sdkEntry.getName())) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new SdkItem(flexSdk), true);
            this.myTable.getRoot().insert(defaultMutableTreeNode, 0);
            this.updateSdkEntries(defaultMutableTreeNode, flexSdk);
        }
        FlexBCConfigurator configurator = FlexBuildConfigurationsExtension.getInstance().getConfigurator();
        for (DependencyEntry entry : this.myDependencies.getEntries()) {
            MyTableItem item = null;
            if (entry instanceof BuildConfigurationEntry) {
                BuildConfigurationEntry bcEntry = (BuildConfigurationEntry)entry;
                Module module = bcEntry.findModule();
                CompositeConfigurable configurable = module != null ? (CompositeConfigurable)((Object)ContainerUtil.find(configurator.getBCConfigurables(module), configurable1 -> configurable1.getDisplayName().equals(bcEntry.getBcName()))) : null;
                item = configurable == null ? new BCItem(bcEntry.getModuleName(), bcEntry.getBcName()) : new BCItem(FlexBCConfigurable.unwrap(configurable));
                item.dependencyType.copyFrom(entry.getDependencyType());
            } else if (entry instanceof ModuleLibraryEntry) {
                ModuleLibraryEntry moduleLibraryEntry = (ModuleLibraryEntry)entry;
                item = new ModuleLibraryItem(moduleLibraryEntry.getLibraryId(), this.myConfigEditor.findLibraryOrderEntry(this.myDependencies, moduleLibraryEntry), this.myProject);
                ((ModuleLibraryItem)item).dependencyType.copyFrom(entry.getDependencyType());
            } else if (entry instanceof SharedLibraryEntry) {
                SharedLibraryEntry sharedLibraryEntry = (SharedLibraryEntry)entry;
                LibrariesModifiableModel model = ProjectStructureConfigurable.getInstance((Project)this.myProject).getContext().createModifiableModelProvider(sharedLibraryEntry.getLibraryLevel()).getModifiableModel();
                LibraryEx library = (LibraryEx)model.getLibraryByName(sharedLibraryEntry.getLibraryName());
                item = new SharedLibraryItem(sharedLibraryEntry.getLibraryName(), sharedLibraryEntry.getLibraryLevel(), (Library)library, this.myProject);
                ((SharedLibraryItem)item).dependencyType.copyFrom(entry.getDependencyType());
            }
            if (item == null) continue;
            root.add(new DefaultMutableTreeNode(item, false));
        }
        this.myTable.refresh();
        this.myTable.clearSelection();
        for (int row : selectedRows) {
            this.myTable.getSelectionModel().addSelectionInterval(row, row);
        }
    }

    public void overriddenTargetPlayerChanged(@Nullable String targetPlayer) {
        this.myTargetPlayerWarning.setToolTipText(FlexBundle.message("actual.value.from.config.file.0", targetPlayer));
        this.myWarning.setText(FlexBundle.message("overridden.in.config.file", "Target player", targetPlayer));
        boolean visible = this.myTargetPlayerCombo.isVisible() && targetPlayer != null;
        this.myTargetPlayerWarning.setVisible(visible);
        this.myWarning.setVisible(visible);
    }

    private void updateComponentSetCombo() {
        this.updateControls();
        Sdk sdk = this.mySdkCombo.getSelectedJdk();
        if (sdk != null && this.myComponentSetCombo.isVisible()) {
            ComponentSet[] componentSetArray;
            Object selectedItem = this.myComponentSetCombo.getSelectedItem();
            if (StringUtil.compareVersionNumbers((String)sdk.getVersionString(), (String)"4.5") >= 0) {
                componentSetArray = ComponentSet.values();
            } else {
                ComponentSet[] componentSetArray2 = new ComponentSet[2];
                componentSetArray2[0] = ComponentSet.SparkAndMx;
                componentSetArray = componentSetArray2;
                componentSetArray2[1] = ComponentSet.MxOnly;
            }
            ComponentSet[] values = componentSetArray;
            this.myComponentSetCombo.setModel(new DefaultComboBoxModel<ComponentSet>(values));
            this.myComponentSetCombo.setSelectedItem(selectedItem);
        }
    }

    private void updateSdkTableItem(@Nullable Sdk sdk) {
        DefaultMutableTreeNode sdkNode = this.findSdkNode();
        if (sdk != null) {
            SdkItem sdkItem = new SdkItem(sdk);
            if (sdkNode != null) {
                sdkNode.setUserObject(sdkItem);
            } else {
                sdkNode = new DefaultMutableTreeNode(sdkItem, true);
                this.myTable.getRoot().insert(sdkNode, 0);
            }
            this.updateSdkEntries(sdkNode, sdk);
        } else if (sdkNode != null) {
            this.myTable.getRoot().remove(sdkNode);
        }
    }

    private void updateSdkEntries(DefaultMutableTreeNode sdkNode, Sdk sdk) {
        sdkNode.removeAllChildren();
        ComponentSet componentSet = (ComponentSet)this.myComponentSetCombo.getSelectedItem();
        String targetPlayer = (String)this.myTargetPlayerCombo.getSelectedItem();
        for (String url : sdk.getRootProvider().getUrls(OrderRootType.CLASSES)) {
            String swcPath = VirtualFileManager.extractPath((String)StringUtil.trimEnd((String)url, (String)"!/"));
            LinkageType linkageType = FlexCommonUtils.getSdkEntryLinkageType((String)sdk.getHomePath(), (String)swcPath, (BuildConfigurationNature)this.myNature, (String)targetPlayer, (ComponentSet)componentSet);
            if (linkageType == null) continue;
            if (linkageType == LinkageType.Default && (linkageType = (LinkageType)this.myFrameworkLinkageCombo.getSelectedItem()) == LinkageType.Default) {
                linkageType = FlexCommonUtils.getDefaultFrameworkLinkage((String)sdk.getVersionString(), (BuildConfigurationNature)this.myNature);
            }
            SdkEntryItem item = new SdkEntryItem(FileUtil.toSystemDependentName((String)swcPath), linkageType);
            sdkNode.add(new DefaultMutableTreeNode(item, false));
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private void createUIComponents() {
        Condition sdkTypeFilter = Conditions.oneOf((Object[])new SdkTypeId[]{FlexSdkType2.getInstance(), FlexmojosSdkType.getInstance()});
        Condition sdkCondition = JdkComboBox.getSdkFilter((Condition)sdkTypeFilter);
        this.mySdkCombo = new JdkComboBox(this.mySkdsModel, sdkTypeFilter, sdkCondition, Conditions.is((Object)((Object)FlexSdkType2.getInstance())), false);
    }

    private void initPopupActions() {
        if (this.myPopupActions == null) {
            int actionIndex = 1;
            ArrayList<AddItemPopupAction> actions = new ArrayList<AddItemPopupAction>();
            actions.add(new AddBuildConfigurationDependencyAction(actionIndex++));
            actions.add(new AddFilesAction(actionIndex++));
            actions.add(new AddSharedLibraryAction(actionIndex++));
            this.myPopupActions = actions.toArray(new AddItemPopupAction[actions.size()]);
        }
    }

    public void addSharedLibraries(List<Library> libraries) {
        DefaultMutableTreeNode rootNode = this.myTable.getRoot();
        for (Library library : libraries) {
            SharedLibraryItem item = new SharedLibraryItem(library.getName(), library.getTable().getTableLevel(), library, this.myProject);
            rootNode.add(new DefaultMutableTreeNode(item, false));
        }
        this.updateTableOnItemsAdded(libraries.size());
    }

    public void addBCDependency(FlexBCConfigurable dependencyConfigurable, LinkageType linkageType) {
        DefaultMutableTreeNode rootNode = this.myTable.getRoot();
        Enumeration<TreeNode> children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
            Object userObject = childNode.getUserObject();
            if (!(userObject instanceof BCItem) || ((BCItem)userObject).configurable != dependencyConfigurable) continue;
            return;
        }
        BCItem item = new BCItem(dependencyConfigurable);
        item.setLinkageType(linkageType);
        rootNode.add(new DefaultMutableTreeNode(item, false));
        this.updateTableOnItemsAdded(1);
    }

    public void removeDependency(String moduleLibraryId) {
        DefaultMutableTreeNode rootNode = this.myTable.getRoot();
        Enumeration<TreeNode> children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
            Object userObject = childNode.getUserObject();
            if (!(userObject instanceof ModuleLibraryItem) || !moduleLibraryId.equals(((ModuleLibraryItem)userObject).libraryId)) continue;
            childNode.removeFromParent();
            this.myTable.refresh();
            return;
        }
    }

    public void removeDependency(String sharedLibraryLevel, String sharedLibraryName) {
        DefaultMutableTreeNode rootNode = this.myTable.getRoot();
        Enumeration<TreeNode> children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
            Object userObject = childNode.getUserObject();
            if (!(userObject instanceof SharedLibraryItem) || !sharedLibraryLevel.equals(((SharedLibraryItem)userObject).libraryLevel) || !sharedLibraryName.equals(((SharedLibraryItem)userObject).libraryName)) continue;
            childNode.removeFromParent();
            this.myTable.refresh();
            return;
        }
    }

    private void updateTableOnItemsAdded(int count) {
        this.myTable.refresh();
        this.myTable.getSelectionModel().clearSelection();
        int rowCount = this.myTable.getRowCount();
        this.myTable.getSelectionModel().addSelectionInterval(rowCount - count, rowCount - 1);
    }

    private void updateOnSelectedSdkChange() {
        Sdk sdk = this.mySdkCombo.getSelectedJdk();
        if (sdk != null && sdk.getSdkType() != FlexSdkType2.getInstance() && sdk.getSdkType() != FlexmojosSdkType.getInstance()) {
            sdk = null;
        }
        BCUtils.updateAvailableTargetPlayers(sdk, this.myTargetPlayerCombo);
        this.updateComponentSetCombo();
        this.updateSdkTableItem(sdk);
        this.myTable.refresh();
        ((ChangeListener)this.mySdkChangeDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
    }

    public void setHistory(History history) {
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        if (place != null) {
            Object location = place.getPath("FlashBuildConfiguration.locationOnTab");
            if (location == Location.SDK) {
                if (requestFocus) {
                    return IdeFocusManager.findInstance().requestFocus((Component)this.mySdkCombo, true);
                }
            } else if (location instanceof Location.TableEntry) {
                for (int row = 0; row < this.myTable.getRowCount(); ++row) {
                    MyTableItem item = this.myTable.getItemAt(row);
                    Location.TableEntry loc = item.getLocation();
                    if (!loc.equals(location)) continue;
                    this.myTable.clearSelection();
                    this.myTable.getSelectionModel().addSelectionInterval(row, row);
                    TableUtil.scrollSelectionToVisible(this.myTable);
                    break;
                }
                if (requestFocus) {
                    return IdeFocusManager.findInstance().requestFocus(this.myTable, true);
                }
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable", "queryPlace"));
        }
    }

    public void libraryReplaced(@NotNull Library library, @Nullable Library replacement) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable", "libraryReplaced"));
        }
        assert (this.myReset);
        List<MyTableItem> items = this.myTable.getItems();
        for (int i = 0; i < items.size(); ++i) {
            MyTableItem item = items.get(i);
            if (!(item instanceof SharedLibraryItem) || ((SharedLibraryItem)item).findLiveLibrary() != library) continue;
            this.removeItems(Collections.singleton(item), replacement == null);
            break;
        }
        if (replacement != null) {
            this.addSharedLibraries(Collections.singletonList(replacement));
        }
    }

    public void addUserActivityListener(UserActivityListener listener, Disposable disposable) {
        this.myUserActivityDispatcher.addListener((EventListener)listener, disposable);
    }

    public void removeUserActivityListeners() {
        for (UserActivityListener listener : this.myUserActivityDispatcher.getListeners()) {
            this.myUserActivityDispatcher.removeListener((EventListener)listener);
        }
    }

    private Pair<String, String> getModuleAndBcName() {
        FlexBCConfigurator configurator = FlexBuildConfigurationsExtension.getInstance().getConfigurator();
        for (Module module : ProjectStructureConfigurable.getInstance((Project)this.myProject).getModulesConfig().getModules()) {
            for (CompositeConfigurable configurable : configurator.getBCConfigurables(module)) {
                FlexBCConfigurable flexBCConfigurable = FlexBCConfigurable.unwrap(configurable);
                if (!flexBCConfigurable.isParentFor(this)) continue;
                return Pair.create((Object)module.getName(), (Object)flexBCConfigurable.getDisplayName());
            }
        }
        return Pair.create((Object)"?", (Object)"?");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        JComboBox jComboBox;
        JButton jButton;
        JButton jButton2;
        JLabel jLabel3;
        JLabel jLabel4;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JLabel jLabel5;
        JLabel jLabel6;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myComponentSetLabel = jLabel6 = new JLabel();
        jLabel6.setText("Component set:");
        jLabel6.setDisplayedMnemonic('O');
        jLabel6.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFrameworkLinkageLabel = jLabel5 = new JLabel();
        jLabel5.setText("Framework linkage:");
        jLabel5.setDisplayedMnemonic('F');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myComponentSetCombo = jComboBox3 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox3.setModel(defaultComboBoxModel);
        jPanel3.add(jComboBox3, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myFrameworkLinkageCombo = jComboBox2 = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel2);
        jPanel3.add(jComboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myTargetPlayerLabel = jLabel4 = new JLabel();
        jLabel4.setText("Target player:");
        jLabel4.setDisplayedMnemonic('P');
        jLabel4.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySdkLabel = jLabel3 = new JLabel();
        jLabel3.setText("Flex/AIR SDK:");
        jLabel3.setDisplayedMnemonic('S');
        jLabel3.setDisplayedMnemonicIndex(9);
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JdkComboBox jdkComboBox = this.mySdkCombo;
        jPanel3.add((Component)jdkComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, new Dimension(200, -1), null));
        this.myEditButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.edit"));
        jPanel3.add((Component)jButton2, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myNewButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/ApplicationBundle").getString("button.new"));
        jPanel3.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myTargetPlayerCombo = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel3 = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel3);
        jPanel4.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, new Dimension(100, -1), null, null));
        this.myTargetPlayerWarning = jLabel2 = new JLabel();
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 1, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 0, 5, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(4, 0, 1, 5, 0, 3, 3, 0, null, null, null));
        this.myWarning = jLabel = new JLabel();
        jLabel.setText("Warning placeholder");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel6.setLabelFor(jComboBox3);
        jLabel5.setLabelFor(jComboBox2);
        jLabel4.setLabelFor(jComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class ChooseLibrariesDialog
    extends ChooseLibrariesFromTablesDialog {
        private final Condition<Library> myFilter;

        public ChooseLibrariesDialog(Condition<Library> liveLibraryFilter) {
            super((JComponent)DependenciesConfigurable.this.myMainPanel, "Choose Libraries", DependenciesConfigurable.this.myProject, false);
            this.myFilter = liveLibraryFilter;
            this.init();
        }

        public void show() {
            if (this.isEmpty()) {
                Disposer.dispose((Disposable)this.getDisposable());
                this.dispose();
                Messages.showInfoMessage((Project)DependenciesConfigurable.this.myProject, (String)"No applicable libraries found", (String)"Add Dependency");
            } else {
                super.show();
            }
        }

        @NotNull
        protected Library[] getLibraries(@NotNull LibraryTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$ChooseLibrariesDialog", "getLibraries"));
            }
            StructureConfigurableContext context = ProjectStructureConfigurable.getInstance((Project)DependenciesConfigurable.this.myProject).getContext();
            Object[] libraries = context.createModifiableModelProvider(table.getTableLevel()).getModifiableModel().getLibraries();
            List filtered = ContainerUtil.mapNotNull((Object[])libraries, library -> {
                Library liveLibrary = context.getLibraryModel(library);
                if (liveLibrary == null || !FlexProjectRootsUtil.isFlexLibrary(liveLibrary) || !this.myFilter.value((Object)liveLibrary)) {
                    return null;
                }
                return liveLibrary;
            });
            Library[] libraryArray = filtered.toArray(new Library[filtered.size()]);
            if (libraryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$ChooseLibrariesDialog", "getLibraries"));
            }
            return libraryArray;
        }
    }

    private static class LibraryTableModifiableModelWrapper
    implements LibraryTable.ModifiableModel {
        private final LibraryTable.ModifiableModel myDelegate;
        private final Condition<Library> myLibraryFilter;

        private LibraryTableModifiableModelWrapper(LibraryTable.ModifiableModel delegate, Condition<Library> libraryFilter) {
            this.myDelegate = delegate;
            this.myLibraryFilter = libraryFilter;
        }

        public Library createLibrary(String name) {
            return this.myDelegate.createLibrary(name);
        }

        public void removeLibrary(@NotNull Library library) {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$LibraryTableModifiableModelWrapper", "removeLibrary"));
            }
            this.myDelegate.removeLibrary(library);
        }

        public void commit() {
            this.myDelegate.commit();
        }

        @NotNull
        public Iterator<Library> getLibraryIterator() {
            FilteringIterator filteringIterator = new FilteringIterator(this.myDelegate.getLibraryIterator(), this.myLibraryFilter);
            if (filteringIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$LibraryTableModifiableModelWrapper", "getLibraryIterator"));
            }
            return filteringIterator;
        }

        @Nullable
        public Library getLibraryByName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$LibraryTableModifiableModelWrapper", "getLibraryByName"));
            }
            Library library = this.myDelegate.getLibraryByName(name);
            return this.myLibraryFilter.value((Object)library) ? library : null;
        }

        @NotNull
        public Library[] getLibraries() {
            List filtered = ContainerUtil.filter((Object[])this.myDelegate.getLibraries(), this.myLibraryFilter);
            Library[] libraryArray = filtered.toArray(new Library[filtered.size()]);
            if (libraryArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$LibraryTableModifiableModelWrapper", "getLibraries"));
            }
            return libraryArray;
        }

        public boolean isChanged() {
            return this.myDelegate.isChanged();
        }

        public Library createLibrary(String name, @Nullable PersistentLibraryKind kind) {
            return this.myDelegate.createLibrary(name, kind);
        }

        public Library createLibrary(String name, @Nullable PersistentLibraryKind type, @Nullable ProjectModelExternalSource externalSource) {
            return this.myDelegate.createLibrary(name, type, externalSource);
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myDelegate);
        }
    }

    private class AddSharedLibraryAction
    extends AddItemPopupAction {
        public AddSharedLibraryAction(int index) {
            super(index, FlexBundle.message("add.shared.library.dependency.action.text", new Object[0]), null);
        }

        @Override
        public void run() {
            HashSet<LibraryEx> usedLibraries = new HashSet<LibraryEx>();
            List items = DependenciesConfigurable.this.myTable.getItems();
            for (MyTableItem item : items) {
                LibraryEx library2;
                if (!(item instanceof SharedLibraryItem) || (library2 = (LibraryEx)((SharedLibraryItem)item).findLiveLibrary()) == null) continue;
                usedLibraries.add(library2);
            }
            ChooseLibrariesDialog d = new ChooseLibrariesDialog((Condition<Library>)((Condition)library -> !usedLibraries.contains(library)));
            if (!d.showAndGet()) {
                return;
            }
            List libraries = d.getSelectedLibraries();
            DependenciesConfigurable.this.addSharedLibraries(libraries);
        }
    }

    private class AddFilesAction
    extends AddItemPopupAction {
        public AddFilesAction(int index) {
            super(index, FlexBundle.message("add.module.library.action.text", new Object[0]), null);
        }

        @Override
        public void run() {
            ArrayList usedLibraries = new ArrayList();
            List items = DependenciesConfigurable.this.myTable.getItems();
            for (MyTableItem item : items) {
                LibraryOrderEntry orderEntry;
                if (!(item instanceof ModuleLibraryItem) || (orderEntry = ((ModuleLibraryItem)item).orderEntry) == null) continue;
                ContainerUtil.addIfNotNull(usedLibraries, (Object)orderEntry.getLibrary());
            }
            Condition filter = library -> usedLibraries.contains(library);
            LibraryTable.ModifiableModel modifiableModel = DependenciesConfigurable.this.myConfigEditor.getLibraryModel(DependenciesConfigurable.this.myDependencies);
            LibraryTableModifiableModelWrapper librariesModelWrapper = new LibraryTableModifiableModelWrapper(modifiableModel, filter);
            Module module = DependenciesConfigurable.this.myConfigEditor.getModule(DependenciesConfigurable.this.myDependencies);
            List<FlexLibraryType> libraryTypes = Collections.singletonList(FlexLibraryType.getInstance());
            CreateModuleLibraryChooser c = new CreateModuleLibraryChooser(libraryTypes, (JComponent)DependenciesConfigurable.this.myMainPanel, module, (LibraryTable.ModifiableModel)librariesModelWrapper, type -> new FlexLibraryProperties(FlexLibraryIdGenerator.generateId()));
            List libraries = c.chooseElements();
            if (libraries.isEmpty()) {
                return;
            }
            DefaultMutableTreeNode rootNode = DependenciesConfigurable.this.myTable.getRoot();
            for (Library library2 : libraries) {
                String libraryId = FlexProjectRootsUtil.getLibraryId(library2);
                LibraryOrderEntry libraryEntry = DependenciesConfigurable.this.myConfigEditor.findLibraryOrderEntry(DependenciesConfigurable.this.myDependencies, library2);
                rootNode.add(new DefaultMutableTreeNode(new ModuleLibraryItem(libraryId, libraryEntry, DependenciesConfigurable.this.myProject), false));
            }
            DependenciesConfigurable.this.updateTableOnItemsAdded(libraries.size());
        }
    }

    private class AddBuildConfigurationDependencyAction
    extends AddItemPopupAction {
        public AddBuildConfigurationDependencyAction(int index) {
            super(index, "Build Configuration...", null);
        }

        @Override
        public void run() {
            ArrayList<FlexBCConfigurable> dependencies = new ArrayList<FlexBCConfigurable>();
            List items = DependenciesConfigurable.this.myTable.getItems();
            for (MyTableItem item : items) {
                FlexBCConfigurable configurable2;
                if (!(item instanceof BCItem) || (configurable2 = ((BCItem)item).configurable) == null) continue;
                dependencies.add(configurable2);
            }
            ChooseBuildConfigurationDialog d = ChooseBuildConfigurationDialog.createForApplicableBCs(FlexBundle.message("add.bc.dependency.dialog.title", new Object[0]), FlexBundle.message("add.dependency.bc.dialog.label", new Object[0]), DependenciesConfigurable.this.myProject, false, (Condition<FlexBCConfigurable>)((Condition)configurable -> {
                if (dependencies.contains(configurable) || configurable.isParentFor(DependenciesConfigurable.this)) {
                    return false;
                }
                return BCUtils.isApplicableForDependency(DependenciesConfigurable.this.myNature, configurable.getOutputType());
            }));
            if (d == null) {
                Messages.showInfoMessage((Project)DependenciesConfigurable.this.myProject, (String)FlexBundle.message("no.applicable.bcs", new Object[0]), (String)FlexBundle.message("add.bc.dependency.dialog.title", new Object[0]));
                return;
            }
            if (!d.showAndGet()) {
                return;
            }
            FlexBCConfigurable[] configurables = d.getSelectedConfigurables();
            DefaultMutableTreeNode root = DependenciesConfigurable.this.myTable.getRoot();
            for (FlexBCConfigurable configurable3 : configurables) {
                root.add(new DefaultMutableTreeNode(new BCItem(configurable3), false));
            }
            DependenciesConfigurable.this.myTable.refresh();
            DependenciesConfigurable.this.myTable.getSelectionModel().clearSelection();
            int rowCount = DependenciesConfigurable.this.myTable.getRowCount();
            DependenciesConfigurable.this.myTable.getSelectionModel().addSelectionInterval(rowCount - configurables.length, rowCount - 1);
        }
    }

    private static class SdkEntryItem
    extends MyTableItem {
        private final String url;
        private final LinkageType linkageType;

        private SdkEntryItem(String url, LinkageType linkageType) {
            this.url = url;
            this.linkageType = linkageType;
        }

        @Override
        public SimpleColoredText getPresentableText() {
            return new SimpleColoredText(this.url, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        @Override
        public boolean isLinkageEditable() {
            return false;
        }

        @Override
        public LinkageType getLinkageType() {
            return this.linkageType;
        }

        @Override
        public void setLinkageType(LinkageType linkageType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Location.TableEntry getLocation() {
            return Location.TableEntry.forSdkRoot(this.url);
        }
    }

    private static class SdkItem
    extends MyTableItem {
        private final Sdk mySdk;
        private final SdkType mySdkType;

        public SdkItem(Sdk sdk) {
            this.mySdk = sdk;
            this.mySdkType = (SdkType)sdk.getSdkType();
        }

        @Override
        public SimpleColoredText getPresentableText() {
            SimpleColoredText text = new SimpleColoredText();
            String sdkVersion = StringUtil.notNullize((String)this.mySdk.getVersionString(), (String)FlexBundle.message("flex.sdk.version.unknown", new Object[0]));
            if (sdkVersion.startsWith("AIR SDK ")) {
                text.append(sdkVersion, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            } else {
                text.append("Flex SDK " + sdkVersion, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String airSdkVersion = FlexCommonUtils.getVersionOfAirSdkIncludedInFlexSdk((String)this.mySdk.getHomePath());
                if (airSdkVersion != null) {
                    text.append(", AIR SDK " + airSdkVersion, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
            return text;
        }

        @Override
        public Icon getIcon() {
            return this.mySdkType.getIcon();
        }

        @Override
        public boolean showLinkage() {
            return false;
        }

        @Override
        public LinkageType getLinkageType() {
            return null;
        }

        @Override
        public boolean isLinkageEditable() {
            return false;
        }

        @Override
        public void setLinkageType(LinkageType linkageType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Location.TableEntry getLocation() {
            return Location.TableEntry.SDK_ENTRY;
        }
    }

    private class SharedLibraryItem
    extends MyTableItem {
        public final ModifiableDependencyType dependencyType;
        public final String libraryName;
        public final String libraryLevel;
        @Nullable
        public final Library liveLibrary;
        private final Project project;

        public SharedLibraryItem(@NotNull String libraryName, @Nullable String libraryLevel, @NotNull Library liveLibrary, Project project) {
            if (libraryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$SharedLibraryItem", "<init>"));
            }
            if (libraryLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryLevel", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$SharedLibraryItem", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$SharedLibraryItem", "<init>"));
            }
            this.dependencyType = Factory.createDependencyTypeInstance();
            this.libraryName = libraryName;
            this.libraryLevel = libraryLevel;
            this.liveLibrary = liveLibrary;
            this.project = project;
        }

        @Override
        public SimpleColoredText getPresentableText() {
            Library liveLibrary = this.findLiveLibrary();
            if (liveLibrary != null) {
                String text = OrderEntryAppearanceService.getInstance().forLibrary(this.project, liveLibrary, false).getText();
                return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            return new SimpleColoredText(this.libraryName, SimpleTextAttributes.ERROR_ATTRIBUTES);
        }

        @Nullable
        public Library findLiveLibrary() {
            return new UIRootConfigurationAccessor(this.project).getLibrary(this.liveLibrary, this.libraryName, this.libraryLevel);
        }

        @Override
        public boolean isLinkageEditable() {
            return !this.isANE();
        }

        @Override
        public boolean isANE() {
            VirtualFile[] files;
            for (VirtualFile file : files = this.liveLibrary == null ? VirtualFile.EMPTY_ARRAY : this.liveLibrary.getFiles(OrderRootType.CLASSES)) {
                if (!"ane".equalsIgnoreCase(file.getExtension())) continue;
                return true;
            }
            return false;
        }

        @Override
        public LinkageType getLinkageType() {
            return this.dependencyType.getLinkageType();
        }

        @Override
        public void setLinkageType(LinkageType linkageType) {
            this.dependencyType.setLinkageType(linkageType);
        }

        @Override
        public void onDoubleClick() {
            DependenciesConfigurable.this.editLibrary(this);
        }

        @Override
        public ModifiableDependencyEntry apply(ModifiableDependencies dependencies) {
            Library liveLibrary = this.findLiveLibrary();
            ModifiableDependencyEntry entry = liveLibrary != null ? DependenciesConfigurable.this.myConfigEditor.createSharedLibraryEntry(dependencies, liveLibrary.getName(), liveLibrary.getTable().getTableLevel()) : DependenciesConfigurable.this.myConfigEditor.createSharedLibraryEntry(dependencies, this.libraryName, this.libraryLevel);
            entry.getDependencyType().copyFrom(this.dependencyType);
            return entry;
        }

        @Override
        public boolean isModified(DependencyEntry entry) {
            if (!(entry instanceof ModifiableSharedLibraryEntry)) {
                return true;
            }
            ModifiableSharedLibraryEntry libraryEntry = (ModifiableSharedLibraryEntry)entry;
            Library liveLibrary = this.findLiveLibrary();
            if (liveLibrary != null) {
                if (!liveLibrary.getName().equals(libraryEntry.getLibraryName())) {
                    return true;
                }
                if (!liveLibrary.getTable().getTableLevel().equals(libraryEntry.getLibraryLevel())) {
                    return true;
                }
            } else {
                if (!this.libraryName.equals(libraryEntry.getLibraryName())) {
                    return true;
                }
                if (!this.libraryLevel.equals(libraryEntry.getLibraryLevel())) {
                    return true;
                }
            }
            return !this.dependencyType.isEqual(entry.getDependencyType());
        }

        @Override
        public boolean canEdit() {
            return true;
        }

        @Override
        public Location.TableEntry getLocation() {
            Library liveLibrary = this.findLiveLibrary();
            return liveLibrary != null ? Location.TableEntry.forSharedLibrary(liveLibrary) : Location.TableEntry.forSharedLibrary(this.libraryLevel, this.libraryName);
        }
    }

    private class ModuleLibraryItem
    extends MyTableItem {
        public final ModifiableDependencyType dependencyType;
        public final String libraryId;
        @Nullable
        public final LibraryOrderEntry orderEntry;
        private final Project project;

        public ModuleLibraryItem(@Nullable String libraryId, @NotNull LibraryOrderEntry orderEntry, Project project) {
            if (libraryId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryId", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$ModuleLibraryItem", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$ModuleLibraryItem", "<init>"));
            }
            this.dependencyType = Factory.createDependencyTypeInstance();
            this.libraryId = libraryId;
            this.orderEntry = orderEntry;
            this.project = project;
        }

        @Override
        public SimpleColoredText getPresentableText() {
            Library library;
            if (this.orderEntry != null && (library = this.orderEntry.getLibrary()) != null) {
                if (((LibraryEx)library).isDisposed()) {
                    Pair moduleAndBcName = DependenciesConfigurable.this.getModuleAndBcName();
                    LOG.error("Module library '" + library.getName() + "' is disposed, used in BC: " + (String)moduleAndBcName.second + " of module " + (String)moduleAndBcName.first);
                    return new SimpleColoredText("<unknown>", SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
                boolean hasInvalidRoots = !((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty();
                String text = OrderEntryAppearanceService.getInstance().forLibrary(this.project, library, hasInvalidRoots).getText();
                return new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            return new SimpleColoredText("<unknown>", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }

        @Override
        public boolean isLinkageEditable() {
            return !this.isANE();
        }

        @Override
        public boolean isANE() {
            VirtualFile[] files;
            Library library = this.orderEntry == null ? null : this.orderEntry.getLibrary();
            for (VirtualFile file : files = library == null ? VirtualFile.EMPTY_ARRAY : library.getFiles(OrderRootType.CLASSES)) {
                if (!"ane".equalsIgnoreCase(file.getExtension())) continue;
                return true;
            }
            return false;
        }

        @Override
        public LinkageType getLinkageType() {
            return this.dependencyType.getLinkageType();
        }

        @Override
        public void setLinkageType(LinkageType linkageType) {
            this.dependencyType.setLinkageType(linkageType);
        }

        @Override
        public void onDoubleClick() {
            if (this.canEdit()) {
                DependenciesConfigurable.this.editLibrary(this);
            }
        }

        @Override
        public ModifiableDependencyEntry apply(ModifiableDependencies dependencies) {
            ModifiableModuleLibraryEntry entry = DependenciesConfigurable.this.myConfigEditor.createModuleLibraryEntry(dependencies, this.libraryId);
            entry.getDependencyType().copyFrom(this.dependencyType);
            return entry;
        }

        @Override
        public boolean isModified(DependencyEntry entry) {
            if (!(entry instanceof ModuleLibraryEntry)) {
                return true;
            }
            ModuleLibraryEntry libraryEntry = (ModuleLibraryEntry)entry;
            if (!libraryEntry.getLibraryId().equals(this.libraryId)) {
                return true;
            }
            return !this.dependencyType.isEqual(entry.getDependencyType());
        }

        @Override
        public boolean canEdit() {
            return this.orderEntry != null;
        }

        @Override
        public Location.TableEntry getLocation() {
            return Location.TableEntry.forModuleLibrary(this.libraryId);
        }
    }

    private class BCItem
    extends MyTableItem {
        public final ModifiableDependencyType dependencyType;
        public final FlexBCConfigurable configurable;
        public final String moduleName;
        public final String bcName;

        public BCItem(@NotNull String moduleName, String bcName) {
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$BCItem", "<init>"));
            }
            if (bcName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bcName", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$BCItem", "<init>"));
            }
            this.dependencyType = Factory.createDependencyTypeInstance();
            this.moduleName = moduleName;
            this.bcName = bcName;
            this.configurable = null;
        }

        public BCItem(FlexBCConfigurable configurable) {
            if (configurable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurable", "com/intellij/lang/javascript/flex/projectStructure/ui/DependenciesConfigurable$BCItem", "<init>"));
            }
            this.dependencyType = Factory.createDependencyTypeInstance();
            this.moduleName = null;
            this.bcName = null;
            this.configurable = configurable;
            if (configurable.getOutputType() != OutputType.Library) {
                this.dependencyType.setLinkageType(LinkageType.LoadInRuntime);
            }
        }

        @Override
        public SimpleColoredText getPresentableText() {
            if (this.configurable != null) {
                return BCUtils.renderBuildConfiguration(this.configurable.getEditableObject(), this.configurable.getModuleName());
            }
            return BCUtils.renderMissingBuildConfiguration(this.bcName, this.moduleName);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.configurable != null ? this.configurable.getIcon() : MISSING_BC_ICON;
        }

        @Override
        public boolean showLinkage() {
            return this.configurable != null;
        }

        @Override
        public boolean isLinkageEditable() {
            return this.configurable != null && this.configurable.getOutputType() == OutputType.Library;
        }

        @Override
        public LinkageType getLinkageType() {
            return this.dependencyType.getLinkageType();
        }

        @Override
        public void setLinkageType(LinkageType linkageType) {
            this.dependencyType.setLinkageType(linkageType);
        }

        @Override
        public void onDoubleClick() {
            if (this.configurable != null) {
                Project project = this.configurable.getModule().getProject();
                ProjectStructureConfigurable.getInstance((Project)project).navigateTo(FlexProjectStructureUtil.createPlace(this.configurable, null), true);
            }
        }

        @Override
        public ModifiableDependencyEntry apply(ModifiableDependencies dependencies) {
            ModifiableBuildConfigurationEntry entry = this.configurable != null ? DependenciesConfigurable.this.myConfigEditor.createBcEntry(dependencies, this.configurable.getEditableObject(), this.configurable.getDisplayName()) : DependenciesConfigurable.this.myConfigEditor.createBcEntry(dependencies, this.moduleName, this.bcName);
            entry.getDependencyType().copyFrom(this.dependencyType);
            return entry;
        }

        @Override
        public boolean isModified(DependencyEntry entry) {
            if (!(entry instanceof BuildConfigurationEntry)) {
                return true;
            }
            BuildConfigurationEntry bcEntry = (BuildConfigurationEntry)entry;
            if (this.configurable != null) {
                if (this.configurable.getModule() != bcEntry.findModule()) {
                    return true;
                }
                if (!this.configurable.getDisplayName().equals(bcEntry.getBcName())) {
                    return true;
                }
            } else {
                if (!this.moduleName.equals(bcEntry.getModuleName())) {
                    return true;
                }
                if (!this.bcName.equals(bcEntry.getBcName())) {
                    return true;
                }
            }
            return !this.dependencyType.isEqual(entry.getDependencyType());
        }

        @Override
        public boolean canEdit() {
            return false;
        }

        @Override
        public Location.TableEntry getLocation() {
            return this.configurable != null ? Location.TableEntry.forBc(this.configurable) : Location.TableEntry.forBc(this.moduleName, this.bcName);
        }
    }

    private static abstract class MyTableItem {
        private MyTableItem() {
        }

        @Nullable
        public Icon getIcon() {
            return PlatformIcons.LIBRARY_ICON;
        }

        public boolean showLinkage() {
            return true;
        }

        public abstract boolean isLinkageEditable();

        public boolean isANE() {
            return false;
        }

        public abstract LinkageType getLinkageType();

        public abstract void setLinkageType(LinkageType var1);

        public void onDoubleClick() {
        }

        @Nullable
        public ModifiableDependencyEntry apply(ModifiableDependencies dependencies) {
            return null;
        }

        public boolean isModified(DependencyEntry entry) {
            return false;
        }

        public boolean canEdit() {
            return false;
        }

        public abstract Location.TableEntry getLocation();

        public abstract SimpleColoredText getPresentableText();
    }

    public static abstract class Location {
        public final String errorId;
        public static final Location SDK = new Location("sdk"){};

        protected Location(String id) {
            this.errorId = id;
        }

        public static class TableEntry
        extends Location {
            private final String locationString;
            public static final TableEntry SDK_ENTRY = new TableEntry("sdk_entry");

            private TableEntry(String locationString) {
                super(locationString);
                this.locationString = locationString;
            }

            public static TableEntry forSdkRoot(String url) {
                return new TableEntry("sdkroot\t" + url);
            }

            public static TableEntry forSharedLibrary(String libraryLevel, String libraryName) {
                return new TableEntry("sharedlib\t" + libraryLevel + "\t" + libraryName);
            }

            public static TableEntry forSharedLibrary(Library liveLibrary) {
                return new TableEntry("sharedlib\t" + liveLibrary.getTable().getTableLevel() + "\t" + liveLibrary.getName());
            }

            public static TableEntry forModuleLibrary(String libraryId) {
                return new TableEntry("modulelib\t" + libraryId);
            }

            public static TableEntry forBc(FlexBCConfigurable configurable) {
                return new TableEntry("bc\t" + configurable.getModuleName() + "\t" + configurable.getDisplayName());
            }

            public static TableEntry forBc(String moduleName, String bcName) {
                return new TableEntry("bc\t" + moduleName + "\t" + bcName);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TableEntry that = (TableEntry)o;
                return this.locationString.equals(that.locationString);
            }

            public int hashCode() {
                return this.locationString.hashCode();
            }
        }
    }
}

