/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.SharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.ui.ChooseBuildConfigurationDialog;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.util.Condition;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class FlexProjectStructureValidator
extends ProjectStructureValidator {
    protected boolean checkElement(ProjectStructureElement element, ProjectStructureProblemsHolder problemsHolder) {
        Module module;
        if (element instanceof ModuleProjectStructureElement && ModuleType.get((Module)(module = ((ModuleProjectStructureElement)element).getModule())) == FlexModuleType.getInstance()) {
            FlexProjectStructureValidator.checkModuleElement((ModuleProjectStructureElement)element, problemsHolder);
            return true;
        }
        return false;
    }

    private static void checkModuleElement(ModuleProjectStructureElement e, ProjectStructureProblemsHolder problemsHolder) {
        e.checkModulesNames(problemsHolder);
    }

    @Nullable
    protected List<ProjectStructureElementUsage> getUsagesIn(ProjectStructureElement element) {
        Module module;
        if (element instanceof ModuleProjectStructureElement && ModuleType.get((Module)(module = ((ModuleProjectStructureElement)element).getModule())) == FlexModuleType.getInstance()) {
            return Collections.emptyList();
        }
        return null;
    }

    protected boolean addLibraryToDependencies(Library library, Project project, boolean allowEmptySelection) {
        if (((LibraryEx)library).getKind() != FlexLibraryType.FLEX_LIBRARY) {
            return false;
        }
        ChooseBuildConfigurationDialog d = ChooseBuildConfigurationDialog.createForApplicableBCs(FlexBundle.message("choose.bc.dialog.title", new Object[0]), FlexBundle.message("choose.bc.dialog.label", library.getName()), project, allowEmptySelection, (Condition<FlexBCConfigurable>)((Condition)configurable -> {
            for (DependencyEntry entry : configurable.getEditableObject().getDependencies().getEntries()) {
                if (!(entry instanceof SharedLibraryEntry) || !((SharedLibraryEntry)entry).getLibraryName().equals(library.getName()) || !((SharedLibraryEntry)entry).getLibraryLevel().equals(library.getTable().getTableLevel())) continue;
                return false;
            }
            return true;
        }));
        if (d == null) {
            return true;
        }
        if (!d.showAndGet()) {
            return true;
        }
        for (FlexBCConfigurable c : d.getSelectedConfigurables()) {
            c.addSharedLibrary(library);
        }
        return true;
    }
}

