/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.run;

import com.intellij.execution.ExecutionBundle;
import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.build.FlexCompilerConfigFileUtil;
import com.intellij.lang.javascript.flex.build.InfoFromConfigFile;
import com.intellij.lang.javascript.flex.projectStructure.model.AirPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.AndroidPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.IosPackagingOptions;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.lang.javascript.flex.run.BCCombo;
import com.intellij.lang.javascript.flex.run.FlashRunConfiguration;
import com.intellij.lang.javascript.flex.run.FlashRunnerParameters;
import com.intellij.lang.javascript.flex.run.FlexLauncherDialog;
import com.intellij.lang.javascript.flex.run.LauncherParameters;
import com.intellij.lang.javascript.flex.sdk.FlexSdkComboBoxWithBrowseButton;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.ui.JSReferenceEditor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashRunConfigurationForm
extends SettingsEditor<FlashRunConfiguration> {
    private static final String LATEST_SELECTED_IOS_SIMULATOR_SDK_PATH_KEY = "LatestSelectedIosSimulatorSdk";
    public static final String SPRITE_CLASS_NAME = "flash.display.Sprite";
    public static final String MODULE_BASE_CLASS_NAME = "mx.modules.ModuleBase";
    private JPanel myMainPanel;
    private BCCombo myBCCombo;
    private JCheckBox myOverrideMainClassCheckBox;
    private Condition<JSClass> myMainClassFilter;
    private JSReferenceEditor myMainClassComponent;
    private JLabel myOutputFileNameLabel;
    private JTextField myOutputFileNameTextField;
    private JPanel myLaunchPanel;
    private JRadioButton myBCOutputRadioButton;
    private JLabel myBCOutputLabel;
    private JRadioButton myUrlOrFileRadioButton;
    private TextFieldWithBrowseButton myUrlOrFileTextWithBrowse;
    private JPanel myWebOptionsPanel;
    private JLabel myLauncherParametersLabel;
    private TextFieldWithBrowseButton myLauncherParametersTextWithBrowse;
    private JLabel mySdkForDebuggingLabel;
    private FlexSdkComboBoxWithBrowseButton mySdkForDebuggingCombo;
    private JCheckBox myRunTrustedCheckBox;
    private JPanel myDesktopOptionsPanel;
    private RawCommandLineEditor myAdlOptionsEditor;
    private RawCommandLineEditor myAirProgramParametersEditor;
    private JPanel myMobileRunPanel;
    private JRadioButton myOnEmulatorRadioButton;
    private JRadioButton myOnAndroidDeviceRadioButton;
    private JRadioButton myOnIOSSimulatorRadioButton;
    private TextFieldWithBrowseButton myIOSSimulatorSdkTextWithBrowse;
    private JRadioButton myOnIOSDeviceRadioButton;
    private JCheckBox myFastPackagingCheckBox;
    private JComboBox myEmulatorCombo;
    private JPanel myEmulatorScreenSizePanel;
    private JTextField myScreenWidth;
    private JTextField myScreenHeight;
    private JTextField myFullScreenWidth;
    private JTextField myFullScreenHeight;
    private JTextField myScreenDpi;
    private JPanel myMobileOptionsPanel;
    private JPanel myDebugTransportPanel;
    private JLabel myDebugOverLabel;
    private JRadioButton myDebugOverNetworkRadioButton;
    private JRadioButton myDebugOverUSBRadioButton;
    private JTextField myUsbDebugPortTextField;
    private JBLabel myEmulatorAdlOptionsLabel;
    private RawCommandLineEditor myEmulatorAdlOptionsEditor;
    private JLabel myAppDescriptorForEmulatorLabel;
    private JComboBox myAppDescriptorForEmulatorCombo;
    private final Project myProject;
    private LauncherParameters myLauncherParameters;
    private boolean myResetting = false;

    public FlashRunConfigurationForm(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.initBCCombo();
        this.initMainClassRelatedControls();
        this.initRadioButtons();
        this.initLaunchWithTextWithBrowse();
        this.initMobileControls();
        this.mySdkForDebuggingLabel.setLabelFor(this.mySdkForDebuggingCombo.getChildComponent());
        this.myEmulatorAdlOptionsLabel.setLabelFor((Component)this.myEmulatorAdlOptionsEditor.getTextField());
    }

    private void initBCCombo() {
        this.myBCCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashRunConfigurationForm.this.updateMainClassField();
                FlashRunConfigurationForm.this.myAppDescriptorForEmulatorCombo.repaint();
                FlexBuildConfiguration bc = FlashRunConfigurationForm.this.myBCCombo.getBC();
                FlashRunConfigurationForm.this.mySdkForDebuggingCombo.setBCSdk(bc == null ? null : bc.getSdk());
                FlashRunConfigurationForm.this.updateControls();
            }
        });
    }

    private void updateMainClassField() {
        Module module = this.myBCCombo.getModule();
        if (module != null) {
            this.myMainClassComponent.setScope(module.getModuleScope(true));
            this.myMainClassFilter = BCUtils.getMainClassFilter(module, this.myBCCombo.getBC(), false, true, true);
            this.myMainClassComponent.setChooserBlockingMessage(null);
        } else {
            this.myMainClassComponent.setScope(GlobalSearchScope.EMPTY_SCOPE);
            this.myMainClassFilter = Conditions.alwaysFalse();
            this.myMainClassComponent.setChooserBlockingMessage("Build configuration not selected");
        }
    }

    private void initMainClassRelatedControls() {
        this.myOverrideMainClassCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FlashRunConfigurationForm.this.myOverrideMainClassCheckBox.isSelected()) {
                    FlashRunConfigurationForm.updateOutputFileName(FlashRunConfigurationForm.this.myOutputFileNameTextField, false);
                }
                FlashRunConfigurationForm.this.updateControls();
                if (FlashRunConfigurationForm.this.myMainClassComponent.isEnabled()) {
                    IdeFocusManager.getInstance((Project)FlashRunConfigurationForm.this.myProject).requestFocus((Component)FlashRunConfigurationForm.this.myMainClassComponent.getChildComponent(), true);
                }
            }
        });
        this.myMainClassComponent.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                String shortName = StringUtil.getShortName((String)FlashRunConfigurationForm.this.myMainClassComponent.getText().trim());
                if (!shortName.isEmpty()) {
                    FlashRunConfigurationForm.this.myOutputFileNameTextField.setText(shortName + ".swf");
                }
            }
        });
        this.myOutputFileNameTextField.getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(javax.swing.event.DocumentEvent e) {
                FlexBuildConfiguration bc = FlashRunConfigurationForm.this.myBCCombo.getBC();
                if (bc != null && bc.getTargetPlatform() == TargetPlatform.Web) {
                    FlashRunConfigurationForm.this.updateBCOutputLabel(bc);
                }
            }
        });
    }

    private void initRadioButtons() {
        this.myBCOutputRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashRunConfigurationForm.this.updateControls();
            }
        });
        this.myUrlOrFileRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashRunConfigurationForm.this.updateControls();
                if (FlashRunConfigurationForm.this.myUrlOrFileTextWithBrowse.isEnabled()) {
                    IdeFocusManager.getInstance((Project)FlashRunConfigurationForm.this.myProject).requestFocus((Component)FlashRunConfigurationForm.this.myUrlOrFileTextWithBrowse.getTextField(), true);
                }
            }
        });
        this.myUrlOrFileTextWithBrowse.addBrowseFolderListener(null, null, this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
    }

    private void initLaunchWithTextWithBrowse() {
        this.myLauncherParametersTextWithBrowse.getButton().setMnemonic(this.myLauncherParametersLabel.getDisplayedMnemonic());
        this.myLauncherParametersTextWithBrowse.getTextField().setEditable(false);
        this.myLauncherParametersTextWithBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlexLauncherDialog dialog = new FlexLauncherDialog(FlashRunConfigurationForm.this.myProject, FlashRunConfigurationForm.this.myLauncherParameters);
                if (dialog.showAndGet()) {
                    FlashRunConfigurationForm.this.myLauncherParameters = dialog.getLauncherParameters();
                    FlashRunConfigurationForm.this.updateControls();
                }
            }
        });
    }

    private void initMobileControls() {
        this.initEmulatorRelatedControls();
        if (!SystemInfo.isMac) {
            this.myOnIOSSimulatorRadioButton.setEnabled(false);
            this.myOnIOSSimulatorRadioButton.setText(FlexBundle.message("ios.simulator.on.mac.only.button.text", new Object[0]));
            this.myIOSSimulatorSdkTextWithBrowse.setVisible(false);
        }
        this.myIOSSimulatorSdkTextWithBrowse.addBrowseFolderListener(null, null, this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        ActionListener debugTransportListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashRunConfigurationForm.this.updateDebugTransportRelatedControls();
            }
        };
        this.myDebugOverNetworkRadioButton.addActionListener(debugTransportListener);
        this.myDebugOverUSBRadioButton.addActionListener(debugTransportListener);
        FlashRunConfigurationForm.initAppDescriptorForEmulatorCombo(this.myAppDescriptorForEmulatorCombo, (NullableComputable<FlexBuildConfiguration>)((NullableComputable)() -> this.myBCCombo.getBC()));
    }

    public static void initAppDescriptorForEmulatorCombo(JComboBox appDescriptorForEmulatorCombo, final NullableComputable<FlexBuildConfiguration> bcComputable) {
        appDescriptorForEmulatorCombo.setModel(new DefaultComboBoxModel<FlashRunnerParameters.AppDescriptorForEmulator>(FlashRunnerParameters.AppDescriptorForEmulator.values()));
        appDescriptorForEmulatorCombo.setRenderer(new ListCellRendererWrapper<FlashRunnerParameters.AppDescriptorForEmulator>(){

            public void customize(JList list, FlashRunnerParameters.AppDescriptorForEmulator value, int index, boolean selected, boolean hasFocus) {
                FlexBuildConfiguration bc = (FlexBuildConfiguration)bcComputable.compute();
                switch (value) {
                    case Android: {
                        this.setText(FlashRunConfigurationForm.getDescriptorForEmulatorText("Android", bc == null ? null : bc.getAndroidPackagingOptions()));
                        break;
                    }
                    case IOS: {
                        this.setText(FlashRunConfigurationForm.getDescriptorForEmulatorText("iOS", bc == null ? null : bc.getIosPackagingOptions()));
                    }
                }
            }
        });
    }

    private static String getDescriptorForEmulatorText(String mobilePlatform, @Nullable AirPackagingOptions packagingOptions) {
        String prefix = "as set for " + mobilePlatform;
        if (packagingOptions == null) {
            return prefix;
        }
        if (packagingOptions instanceof AndroidPackagingOptions && !((AndroidPackagingOptions)packagingOptions).isEnabled() || packagingOptions instanceof IosPackagingOptions && !((IosPackagingOptions)packagingOptions).isEnabled()) {
            return prefix + ": <" + mobilePlatform + " support is not enabled>";
        }
        if (packagingOptions.isUseGeneratedDescriptor()) {
            return prefix + ": generated";
        }
        String descriptorPath = packagingOptions.getCustomDescriptorPath();
        if (descriptorPath.isEmpty()) {
            return prefix + ": <custom descriptor is not set>";
        }
        return prefix + ": " + PathUtil.getFileName((String)descriptorPath);
    }

    private void initEmulatorRelatedControls() {
        this.myEmulatorCombo.setModel(new DefaultComboBoxModel<Object>(FlashRunnerParameters.Emulator.ALL_EMULATORS.toArray()));
        this.myEmulatorCombo.setRenderer(new ListCellRendererWrapper<FlashRunnerParameters.Emulator>(){

            public void customize(JList list, FlashRunnerParameters.Emulator value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.name);
            }
        });
        this.myEmulatorCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashRunConfigurationForm.this.updateEmulatorRelatedControls();
            }
        });
        ActionListener targetDeviceListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlashRunConfigurationForm.this.updateControls();
                if (FlashRunConfigurationForm.this.myOnEmulatorRadioButton.isSelected()) {
                    IdeFocusManager.getInstance((Project)FlashRunConfigurationForm.this.myProject).requestFocus((Component)FlashRunConfigurationForm.this.myEmulatorCombo, true);
                }
                if (FlashRunConfigurationForm.this.myOnIOSSimulatorRadioButton.isSelected()) {
                    IdeFocusManager.getInstance((Project)FlashRunConfigurationForm.this.myProject).requestFocus((Component)FlashRunConfigurationForm.this.myIOSSimulatorSdkTextWithBrowse.getTextField(), true);
                }
            }
        };
        this.myOnEmulatorRadioButton.addActionListener(targetDeviceListener);
        this.myOnAndroidDeviceRadioButton.addActionListener(targetDeviceListener);
        this.myOnIOSSimulatorRadioButton.addActionListener(targetDeviceListener);
        this.myOnIOSDeviceRadioButton.addActionListener(targetDeviceListener);
        int preferredWidth = new JLabel((String)"999999").getPreferredSize().width;
        this.myScreenWidth.setPreferredSize(new Dimension(preferredWidth, this.myScreenWidth.getPreferredSize().height));
        this.myScreenHeight.setPreferredSize(new Dimension(preferredWidth, this.myScreenHeight.getPreferredSize().height));
        this.myFullScreenWidth.setPreferredSize(new Dimension(preferredWidth, this.myFullScreenWidth.getPreferredSize().height));
        this.myFullScreenHeight.setPreferredSize(new Dimension(preferredWidth, this.myFullScreenHeight.getPreferredSize().height));
        this.myScreenDpi.setPreferredSize(new Dimension(preferredWidth, this.myScreenDpi.getPreferredSize().height));
    }

    private void updateControls() {
        FlexBuildConfiguration bc = this.myBCCombo.getBC();
        Module module = this.myBCCombo.getModule();
        boolean overrideMainClass = this.myOverrideMainClassCheckBox.isSelected();
        this.myMainClassComponent.setEnabled(overrideMainClass);
        this.myOutputFileNameLabel.setEnabled(overrideMainClass);
        this.myOutputFileNameTextField.setEnabled(overrideMainClass);
        if (!overrideMainClass && bc != null && module != null) {
            InfoFromConfigFile info = FlexCompilerConfigFileUtil.getInfoFromConfigFile(bc.getCompilerOptions().getAdditionalConfigFilePath());
            this.myMainClassComponent.setText(StringUtil.notNullize((String)info.getMainClass(module), (String)bc.getMainClass()));
            this.myOutputFileNameTextField.setText(StringUtil.notNullize((String)info.getOutputFileName(), (String)bc.getOutputFileName()));
        }
        boolean web = bc != null && bc.getTargetPlatform() == TargetPlatform.Web;
        boolean desktop = bc != null && bc.getTargetPlatform() == TargetPlatform.Desktop;
        boolean mobile = bc != null && bc.getTargetPlatform() == TargetPlatform.Mobile;
        this.myLaunchPanel.setVisible(web);
        this.myWebOptionsPanel.setVisible(web);
        this.myDesktopOptionsPanel.setVisible(desktop);
        this.myMobileRunPanel.setVisible(mobile);
        this.myMobileOptionsPanel.setVisible(mobile);
        if (web) {
            this.updateBCOutputLabel(bc);
            this.myUrlOrFileTextWithBrowse.setEnabled(this.myUrlOrFileRadioButton.isSelected());
            this.myLauncherParametersTextWithBrowse.getTextField().setText(this.myLauncherParameters.getPresentableText());
            this.myRunTrustedCheckBox.setEnabled(!this.myUrlOrFileRadioButton.isSelected());
        }
        if (mobile) {
            boolean runOnEmulator = this.myOnEmulatorRadioButton.isSelected();
            boolean app = bc.getOutputType() == OutputType.Application;
            this.myEmulatorCombo.setEnabled(runOnEmulator);
            UIUtil.setEnabled((Component)this.myEmulatorScreenSizePanel, (boolean)runOnEmulator, (boolean)true);
            this.myFastPackagingCheckBox.setEnabled(this.myOnIOSDeviceRadioButton.isSelected());
            this.myEmulatorAdlOptionsLabel.setEnabled(runOnEmulator);
            this.myEmulatorAdlOptionsEditor.setEnabled(runOnEmulator);
            this.myAppDescriptorForEmulatorLabel.setEnabled(app && runOnEmulator);
            this.myAppDescriptorForEmulatorCombo.setEnabled(app && runOnEmulator);
            if (runOnEmulator) {
                this.updateEmulatorRelatedControls();
            }
            this.myIOSSimulatorSdkTextWithBrowse.setEnabled(this.myOnIOSSimulatorRadioButton.isSelected());
            if (this.myIOSSimulatorSdkTextWithBrowse.isEnabled() && this.myIOSSimulatorSdkTextWithBrowse.getText().isEmpty() && SystemInfo.isMac) {
                String latestSelected = PropertiesComponent.getInstance().getValue(LATEST_SELECTED_IOS_SIMULATOR_SDK_PATH_KEY);
                this.myIOSSimulatorSdkTextWithBrowse.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)latestSelected, (String)FlashRunConfigurationForm.guessIosSimulatorSdkPath())));
            }
            this.updateDebugTransportRelatedControls();
        }
    }

    private void updateBCOutputLabel(FlexBuildConfiguration bc) {
        if (bc.getOutputType() == OutputType.Application || this.myOverrideMainClassCheckBox.isSelected()) {
            String outputFileName;
            String string = outputFileName = this.myOverrideMainClassCheckBox.isSelected() ? this.myOutputFileNameTextField.getText().trim() : PathUtil.getFileName((String)bc.getActualOutputFilePath());
            if (!outputFileName.isEmpty() && bc.isUseHtmlWrapper()) {
                outputFileName = outputFileName + " via HTML wrapper";
            }
            this.myBCOutputLabel.setText(outputFileName);
        } else {
            this.myBCOutputLabel.setText("");
        }
    }

    private void updateEmulatorRelatedControls() {
        FlashRunnerParameters.Emulator emulator = (FlashRunnerParameters.Emulator)((Object)this.myEmulatorCombo.getSelectedItem());
        if (emulator.adlAlias == null) {
            this.myScreenWidth.setEditable(true);
            this.myScreenHeight.setEditable(true);
            this.myFullScreenWidth.setEditable(true);
            this.myFullScreenHeight.setEditable(true);
            if (!this.myResetting && !this.myScreenDpi.isEditable()) {
                this.myScreenDpi.setText("");
            }
            this.myScreenDpi.setEditable(true);
        } else {
            this.myScreenWidth.setEditable(false);
            this.myScreenHeight.setEditable(false);
            this.myFullScreenWidth.setEditable(false);
            this.myFullScreenHeight.setEditable(false);
            this.myScreenDpi.setEditable(false);
            this.myScreenWidth.setText(String.valueOf(emulator.screenWidth));
            this.myScreenHeight.setText(String.valueOf(emulator.screenHeight));
            this.myFullScreenWidth.setText(String.valueOf(emulator.fullScreenWidth));
            this.myFullScreenHeight.setText(String.valueOf(emulator.fullScreenHeight));
            this.myScreenDpi.setText(emulator.screenDPI > 0 ? String.valueOf(emulator.screenDPI) : "");
        }
    }

    private void updateDebugTransportRelatedControls() {
        boolean onDevice = this.myOnAndroidDeviceRadioButton.isSelected() || this.myOnIOSDeviceRadioButton.isSelected();
        this.myDebugOverLabel.setEnabled(onDevice);
        UIUtil.setEnabled((Component)this.myDebugTransportPanel, (boolean)onDevice, (boolean)true);
        if (onDevice) {
            this.myUsbDebugPortTextField.setEnabled(this.myDebugOverUSBRadioButton.isSelected());
        }
    }

    private void createUIComponents() {
        this.myBCCombo = new BCCombo(this.myProject);
        this.myMainClassFilter = Conditions.alwaysFalse();
        this.myMainClassComponent = JSReferenceEditor.forClassName((String)"", (Project)this.myProject, null, (GlobalSearchScope)GlobalSearchScope.EMPTY_SCOPE, null, (Condition)Conditions.alwaysTrue(), (String)ExecutionBundle.message((String)"choose.main.class.dialog.title", (Object[])new Object[0]));
        this.mySdkForDebuggingCombo = new FlexSdkComboBoxWithBrowseButton(FlexSdkComboBoxWithBrowseButton.FLEX_OR_FLEXMOJOS_SDK);
        this.mySdkForDebuggingCombo.showBCSdk(true);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/run/FlashRunConfigurationForm", "createEditor"));
        }
        return jPanel;
    }

    protected void resetEditorFrom(@NotNull FlashRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/flex/run/FlashRunConfigurationForm", "resetEditorFrom"));
        }
        this.myResetting = true;
        try {
            this.doResetEditorFrom(configuration);
        }
        finally {
            this.myResetting = false;
        }
    }

    private void doResetEditorFrom(FlashRunConfiguration configuration) {
        FlashRunnerParameters params = configuration.getRunnerParameters();
        this.myLauncherParameters = params.getLauncherParameters().clone();
        this.myBCCombo.resetFrom(params);
        this.myOverrideMainClassCheckBox.setSelected(params.isOverrideMainClass());
        if (params.isOverrideMainClass()) {
            this.myMainClassComponent.setText(params.getOverriddenMainClass());
            this.myOutputFileNameTextField.setText(params.getOverriddenOutputFileName());
        }
        this.myBCOutputRadioButton.setSelected(!params.isLaunchUrl());
        this.myUrlOrFileRadioButton.setSelected(params.isLaunchUrl());
        String url = params.getUrl();
        boolean windowsLocalFile = SystemInfo.isWindows && url.length() >= 2 && Character.isLetter(url.charAt(0)) && ':' == url.charAt(1);
        this.myUrlOrFileTextWithBrowse.setText(windowsLocalFile ? FileUtil.toSystemDependentName((String)url) : url);
        this.myRunTrustedCheckBox.setSelected(params.isRunTrusted());
        this.myAdlOptionsEditor.setText(params.getAdlOptions());
        this.myAirProgramParametersEditor.setText(params.getAirProgramParameters());
        this.myOnEmulatorRadioButton.setSelected(params.getMobileRunTarget() == FlashRunnerParameters.AirMobileRunTarget.Emulator);
        this.myEmulatorCombo.setSelectedItem((Object)params.getEmulator());
        if (params.getEmulator().adlAlias == null) {
            this.myScreenWidth.setText(String.valueOf(params.getScreenWidth()));
            this.myScreenHeight.setText(String.valueOf(params.getScreenHeight()));
            this.myFullScreenWidth.setText(String.valueOf(params.getFullScreenWidth()));
            this.myFullScreenHeight.setText(String.valueOf(params.getFullScreenHeight()));
            this.myScreenDpi.setText(params.getScreenDpi() > 0 ? String.valueOf(params.getScreenDpi()) : "");
        }
        this.myOnAndroidDeviceRadioButton.setSelected(params.getMobileRunTarget() == FlashRunnerParameters.AirMobileRunTarget.AndroidDevice);
        this.myOnIOSSimulatorRadioButton.setSelected(params.getMobileRunTarget() == FlashRunnerParameters.AirMobileRunTarget.iOSSimulator);
        this.myIOSSimulatorSdkTextWithBrowse.setText(FileUtil.toSystemDependentName((String)params.getIOSSimulatorSdkPath()));
        this.myOnIOSDeviceRadioButton.setSelected(params.getMobileRunTarget() == FlashRunnerParameters.AirMobileRunTarget.iOSDevice);
        this.myFastPackagingCheckBox.setSelected(params.isFastPackaging());
        this.myDebugOverNetworkRadioButton.setSelected(params.getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.Network);
        this.myDebugOverUSBRadioButton.setSelected(params.getDebugTransport() == FlashRunnerParameters.AirMobileDebugTransport.USB);
        this.myUsbDebugPortTextField.setText(String.valueOf(params.getUsbDebugPort()));
        this.myEmulatorAdlOptionsEditor.setText(params.getEmulatorAdlOptions());
        this.myAppDescriptorForEmulatorCombo.setSelectedItem((Object)params.getAppDescriptorForEmulator());
        FlexBuildConfiguration bc = this.myBCCombo.getBC();
        this.mySdkForDebuggingCombo.setBCSdk(bc == null ? null : bc.getSdk());
        this.mySdkForDebuggingCombo.setSelectedSdkRaw(params.getDebuggerSdkRaw());
        this.updateControls();
    }

    private static String guessIosSimulatorSdkPath() {
        File appDir = new File("/Applications");
        if (appDir.isDirectory()) {
            File sdksDir;
            File[] simulatorSdkDirs;
            String relPath = "/Contents/Developer/Platforms/iPhoneSimulator.platform/Developer/SDKs";
            File[] xCodeDirs = appDir.listFiles(file -> {
                String name = file.getName().toLowerCase();
                return file.isDirectory() && name.startsWith("xcode") && name.endsWith(".app") && new File(file.getPath() + "/Contents/Developer/Platforms/iPhoneSimulator.platform/Developer/SDKs").isDirectory();
            });
            if (xCodeDirs.length > 0 && (simulatorSdkDirs = (sdksDir = new File(xCodeDirs[0] + "/Contents/Developer/Platforms/iPhoneSimulator.platform/Developer/SDKs")).listFiles(file -> {
                String filename = file.getName().toLowerCase();
                return file.isDirectory() && filename.startsWith("iphonesimulator") && filename.endsWith(".sdk");
            })).length > 0) {
                return simulatorSdkDirs[0].getPath();
            }
        }
        return "";
    }

    protected void applyEditorTo(@NotNull FlashRunConfiguration configuration) throws ConfigurationException {
        String path;
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/lang/javascript/flex/run/FlashRunConfigurationForm", "applyEditorTo"));
        }
        FlashRunnerParameters params = configuration.getRunnerParameters();
        this.myBCCombo.applyTo(params);
        boolean overrideMainClass = this.myOverrideMainClassCheckBox.isSelected();
        params.setOverrideMainClass(overrideMainClass);
        params.setOverriddenMainClass(overrideMainClass ? this.myMainClassComponent.getText().trim() : "");
        params.setOverriddenOutputFileName(overrideMainClass ? this.myOutputFileNameTextField.getText().trim() : "");
        params.setLaunchUrl(this.myUrlOrFileRadioButton.isSelected());
        String url = this.myUrlOrFileTextWithBrowse.getText().trim();
        boolean windowsLocalFile = SystemInfo.isWindows && url.length() >= 2 && Character.isLetter(url.charAt(0)) && ':' == url.charAt(1);
        params.setUrl(windowsLocalFile ? FileUtil.toSystemIndependentName((String)url) : url);
        params.setLauncherParameters(this.myLauncherParameters);
        params.setRunTrusted(this.myRunTrustedCheckBox.isSelected());
        params.setAdlOptions(this.myAdlOptionsEditor.getText().trim());
        params.setAirProgramParameters(this.myAirProgramParametersEditor.getText().trim());
        FlashRunnerParameters.AirMobileRunTarget mobileRunTarget = this.myOnEmulatorRadioButton.isSelected() ? FlashRunnerParameters.AirMobileRunTarget.Emulator : (this.myOnAndroidDeviceRadioButton.isSelected() ? FlashRunnerParameters.AirMobileRunTarget.AndroidDevice : (this.myOnIOSSimulatorRadioButton.isSelected() ? FlashRunnerParameters.AirMobileRunTarget.iOSSimulator : FlashRunnerParameters.AirMobileRunTarget.iOSDevice));
        params.setMobileRunTarget(mobileRunTarget);
        FlashRunnerParameters.Emulator emulator = (FlashRunnerParameters.Emulator)((Object)this.myEmulatorCombo.getSelectedItem());
        params.setEmulator(emulator);
        if (emulator.adlAlias == null) {
            try {
                params.setScreenWidth(Integer.parseInt(this.myScreenWidth.getText().trim()));
                params.setScreenHeight(Integer.parseInt(this.myScreenHeight.getText().trim()));
                params.setFullScreenWidth(Integer.parseInt(this.myFullScreenWidth.getText().trim()));
                params.setFullScreenHeight(Integer.parseInt(this.myFullScreenHeight.getText().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                params.setScreenDpi(Integer.parseInt(this.myScreenDpi.getText().trim()));
            }
            catch (NumberFormatException e) {
                params.setScreenDpi(0);
            }
        }
        FlexBuildConfiguration bc = this.myBCCombo.getBC();
        if (SystemInfo.isMac && bc != null && bc.getTargetPlatform() == TargetPlatform.Mobile && this.myOnIOSSimulatorRadioButton.isSelected() && !(path = FileUtil.toSystemIndependentName((String)this.myIOSSimulatorSdkTextWithBrowse.getText().trim())).isEmpty()) {
            PropertiesComponent.getInstance().setValue(LATEST_SELECTED_IOS_SIMULATOR_SDK_PATH_KEY, path);
        }
        params.setIOSSimulatorSdkPath(FileUtil.toSystemIndependentName((String)this.myIOSSimulatorSdkTextWithBrowse.getText().trim()));
        params.setFastPackaging(this.myFastPackagingCheckBox.isSelected());
        params.setDebugTransport(this.myDebugOverNetworkRadioButton.isSelected() ? FlashRunnerParameters.AirMobileDebugTransport.Network : FlashRunnerParameters.AirMobileDebugTransport.USB);
        try {
            int port = Integer.parseInt(this.myUsbDebugPortTextField.getText().trim());
            if (port > 0 && port < 65535) {
                params.setUsbDebugPort(port);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        params.setEmulatorAdlOptions(this.myEmulatorAdlOptionsEditor.getText().trim());
        params.setAppDescriptorForEmulator((FlashRunnerParameters.AppDescriptorForEmulator)((Object)this.myAppDescriptorForEmulatorCombo.getSelectedItem()));
        params.setDebuggerSdkRaw(this.mySdkForDebuggingCombo.getSelectedSdkRaw());
    }

    protected void disposeEditor() {
        this.myBCCombo.dispose();
    }

    public static void updateOutputFileName(JTextField textField, boolean isLib) {
        String outputFileName = textField.getText();
        String lowercase = outputFileName.toLowerCase();
        String withoutExtension = lowercase.endsWith(".swf") || lowercase.endsWith(".swc") ? outputFileName.substring(0, outputFileName.length() - ".sw_".length()) : outputFileName;
        textField.setText(withoutExtension + (isLib ? ".swc" : ".swf"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JLabel jLabel2;
        RawCommandLineEditor rawCommandLineEditor;
        JBLabel jBLabel;
        JLabel jLabel3;
        JTextField jTextField2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JRadioButton jRadioButton3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton4;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JTextField jTextField7;
        JPanel jPanel3;
        JComboBox jComboBox2;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JPanel jPanel4;
        RawCommandLineEditor rawCommandLineEditor2;
        RawCommandLineEditor rawCommandLineEditor3;
        JPanel jPanel5;
        JLabel jLabel4;
        JCheckBox jCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel5;
        JPanel jPanel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JRadioButton jRadioButton7;
        JLabel jLabel6;
        JRadioButton jRadioButton8;
        JPanel jPanel7;
        JPanel jPanel8;
        this.createUIComponents();
        this.myMainPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myLaunchPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel7, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"What to Launch", (int)0, (int)0, null, null));
        this.myBCOutputRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setText("Build output:");
        jRadioButton8.setMnemonic('O');
        jRadioButton8.setDisplayedMnemonicIndex(6);
        jPanel7.add((Component)jRadioButton8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBCOutputLabel = jLabel6 = new JLabel();
        jLabel6.setText("SomeFile.swf via HTML wrapper");
        jPanel7.add((Component)jLabel6, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUrlOrFileRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("URL or local file:");
        jRadioButton7.setMnemonic('R');
        jRadioButton7.setDisplayedMnemonicIndex(1);
        jPanel7.add((Component)jRadioButton7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUrlOrFileTextWithBrowse = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel7.add((Component)textFieldWithBrowseButton3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myWebOptionsPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel6, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Options", (int)0, (int)0, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLauncherParametersLabel = jLabel5 = new JLabel();
        jLabel5.setText("Launch with:");
        jLabel5.setDisplayedMnemonic('W');
        jLabel5.setDisplayedMnemonicIndex(7);
        jPanel9.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLauncherParametersTextWithBrowse = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myRunTrustedCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("com/intellij/lang/javascript/flex/FlexBundle").getString("run.trusted"));
        jPanel6.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySdkForDebuggingLabel = jLabel4 = new JLabel();
        jLabel4.setText("Use debugger from SDK:");
        jLabel4.setDisplayedMnemonic('D');
        jLabel4.setDisplayedMnemonicIndex(4);
        jPanel10.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        FlexSdkComboBoxWithBrowseButton flexSdkComboBoxWithBrowseButton = this.mySdkForDebuggingCombo;
        jPanel6.add((Component)((Object)flexSdkComboBoxWithBrowseButton), new GridConstraints(1, 1, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myDesktopOptionsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel5, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Options", (int)0, (int)0, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("AIR Debug Launcher options:");
        jLabel7.setDisplayedMnemonic('O');
        jLabel7.setDisplayedMnemonicIndex(19);
        jPanel5.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Program parameters:");
        jLabel8.setDisplayedMnemonic('P');
        jLabel8.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel8, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAirProgramParametersEditor = rawCommandLineEditor3 = new RawCommandLineEditor();
        rawCommandLineEditor3.setDialogCaption("Program Parameters");
        jPanel5.add((Component)rawCommandLineEditor3, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myAdlOptionsEditor = rawCommandLineEditor2 = new RawCommandLineEditor();
        rawCommandLineEditor2.setDialogCaption("ADL Options");
        jPanel5.add((Component)rawCommandLineEditor2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myMobileRunPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel4, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Run on", (int)0, (int)0, null, null));
        this.myOnEmulatorRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Emulator:");
        jRadioButton6.setMnemonic('E');
        jRadioButton6.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jRadioButton6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOnAndroidDeviceRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Android device");
        jRadioButton5.setMnemonic('V');
        jRadioButton5.setDisplayedMnemonicIndex(10);
        ((Component)jRadioButton5).setEnabled(true);
        jPanel4.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.myEmulatorCombo = jComboBox2 = new JComboBox();
        jPanel4.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myEmulatorScreenSizePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 10, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Screen:");
        jLabel9.setDisplayedMnemonic('R');
        jLabel9.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScreenWidth = jTextField7 = new JTextField();
        jPanel3.add((Component)jTextField7, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setHorizontalTextPosition(0);
        jLabel10.setText("x");
        jLabel10.setHorizontalAlignment(0);
        jPanel3.add((Component)jLabel10, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myScreenHeight = jTextField6 = new JTextField();
        jPanel3.add((Component)jTextField6, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("  Full:");
        jLabel11.setDisplayedMnemonic('F');
        jLabel11.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jLabel11, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFullScreenWidth = jTextField5 = new JTextField();
        jPanel3.add((Component)jTextField5, new GridConstraints(0, 5, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel12 = new JLabel();
        jLabel12.setHorizontalTextPosition(0);
        jLabel12.setText("x");
        jLabel12.setHorizontalAlignment(0);
        jPanel3.add((Component)jLabel12, new GridConstraints(0, 6, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myFullScreenHeight = jTextField4 = new JTextField();
        jPanel3.add((Component)jTextField4, new GridConstraints(0, 7, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("ppi:");
        jLabel13.setDisplayedMnemonic('P');
        jLabel13.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel13, new GridConstraints(0, 8, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScreenDpi = jTextField3 = new JTextField();
        jPanel3.add((Component)jTextField3, new GridConstraints(0, 9, 1, 1, 8, 1, 6, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel11, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myOnIOSSimulatorRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("iOS Simulator, SDK:");
        jRadioButton4.setMnemonic('L');
        jRadioButton4.setDisplayedMnemonicIndex(8);
        jPanel11.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIOSSimulatorSdkTextWithBrowse = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel11.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel12, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myOnIOSDeviceRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("iOS device");
        jRadioButton3.setMnemonic('D');
        jRadioButton3.setDisplayedMnemonicIndex(4);
        jPanel12.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFastPackagingCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("fast packaging");
        jCheckBox2.setMnemonic('K');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel12.add((Component)jCheckBox2, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel12.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMobileOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel2, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Options", (int)0, (int)0, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel13, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDebugTransportPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel13.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDebugOverNetworkRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Network");
        jRadioButton2.setMnemonic('W');
        jRadioButton2.setDisplayedMnemonicIndex(3);
        jPanel.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDebugOverUSBRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("USB, port:");
        jRadioButton.setMnemonic('U');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUsbDebugPortTextField = jTextField2 = new JTextField();
        jTextField2.setColumns(4);
        jPanel.add((Component)jTextField2, new GridConstraints(0, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel13.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDebugOverLabel = jLabel3 = new JLabel();
        jLabel3.setText("Debug on device over: ");
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEmulatorAdlOptionsLabel = jBLabel = new JBLabel();
        jBLabel.setText("ADL options (emulator):");
        jBLabel.setDisplayedMnemonic('L');
        jBLabel.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEmulatorAdlOptionsEditor = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("ADL Options");
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAppDescriptorForEmulatorLabel = jLabel2 = new JLabel();
        jLabel2.setText("App descriptor (emulator):");
        jLabel2.setDisplayedMnemonic('O');
        jLabel2.setDisplayedMnemonicIndex(12);
        jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAppDescriptorForEmulatorCombo = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myOverrideMainClassCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Override main class:");
        jCheckBox.setMnemonic('M');
        jCheckBox.setDisplayedMnemonicIndex(9);
        jPanel8.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOutputFileNameLabel = jLabel = new JLabel();
        jLabel.setText("Output file name:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(2);
        jPanel8.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myOutputFileNameTextField = jTextField = new JTextField();
        jPanel8.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        JSReferenceEditor jSReferenceEditor = this.myMainClassComponent;
        jSReferenceEditor.setText("");
        jPanel8.add((Component)jSReferenceEditor, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(150, -1), null));
        JLabel jLabel14 = new JLabel();
        Font font = jLabel14.getFont();
        if (font != null) {
            jLabel14.setFont(new Font(font.getName(), 1, font.getSize()));
        }
        jLabel14.setText("Build configuration:");
        jLabel14.setDisplayedMnemonic('C');
        jLabel14.setDisplayedMnemonicIndex(6);
        jPanel8.add((Component)jLabel14, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        BCCombo bCCombo = this.myBCCombo;
        jPanel8.add((Component)bCCombo, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        jLabel5.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel7.setLabelFor((Component)rawCommandLineEditor2);
        jLabel8.setLabelFor((Component)rawCommandLineEditor3);
        jLabel9.setLabelFor(jTextField7);
        jLabel11.setLabelFor(jTextField5);
        jLabel13.setLabelFor(jTextField3);
        jLabel2.setLabelFor(jComboBox);
        jLabel.setLabelFor(jTextField);
        jLabel14.setLabelFor(bCCombo);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton8);
        buttonGroup.add(jRadioButton7);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton6);
        buttonGroup.add(jRadioButton5);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

