/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.completion.ActionScriptSmartCompletionContributor;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.fixes.ChangeSignatureFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ActionScriptTypeChecker
extends JSTypeChecker<Annotation> {
    private final JSProblemReporter<Annotation> myReporter;

    public ActionScriptTypeChecker(JSProblemReporter<Annotation> reporter) {
        this.myReporter = reporter;
    }

    public Annotation registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        return (Annotation)this.myReporter.registerProblem(place, message, highlightType, this.getValidateTypesInspectionId(), fixes);
    }

    public void checkExpressionIsAssignableToVariable(JSVariable p, final JSExpression expr, PsiFile containingFile, @PropertyKey(resourceBundle="messages.JavaScriptBundle") String problemKey, boolean allowChangeVariableTypeFix) {
        JSFunction fun;
        JSParameterList parameterList;
        PsiElement _fun;
        JSType type = p.getType();
        Pair annotationAndExprType = this.checkExpressionIsAssignableToType(expr, type, problemKey, (PsiElement)(allowChangeVariableTypeFix ? p : null));
        if (annotationAndExprType != null && p.getParent() instanceof JSParameterList && expr.getParent() instanceof JSArgumentList && !"void".equals(annotationAndExprType.second)) {
            JSFunction method = (JSFunction)p.getParent().getParent();
            JSFunction topMethod = (JSFunction)JSInheritanceUtil.findTopMethods((JSFunction)method).iterator().next();
            ((Annotation)annotationAndExprType.first).registerFix((IntentionAction)new ChangeSignatureFix(topMethod, (JSArgumentList)expr.getParent()));
        }
        if (annotationAndExprType == null && type != null && "Function".equals(type.getResolvedTypeText()) && p instanceof JSParameter && ActionScriptTypeChecker.isAddEventListenerMethod((JSFunction)p.getParent().getParent()) && (expr instanceof JSReferenceExpression && (_fun = ((JSReferenceExpression)expr).resolve()) instanceof JSFunction || expr instanceof JSFunctionExpression && (_fun = expr) != null) && (parameterList = (fun = (JSFunction)_fun).getParameterList()) != null) {
            boolean invalidArgs;
            JSParameter[] parameters = parameterList.getParameterVariables();
            boolean bl = invalidArgs = parameters.length == 0;
            if (!invalidArgs && parameters.length > 1) {
                for (int i = parameters.length - 1; i > 0; --i) {
                    if (parameters[i].isRest() || parameters[i].getInitializer() != null) continue;
                    invalidArgs = true;
                    break;
                }
            }
            Computable.NotNullCachedComputable<JSParameterList> expectedParameterListForEventListener = new Computable.NotNullCachedComputable<JSParameterList>(){

                @NotNull
                protected JSParameterList internalCompute() {
                    JSClass jsClass = ActionScriptTypeChecker.calcNontrivialExpectedEventType(expr);
                    ASTNode treeFromText = JSChangeUtil.createJSTreeFromText((Project)expr.getProject(), (String)("function f(event:" + (jsClass != null ? jsClass.getQualifiedName() : "flash.events.Event") + ") {}"), (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
                    JSParameterList jSParameterList = ((JSFunction)treeFromText.getPsi()).getParameterList();
                    if (jSParameterList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptTypeChecker$1", "internalCompute"));
                    }
                    return jSParameterList;
                }
            };
            if (invalidArgs) {
                Object expr_ = expr instanceof JSFunctionExpression ? ((JSFunctionExpression)expr).getParameterList() : expr;
                this.registerProblem((PsiElement)expr_, JSBundle.message((String)"javascript.callback.signature.mismatch", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ChangeSignatureFix(fun, (Computable.NotNullCachedComputable)expectedParameterListForEventListener)});
            } else {
                String actualParameterType;
                JSClass expectedEventClass = ActionScriptTypeChecker.calcNontrivialExpectedEventType(expr);
                JSType paramType = parameters[0].getType();
                String string = actualParameterType = paramType != null ? paramType.getResolvedTypeText() : null;
                if (expectedEventClass == null) {
                    if (!JSResolveUtil.isAssignableType((String)"flash.events.Event", (String)actualParameterType, (PsiElement)parameters[0]) && !JSResolveUtil.isAssignableType((String)"starling.events.Event", (String)actualParameterType, (PsiElement)parameters[0])) {
                        this.registerProblem((PsiElement)(expr instanceof JSFunctionExpression ? parameters[0] : expr), JSBundle.message((String)"javascript.callback.signature.mismatch", (Object[])new Object[0]), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ChangeSignatureFix(fun, (Computable.NotNullCachedComputable)expectedParameterListForEventListener)});
                    }
                } else if (!JSResolveUtil.isAssignableType((String)actualParameterType, (String)expectedEventClass.getQualifiedName(), (PsiElement)parameters[0])) {
                    this.registerProblem((PsiElement)(expr instanceof JSFunctionExpression ? parameters[0] : expr), JSBundle.message((String)"javascript.callback.signature.mismatch.event.class", (Object[])new Object[]{expectedEventClass.getQualifiedName()}), ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ChangeSignatureFix(fun, (Computable.NotNullCachedComputable)expectedParameterListForEventListener)});
                }
            }
        }
    }

    private static boolean isAddEventListenerMethod(JSFunction method) {
        JSClass declaringClass;
        PsiElement methodParent;
        return "addEventListener".equals(method.getName()) && (methodParent = method.getParent()) instanceof JSClass && (JSResolveUtil.isAssignableType((String)"flash.events.IEventDispatcher", (String)(declaringClass = (JSClass)methodParent).getQualifiedName(), (PsiElement)method) || ActionScriptClassResolver.isParentClass(declaringClass, "starling.events.EventDispatcher", false));
    }

    @Nullable
    private static JSClass calcNontrivialExpectedEventType(JSExpression expr) {
        PsiElement resolve;
        PsiElement classFromNamespace;
        Map<String, String> eventsMap;
        String qName;
        JSClass clazz;
        JSExpression methodExpression;
        JSExpression prevExpr = (JSExpression)PsiTreeUtil.findChildOfAnyType((PsiElement)expr.getParent(), (Class[])new Class[]{JSExpression.class});
        String type = null;
        JSExpression adHocQualifierExpr = null;
        if (prevExpr instanceof JSReferenceExpression && prevExpr != expr) {
            String initializerText;
            PsiElement constantRef = ((JSReferenceExpression)prevExpr).resolve();
            if (constantRef instanceof JSVariable && (initializerText = ((JSVariable)constantRef).getLiteralOrReferenceInitializerText()) != null && (StringUtil.startsWith((CharSequence)initializerText, (CharSequence)"'") || StringUtil.startsWith((CharSequence)initializerText, (CharSequence)"\""))) {
                type = StringUtil.stripQuotesAroundValue((String)initializerText);
            }
            adHocQualifierExpr = ((JSReferenceExpression)prevExpr).getQualifier();
        } else if (prevExpr instanceof JSLiteralExpression) {
            type = StringUtil.stripQuotesAroundValue((String)prevExpr.getText());
        }
        if (type != null && (methodExpression = ((JSCallExpression)expr.getParent().getParent()).getMethodExpression()) instanceof JSReferenceExpression && (clazz = ActionScriptSmartCompletionContributor.findClassOfQualifier((JSReferenceExpression)methodExpression)) != null && (qName = (eventsMap = ActionScriptSmartCompletionContributor.getEventsMap(clazz)).get(type)) != null && (classFromNamespace = JSClassResolver.findClassFromNamespace((String)qName, (PsiElement)clazz)) instanceof JSClass) {
            return (JSClass)classFromNamespace;
        }
        if (adHocQualifierExpr instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)adHocQualifierExpr).resolve()) instanceof JSClass) {
            clazz = (JSClass)resolve;
            if (ActionScriptClassResolver.isParentClass((JSClass)resolve, "flash.events.Event", false) || ActionScriptClassResolver.isParentClass((JSClass)resolve, "starling.events.Event", false)) {
                return clazz;
            }
        }
        return null;
    }
}

