/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlElementDescriptor;
import org.jetbrains.annotations.NotNull;

public class CreateEventMetadataByMxmlAttributeFix
extends BaseCreateFix {
    private final String myEventName;

    public CreateEventMetadataByMxmlAttributeFix(String eventName) {
        this.myEventName = eventName;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)"declare.event.0", (Object[])new Object[]{this.myEventName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateEventMetadataByMxmlAttributeFix", "getName"));
        }
        return string;
    }

    protected void applyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        int offset;
        PsiElement type;
        assert (psiElement instanceof XmlAttribute);
        XmlTag tag = (XmlTag)psiElement.getParent();
        XmlElementDescriptor descriptor = tag.getDescriptor();
        PsiElement psiElement2 = type = descriptor == null ? null : descriptor.getDeclaration();
        if (type == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(type)) {
            return;
        }
        file = type.getContainingFile();
        editor = CreateEventMetadataByMxmlAttributeFix.getEditor((Project)project, (PsiFile)file);
        if (editor == null) {
            return;
        }
        boolean addingToMxml = type instanceof XmlFile;
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToReformat(true);
        if (addingToMxml) {
            template.addTextSegment("\n");
        }
        template.addTextSegment("[Event(name=\"" + this.myEventName + "\", type=\"");
        template.addVariable((Expression)new BaseCreateFix.MyExpression("flash.events.Event"), true);
        template.addTextSegment("\")]");
        if (!addingToMxml) {
            template.addTextSegment("\n");
        }
        if (addingToMxml) {
            XmlTag metadataTag = (XmlTag)WriteAction.compute(() -> CreateEventMetadataByMxmlAttributeFix.createOrGetMetadataTag((XmlFile)type));
            offset = metadataTag.getValue().getTextRange().getStartOffset();
        } else {
            offset = type.getTextRange().getStartOffset();
        }
        CreateEventMetadataByMxmlAttributeFix.navigate((Project)project, (Editor)editor, (int)offset, (VirtualFile)file.getVirtualFile());
        templateManager.startTemplate(editor, template);
    }

    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        assert (false);
    }

    private static XmlTag createOrGetMetadataTag(XmlFile xmlFile) throws IncorrectOperationException {
        assert (JavaScriptSupportLoader.isFlexMxmFile((PsiFile)xmlFile)) : xmlFile;
        XmlTag rootTag = XmlBackedJSClassFactory.getRootTag((XmlFile)xmlFile);
        XmlTag[] metadataTags = MxmlJSClass.findLanguageSubTags(rootTag, "Metadata");
        return metadataTags.length > 0 ? metadataTags[0] : CreateEventMetadataByMxmlAttributeFix.createMetadataTag(rootTag);
    }

    private static XmlTag createMetadataTag(XmlTag rootTag) {
        String prefix = rootTag.getPrefixByNamespace("http://ns.adobe.com/mxml/2009");
        if (prefix == null) {
            prefix = rootTag.getPrefixByNamespace("http://www.adobe.com/2006/mxml");
        }
        if (prefix == null) {
            prefix = "";
        }
        String qName = prefix + (prefix.isEmpty() ? "" : ":") + "Metadata";
        XmlTag newTag = XmlElementFactory.getInstance((Project)rootTag.getProject()).createTagFromText((CharSequence)("<" + qName + ">\n</" + qName + ">"));
        XmlTag[] subTags = rootTag.getSubTags();
        return subTags.length > 0 && MxmlJSClass.isFxLibraryTag(subTags[0]) ? (XmlTag)rootTag.addAfter((PsiElement)newTag, (PsiElement)subTags[0]) : rootTag.addSubTag(newTag, true);
    }
}

