/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateClassIntentionWithCallback;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateMxmlFileIntentionBase
implements CreateClassIntentionWithCallback {
    protected PsiElement myElement;
    protected String myPackageName;
    protected String myClassName;
    private boolean myIdentifierIsValid;
    private Consumer<String> myCreatedClassFqnConsumer;

    public CreateMxmlFileIntentionBase(String classFqn, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase", "<init>"));
        }
        this.myElement = element;
        this.myClassName = StringUtil.getShortName((String)classFqn);
        this.myIdentifierIsValid = ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(JavaScriptSupportLoader.JAVASCRIPT.getLanguage())).isIdentifier(this.myClassName, null);
        this.myPackageName = StringUtil.getPackageName((String)classFqn);
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"create.file.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase", "isAvailable"));
        }
        return this.myIdentifierIsValid && this.myElement.isValid();
    }

    public void setCreatedClassFqnConsumer(Consumer<String> consumer) {
        this.myCreatedClassFqnConsumer = consumer;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase", "applyFix"));
        }
        this.invoke(project, null, this.myElement.getContainingFile());
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase", "invoke"));
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return;
        }
        Pair<String, PsiDirectory> fileTextAndDir = this.getFileTextAndDir(module);
        if (fileTextAndDir.first == null || fileTextAndDir.second == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase", "lambda$invoke$0"));
            }
            try {
                String fileName = this.myClassName + ".mxml";
                PsiFile newFile = ((PsiDirectory)fileTextAndDir.second).createFile(fileName);
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = psiDocumentManager.getDocument(newFile);
                document.setText((CharSequence)fileTextAndDir.first);
                psiDocumentManager.commitDocument(document);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)newFile);
                FileEditorManager.getInstance((Project)project).openFile(newFile.getVirtualFile(), true);
                if (this.myCreatedClassFqnConsumer != null) {
                    String packageName = ProjectRootManager.getInstance((Project)project).getFileIndex().getPackageNameByDirectory(((PsiDirectory)fileTextAndDir.second).getVirtualFile());
                    this.myCreatedClassFqnConsumer.consume((Object)(packageName + (packageName.isEmpty() ? "" : ".") + this.myClassName));
                }
            }
            catch (IncorrectOperationException e) {
                Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)this.getText());
            }
        });
    }

    protected Pair<String, PsiDirectory> getFileTextAndDir(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/validation/fixes/CreateMxmlFileIntentionBase", "getFileTextAndDir"));
        }
        PsiDirectory baseDir = this.myElement.getContainingFile().getParent();
        GlobalSearchScope scope = PlatformPackageUtil.adjustScope((PsiDirectory)baseDir, (GlobalSearchScope)GlobalSearchScope.moduleWithDependenciesScope((Module)module), (boolean)false, (boolean)true);
        PsiDirectory psiDirectory = JSRefactoringUtil.chooseOrCreateDirectoryForClass((Project)module.getProject(), (Module)module, (GlobalSearchScope)scope, (String)this.myPackageName, null, (PsiDirectory)baseDir, (ThreeState)ThreeState.UNSURE);
        return Pair.create((Object)this.getFileText(), (Object)psiDirectory);
    }

    protected String getFileText() {
        return "";
    }
}

