package com.intellij.javaee.context;

import com.intellij.facet.FacetTypeId;
import com.intellij.javaee.application.facet.JavaeeApplicationFacet;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.facet.JavaeeFacet;
import org.jetbrains.annotations.NotNull;

public class JavaeeAppFacetContextProvider implements FacetContextProvider {

  @Override
  public FacetTypeId<? extends JavaeeFacet> getFacetId() {
    return JavaeeApplicationFacet.ID;
  }

  @Override
  public String getDeploymentContext(@NotNull WebModuleContextProvider webModuleContextProvider,
                                     @NotNull DeploymentModel deploymentModel,
                                     @NotNull JavaeeFacet facet) {
    return webModuleContextProvider.getContext((JavaeeApplicationFacet)facet, null);
  }
}
