/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.applicationServer;

import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeePersistentDataEditor;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.appServerIntegration.WeblogicIntegration;
import com.intellij.javaee.weblogic.applicationServer.WeblogicPersistentData;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersion;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersionConfig;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicVersionList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class WeblogicApplicationServerPersistentDataEditor
extends JavaeePersistentDataEditor<WeblogicPersistentData> {
    private static final Logger LOG = Logger.getInstance(WeblogicApplicationServerPersistentDataEditor.class);
    private JComboBox myCbVersion;
    private boolean myInVersionDetect = false;

    public WeblogicApplicationServerPersistentDataEditor() {
        super((JavaeeIntegration)WeblogicIntegration.getInstance());
        this.getCustomPanelPlaceHolder().add(WeblogicApplicationServerPersistentDataEditor.createCustomPanel());
    }

    protected void resetEditorFrom(@NotNull WeblogicPersistentData settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javaee/weblogic/applicationServer/WeblogicApplicationServerPersistentDataEditor", "resetEditorFrom"));
        }
        super.resetEditorFrom((JavaeePersistentData)settings);
        this.myCbVersion.setSelectedItem(WeblogicVersionConfig.getChosenVersion(settings));
    }

    protected void applyEditorTo(@NotNull WeblogicPersistentData settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/javaee/weblogic/applicationServer/WeblogicApplicationServerPersistentDataEditor", "applyEditorTo"));
        }
        super.applyEditorTo((JavaeePersistentData)settings);
        settings.VERSION = StringUtil.notNullize((String)this.getVersion());
    }

    private static JPanel createCustomPanel() {
        JPanel customPanel = new JPanel(new GridBagLayout());
        customPanel.add((Component)new JLabel(WeblogicBundle.message("label.text.please.note.that.weblogic.versions.prior.to.9.0.are.not.supported", new Object[0])), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        return customPanel;
    }

    protected JavaeePersistentDataEditor.VersionContribution createVersionContribution() {
        return new JavaeePersistentDataEditor.VersionContribution(){

            public JComponent createVersionComponent() {
                WeblogicApplicationServerPersistentDataEditor.this.myCbVersion = new JComboBox();
                WeblogicApplicationServerPersistentDataEditor.this.myCbVersion.setPrototypeDisplayValue("##########################");
                WeblogicApplicationServerPersistentDataEditor.this.myCbVersion.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (WeblogicApplicationServerPersistentDataEditor.this.myInVersionDetect) {
                            return;
                        }
                        WeblogicVersion version = (WeblogicVersion)WeblogicApplicationServerPersistentDataEditor.this.myCbVersion.getSelectedItem();
                        WeblogicApplicationServerPersistentDataEditor.this.setVersion(version == null ? null : version.getName());
                    }
                });
                return WeblogicApplicationServerPersistentDataEditor.this.myCbVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String detectVersion() {
                WeblogicApplicationServerPersistentDataEditor.this.myInVersionDetect = true;
                try {
                    Object oldItem = WeblogicApplicationServerPersistentDataEditor.this.myCbVersion.getSelectedItem();
                    WeblogicApplicationServerPersistentDataEditor.this.myCbVersion.removeAllItems();
                    WeblogicVersion versionToSelect = null;
                    try {
                        WeblogicVersionList list = WeblogicVersionConfig.getVersionListSafe((JavaeePersistentData)WeblogicApplicationServerPersistentDataEditor.this.getSnapshot());
                        for (WeblogicVersion version : list.getVersions()) {
                            WeblogicApplicationServerPersistentDataEditor.this.myCbVersion.addItem(version);
                            if (versionToSelect != null && !version.equals(oldItem)) continue;
                            versionToSelect = version;
                        }
                        WeblogicApplicationServerPersistentDataEditor.this.myCbVersion.setSelectedItem(versionToSelect);
                    }
                    catch (ConfigurationException e) {
                        LOG.error((Throwable)e);
                    }
                    String string = versionToSelect == null ? null : versionToSelect.getName();
                    return string;
                }
                finally {
                    WeblogicApplicationServerPersistentDataEditor.this.myInVersionDetect = false;
                }
            }
        };
    }
}

