/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.ext.spock.SpockConstants;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class SpockUtils {
    public static final String SPEC_CLASS_NAME = "spock.lang.Specification";
    private static final LightCacheKey<Map<String, SpockVariableDescriptor>> KEY = LightCacheKey.create();

    private SpockUtils() {
    }

    public static Map<String, SpockVariableDescriptor> getVariableMap(@NotNull GrMethod method) {
        Map<String, SpockVariableDescriptor> cachedValue;
        GrMethod originalMethod;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/ext/spock/SpockUtils", "getVariableMap"));
        }
        PsiFile containingFile = method.getContainingFile();
        if (containingFile != containingFile.getOriginalFile()) {
            int methodOffset = method.getTextOffset();
            PsiElement originalPlace = containingFile.getOriginalFile().findElementAt(methodOffset);
            originalMethod = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)originalPlace, GrMethod.class);
            assert (originalMethod != null) : containingFile.getOriginalFile().getText().substring(Math.max(0, methodOffset - 50), Math.min(methodOffset + 50, containingFile.getOriginalFile().getText().length()));
        } else {
            originalMethod = method;
        }
        if ((cachedValue = KEY.getCachedValue(originalMethod)) == null) {
            cachedValue = SpockUtils.createVariableMap(originalMethod);
            cachedValue = KEY.putCachedValue(originalMethod, cachedValue);
        }
        return cachedValue;
    }

    public static Map<String, SpockVariableDescriptor> createVariableMap(GrMethod method) {
        GrOpenBlock block = method.getBlock();
        if (block == null) {
            return Collections.emptyMap();
        }
        GrStatement elementUnderLabel = null;
        PsiElement elementAfterLabel = null;
        block0: for (PsiElement e = block.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!(e instanceof GrLabeledStatement)) continue;
            GrLabeledStatement l = (GrLabeledStatement)e;
            elementAfterLabel = l.getNextSibling();
            while (true) {
                GrStatement statement = l.getStatement();
                if ("where".equals(l.getName())) {
                    elementUnderLabel = statement;
                    break block0;
                }
                if (!(statement instanceof GrLabeledStatement)) continue block0;
                l = (GrLabeledStatement)statement;
            }
        }
        if (elementUnderLabel == null) {
            return Collections.emptyMap();
        }
        HashMap<String, SpockVariableDescriptor> res = new HashMap<String, SpockVariableDescriptor>();
        GrStatement e = elementUnderLabel;
        while (e != null) {
            block17: {
                block15: {
                    GrExpression rightOperand;
                    GrExpression leftOperand;
                    block16: {
                        if (!(e instanceof GrBinaryExpression) || ((GrBinaryExpression)e).getOperationTokenType() != GroovyElementTypes.COMPOSITE_LSHIFT_SIGN) break block15;
                        GrBinaryExpression shift = (GrBinaryExpression)e;
                        leftOperand = shift.getLeftOperand();
                        rightOperand = shift.getRightOperand();
                        if (!(leftOperand instanceof GrReferenceExpression)) break block16;
                        String name = SpockUtils.getNameByReference(leftOperand);
                        if (name != null) {
                            SpockVariableDescriptor descriptor2 = new SpockVariableDescriptor(leftOperand, name);
                            descriptor2.addExpressionOfCollection(rightOperand);
                            res.put(name, descriptor2);
                        }
                        break block17;
                    }
                    if (!(leftOperand instanceof GrListOrMap)) break block17;
                    GrExpression[] variableDefinitions = ((GrListOrMap)leftOperand).getInitializers();
                    SpockVariableDescriptor[] variables = SpockUtils.createVariables(res, Arrays.asList(variableDefinitions));
                    if (!(rightOperand instanceof GrListOrMap)) break block17;
                    for (GrExpression expression : ((GrListOrMap)rightOperand).getInitializers()) {
                        if (expression instanceof GrListOrMap) {
                            SpockUtils.add(variables, Arrays.asList(((GrListOrMap)expression).getInitializers()));
                            continue;
                        }
                        for (SpockVariableDescriptor variable : variables) {
                            if (variable == null) continue;
                            variable.addExpressionOfCollection(expression);
                        }
                    }
                    break block17;
                }
                if (e instanceof GrAssignmentExpression) {
                    GrAssignmentExpression assExpr = (GrAssignmentExpression)e;
                    GrExpression lValue = assExpr.getLValue();
                    String name = SpockUtils.getNameByReference(lValue);
                    if (name != null) {
                        res.put(name, new SpockVariableDescriptor(lValue, name).addExpression(assExpr.getRValue()));
                    }
                } else if (SpockUtils.isOrStatement(e)) {
                    ArrayList<GrExpression> variableDefinitions = new ArrayList<GrExpression>();
                    SpockUtils.splitOr(variableDefinitions, (GrExpression)e);
                    SpockVariableDescriptor[] variables = SpockUtils.createVariables(res, variableDefinitions);
                    ArrayList<GrExpression> row = new ArrayList<GrExpression>();
                    PsiElement rowElement = SpockUtils.getNext(e, elementUnderLabel, elementAfterLabel);
                    while (SpockUtils.isOrStatement(rowElement)) {
                        row.clear();
                        SpockUtils.splitOr(row, (GrExpression)rowElement);
                        SpockUtils.add(variables, row);
                        rowElement = SpockUtils.getNext(rowElement, elementUnderLabel, elementAfterLabel);
                    }
                    e = rowElement;
                    continue;
                }
            }
            e = SpockUtils.getNext(e, elementUnderLabel, elementAfterLabel);
        }
        return res;
    }

    private static SpockVariableDescriptor[] createVariables(Map<String, SpockVariableDescriptor> map, List<GrExpression> variableDefinitions) {
        SpockVariableDescriptor[] variables = new SpockVariableDescriptor[variableDefinitions.size()];
        for (int i = 0; i < variableDefinitions.size(); ++i) {
            GrExpression expression = variableDefinitions.get(i);
            String name = SpockUtils.getNameByReference(expression);
            if (name == null) continue;
            SpockVariableDescriptor variableDescriptor = new SpockVariableDescriptor(expression, name);
            map.put(name, variableDescriptor);
            variables[i] = variableDescriptor;
        }
        return variables;
    }

    private static void add(SpockVariableDescriptor[] variables, List<GrExpression> expressions) {
        int end = Math.min(variables.length, expressions.size());
        for (int i = 0; i < end; ++i) {
            if (variables[i] == null) continue;
            variables[i].addExpression(expressions.get(i));
        }
    }

    private static boolean isOrStatement(PsiElement element) {
        if (element instanceof GrBinaryExpression) {
            IElementType type = ((GrBinaryExpression)element).getOperationTokenType();
            return type == GroovyTokenTypes.mBOR || type == GroovyTokenTypes.mLOR;
        }
        return false;
    }

    @Nullable
    private static PsiElement getNext(@NotNull PsiElement current, PsiElement elementUnderLabel, PsiElement elementAfterLabel) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "org/jetbrains/plugins/groovy/ext/spock/SpockUtils", "getNext"));
        }
        PsiElement e = current;
        while (PsiImplUtil.isLeafElementOfType((PsiElement)(e = e == elementUnderLabel ? elementAfterLabel : e.getNextSibling()), (TokenSet)TokenSets.WHITE_SPACES_OR_COMMENTS)) {
        }
        if (e instanceof GrLabeledStatement) {
            return null;
        }
        return e;
    }

    @Nullable
    public static String getNameByReference(@Nullable PsiElement expression) {
        if (!(expression instanceof GrReferenceExpression)) {
            return null;
        }
        PsiElement firstChild = expression.getFirstChild();
        if (firstChild != expression.getLastChild() || !PsiImplUtil.isLeafElementOfType((PsiElement)firstChild, (IElementType)GroovyTokenTypes.mIDENT)) {
            return null;
        }
        GrReferenceExpression ref = (GrReferenceExpression)expression;
        if (ref.isQualified()) {
            return null;
        }
        return ref.getReferenceName();
    }

    private static void splitOr(List<GrExpression> res, GrExpression element) {
        if (SpockUtils.isOrStatement(element)) {
            GrBinaryExpression be = (GrBinaryExpression)element;
            SpockUtils.splitOr(res, be.getLeftOperand());
            SpockUtils.splitOr(res, be.getRightOperand());
        } else {
            res.add(element);
        }
    }

    public static boolean isTestMethod(PsiElement element) {
        if (!(element instanceof GrMethod)) {
            return false;
        }
        GrMethod method = (GrMethod)element;
        PsiClass clazz = method.getContainingClass();
        if (!SpockUtils.isSpecification(clazz)) {
            return false;
        }
        if (SpockUtils.isFixtureMethod(method)) {
            return false;
        }
        return SpockUtils.isFeatureMethod(method);
    }

    public static boolean isSpecification(@Nullable PsiClass clazz) {
        return clazz instanceof GrTypeDefinition && InheritanceUtil.isInheritor((PsiClass)clazz, (String)SPEC_CLASS_NAME);
    }

    public static boolean isFixtureMethod(@NotNull GrMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/ext/spock/SpockUtils", "isFixtureMethod"));
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        return SpockConstants.FIXTURE_METHOD_NAMES.contains(method.getName());
    }

    public static boolean isFeatureMethod(@NotNull GrMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/ext/spock/SpockUtils", "isFeatureMethod"));
        }
        if (method.hasModifierProperty("static")) {
            return false;
        }
        GrOpenBlock block = method.getBlock();
        if (block == null) {
            return false;
        }
        for (GrStatement statement : block.getStatements()) {
            String label;
            if (!(statement instanceof GrLabeledStatement) || !SpockConstants.FEATURE_METHOD_LABELS.contains(label = ((GrLabeledStatement)statement).getName())) continue;
            return true;
        }
        return false;
    }
}

