/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumConstantInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrScriptField;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.CollectClassMembersUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrClassImplUtil {
    private static final Logger LOG = Logger.getInstance(GrClassImplUtil.class);
    private static final Condition<PsiMethod> CONSTRUCTOR_CONDITION = PsiMethod::isConstructor;

    private GrClassImplUtil() {
    }

    @NotNull
    public static GrMethod[] getCodeConstructors(@NotNull GrTypeDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getCodeConstructors"));
        }
        Object[] methods = definition.getCodeMethods();
        List result = ContainerUtil.filter((Object[])methods, CONSTRUCTOR_CONDITION);
        GrMethod[] grMethodArray = result.toArray(GrMethod.EMPTY_ARRAY);
        if (grMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getCodeConstructors"));
        }
        return grMethodArray;
    }

    @NotNull
    public static PsiMethod[] getConstructors(@NotNull GrTypeDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getConstructors"));
        }
        Object[] methods = definition.getMethods();
        List result = ContainerUtil.filter((Object[])methods, CONSTRUCTOR_CONDITION);
        PsiMethod[] psiMethodArray = result.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getConstructors"));
        }
        return psiMethodArray;
    }

    @Nullable
    public static PsiClass findInnerClassByName(GrTypeDefinition grType, String name, boolean checkBases) {
        if (!checkBases) {
            for (PsiClass inner : grType.getInnerClasses()) {
                if (!name.equals(inner.getName())) continue;
                return inner;
            }
            return null;
        }
        Map<String, CandidateInfo> innerClasses = CollectClassMembersUtil.getAllInnerClasses(grType, true);
        CandidateInfo info = innerClasses.get(name);
        return info == null ? null : (PsiClass)info.getElement();
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull GrTypeDefinition grType) {
        if (grType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grType", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getSuperClass"));
        }
        return GrClassImplUtil.getSuperClass(grType, grType.getExtendsListTypes());
    }

    @Nullable
    public static PsiClass getSuperClass(@NotNull GrTypeDefinition grType, @NotNull PsiClassType[] extendsListTypes) {
        if (grType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grType", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getSuperClass"));
        }
        if (extendsListTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extendsListTypes", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getSuperClass"));
        }
        if (extendsListTypes.length == 0) {
            return GrClassImplUtil.getBaseClass(grType);
        }
        PsiClass superClass = extendsListTypes[0].resolve();
        return superClass != null ? superClass : GrClassImplUtil.getBaseClass(grType);
    }

    @Nullable
    public static PsiClass getBaseClass(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Enum", grType.getResolveScope());
        }
        return JavaPsiFacade.getInstance((Project)grType.getProject()).findClass("java.lang.Object", grType.getResolveScope());
    }

    @NotNull
    public static PsiClassType[] getSuperTypes(GrTypeDefinition grType, boolean includeSynthetic) {
        Object[] extendsList = grType.getExtendsListTypes(includeSynthetic);
        if (extendsList.length == 0) {
            extendsList = new PsiClassType[]{GrClassImplUtil.createBaseClassType(grType)};
        }
        PsiClassType[] psiClassTypeArray = (PsiClassType[])ArrayUtil.mergeArrays((Object[])extendsList, (Object[])grType.getImplementsListTypes(includeSynthetic), (ArrayFactory)PsiClassType.ARRAY_FACTORY);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getSuperTypes"));
        }
        return psiClassTypeArray;
    }

    public static PsiClassType createBaseClassType(GrTypeDefinition grType) {
        if (grType.isEnum()) {
            return TypesUtil.createTypeByFQClassName("java.lang.Enum", grType);
        }
        return TypesUtil.getJavaLangObject(grType);
    }

    @NotNull
    public static PsiMethod[] getAllMethods(GrTypeDefinition grType) {
        PsiMethod[] psiMethodArray = (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)grType, () -> {
            ArrayList list = ContainerUtil.newArrayList();
            GrClassImplUtil.getAllMethodsInner(grType, list, (com.intellij.util.containers.hash.HashSet<PsiClass>)new com.intellij.util.containers.hash.HashSet());
            return CachedValueProvider.Result.create((Object)list.toArray(new PsiMethod[list.size()]), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, grType});
        });
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getAllMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<PsiMethod> getAllMethods(Collection<? extends PsiClass> classes) {
        ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>();
        com.intellij.util.containers.hash.HashSet visited = new com.intellij.util.containers.hash.HashSet();
        for (PsiClass psiClass : classes) {
            GrClassImplUtil.getAllMethodsInner(psiClass, allMethods, (com.intellij.util.containers.hash.HashSet<PsiClass>)visited);
        }
        ArrayList<PsiMethod> arrayList = allMethods;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getAllMethods"));
        }
        return arrayList;
    }

    private static void getAllMethodsInner(PsiClass clazz, List<PsiMethod> allMethods, com.intellij.util.containers.hash.HashSet<PsiClass> visited) {
        PsiClass[] supers;
        if (visited.contains((Object)clazz)) {
            return;
        }
        visited.add((Object)clazz);
        ContainerUtil.addAll(allMethods, (Object[])clazz.getMethods());
        for (PsiClass aSuper : supers = clazz.getSupers()) {
            GrClassImplUtil.getAllMethodsInner(aSuper, allMethods, visited);
        }
    }

    public static PsiClassType[] getReferenceListTypes(@Nullable GrReferenceList list) {
        if (list == null) {
            return PsiClassType.EMPTY_ARRAY;
        }
        return list.getReferencedTypes();
    }

    @NotNull
    public static PsiClass[] getInterfaces(GrTypeDefinition grType) {
        PsiClassType[] implementsListTypes = grType.getImplementsListTypes();
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(implementsListTypes.length);
        for (PsiClassType type : implementsListTypes) {
            PsiClass psiClass = type.resolve();
            if (psiClass == null) continue;
            result.add(psiClass);
        }
        PsiClass[] psiClassArray = result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getInterfaces"));
        }
        return psiClassArray;
    }

    @NotNull
    public static PsiClass[] getSupers(GrTypeDefinition grType, boolean includeSynthetic) {
        PsiClassType[] superTypes = grType.getSuperTypes(includeSynthetic);
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (PsiClassType superType : superTypes) {
            PsiClass superClass = superType.resolve();
            if (superClass == null) continue;
            result.add(superClass);
        }
        PsiClass[] psiClassArray = result.toArray(new PsiClass[result.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getSupers"));
        }
        return psiClassArray;
    }

    public static boolean processDeclarations(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        GrTypeDefinitionBody body;
        PsiElement possibleAnnotation;
        if (grType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grType", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processDeclarations"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processDeclarations"));
        }
        if (place instanceof GrCodeReferenceElement && (possibleAnnotation = PsiTreeUtil.skipParentsOfType((PsiElement)place, (Class[])new Class[]{GrCodeReferenceElement.class})) instanceof GrAnnotation) {
            return true;
        }
        for (PsiElement typeParameter : grType.getTypeParameters()) {
            if (ResolveUtil.processElement(processor, (PsiNamedElement)typeParameter, state)) continue;
            return false;
        }
        NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
        String name = nameHint == null ? null : nameHint.getName(state);
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)place.getProject());
        boolean processInstanceMethods = (ResolveUtil.shouldProcessMethods(classHint) || ResolveUtil.shouldProcessProperties(classHint)) && GrClassImplUtil.shouldProcessInstanceMembers(grType, lastParent);
        LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)place);
        if (ResolveUtil.shouldProcessProperties(classHint)) {
            Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType);
            if (name != null) {
                PsiField field;
                PsiField[] fieldInfo = fieldsMap.get(name);
                if (fieldInfo != null ? !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, (CandidateInfo)fieldInfo) : grType.isTrait() && lastParent != null && (field = GrClassImplUtil.findFieldByName(grType, name, false, true)) != null && field.hasModifierProperty("public") && !GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, new CandidateInfo((PsiElement)field, PsiSubstitutor.EMPTY))) {
                    return false;
                }
            } else {
                for (CandidateInfo info : fieldsMap.values()) {
                    if (GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, info)) continue;
                    return false;
                }
                if (grType.isTrait() && lastParent != null) {
                    for (PsiField field : CollectClassMembersUtil.getFields(grType, true)) {
                        if (!field.hasModifierProperty("public") || GrClassImplUtil.processField(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, new CandidateInfo((PsiElement)field, PsiSubstitutor.EMPTY))) continue;
                        return false;
                    }
                }
            }
        }
        if (ResolveUtil.shouldProcessMethods(classHint)) {
            boolean isPlaceGroovy;
            Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
            boolean bl = isPlaceGroovy = place.getLanguage() == GroovyLanguage.INSTANCE;
            if (name == null) {
                for (List<CandidateInfo> list : methodsMap.values()) {
                    for (CandidateInfo info : list) {
                        if (GrClassImplUtil.processMethod(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, isPlaceGroovy, info)) continue;
                        return false;
                    }
                }
            } else {
                List<CandidateInfo> byName = methodsMap.get(name);
                if (byName != null) {
                    for (CandidateInfo info : byName) {
                        if (GrClassImplUtil.processMethod(grType, processor, state, place, processInstanceMethods, substitutor, factory, level, isPlaceGroovy, info)) continue;
                        return false;
                    }
                }
            }
        }
        if ((body = grType.getBody()) != null && ResolveUtil.shouldProcessClasses(classHint)) {
            for (PsiClass innerClass : GrClassImplUtil.getInnerClassesForResolve(grType, lastParent, place)) {
                if (name != null && !name.equals(innerClass.getName()) || processor.execute((PsiElement)innerClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processField(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean processInstanceMethods, @NotNull PsiSubstitutor substitutor, @NotNull PsiElementFactory factory, @NotNull LanguageLevel level, CandidateInfo fieldInfo) {
        if (grType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grType", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processField"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processField"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processField"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processField"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processField"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processField"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processField"));
        }
        PsiField field = (PsiField)fieldInfo.getElement();
        if (!GrClassImplUtil.shouldProcessTraitMember(grType, (PsiMember)field, place)) {
            return true;
        }
        if (!GrClassImplUtil.processInstanceMember(processInstanceMethods, (PsiMember)field) || GrClassImplUtil.isSameDeclaration(place, (PsiElement)field)) {
            return true;
        }
        LOG.assertTrue(field.getContainingClass() != null);
        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)field.getContainingClass(), (PsiSubstitutor)fieldInfo.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElementFactory)factory, (LanguageLevel)level);
        return processor.execute((PsiElement)field, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor));
    }

    private static boolean processMethod(@NotNull GrTypeDefinition grType, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place, boolean processInstanceMethods, @NotNull PsiSubstitutor substitutor, @NotNull PsiElementFactory factory, @NotNull LanguageLevel level, boolean placeGroovy, @NotNull CandidateInfo info) {
        if (grType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grType", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processMethod"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processMethod"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processMethod"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processMethod"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processMethod"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processMethod"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processMethod"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processMethod"));
        }
        PsiMethod method = (PsiMethod)info.getElement();
        if (!GrClassImplUtil.shouldProcessTraitMember(grType, (PsiMember)method, place)) {
            return true;
        }
        if (!GrClassImplUtil.processInstanceMember(processInstanceMethods, (PsiMember)method) || GrClassImplUtil.isSameDeclaration(place, (PsiElement)method) || !GrClassImplUtil.isMethodVisible(placeGroovy, method)) {
            return true;
        }
        LOG.assertTrue(method.getContainingClass() != null);
        PsiSubstitutor finalSubstitutor = PsiClassImplUtil.obtainFinalSubstitutor((PsiClass)method.getContainingClass(), (PsiSubstitutor)info.getSubstitutor(), (PsiClass)grType, (PsiSubstitutor)substitutor, (PsiElementFactory)factory, (LanguageLevel)level);
        return processor.execute((PsiElement)method, state.put(PsiSubstitutor.KEY, (Object)finalSubstitutor));
    }

    private static boolean shouldProcessTraitMember(@NotNull GrTypeDefinition grType, @NotNull PsiMember element, @NotNull PsiElement place) {
        if (grType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grType", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "shouldProcessTraitMember"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "shouldProcessTraitMember"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "shouldProcessTraitMember"));
        }
        return !grType.isTrait() || !element.hasModifierProperty("static") || grType.equals(element.getContainingClass()) && PsiTreeUtil.isAncestor((PsiElement)grType, (PsiElement)place, (boolean)true);
    }

    private static boolean shouldProcessInstanceMembers(@NotNull GrTypeDefinition grType, @Nullable PsiElement lastParent) {
        GrModifierList modifierList;
        if (grType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grType", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "shouldProcessInstanceMembers"));
        }
        return lastParent == null || (modifierList = grType.getModifierList()) == null || modifierList.findAnnotation("groovy.lang.Category") == null;
    }

    private static boolean processInstanceMember(boolean shouldProcessInstance, @NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "processInstanceMember"));
        }
        if (shouldProcessInstance) {
            return true;
        }
        if (member instanceof GrReflectedMethod) {
            return ((GrReflectedMethod)member).getBaseMethod().hasModifierProperty("static");
        }
        return member.hasModifierProperty("static");
    }

    @NotNull
    private static List<PsiClass> getInnerClassesForResolve(@NotNull GrTypeDefinition grType, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (grType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grType", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getInnerClassesForResolve"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getInnerClassesForResolve"));
        }
        if (lastParent instanceof GrReferenceList || PsiTreeUtil.getParentOfType((PsiElement)place, GrReferenceList.class) != null) {
            List<PsiClass> list = Arrays.asList(grType.getCodeInnerClasses());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getInnerClassesForResolve"));
            }
            return list;
        }
        boolean includeSynthetic = !PsiTreeUtil.isContextAncestor((PsiElement)grType, (PsiElement)place, (boolean)true);
        Trinity key = Trinity.create((Object)grType, (Object)lastParent, (Object)place);
        List classes = (List)RecursionManager.doPreventingRecursion((Object)key, (boolean)false, () -> {
            if (grType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grType", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "lambda$getInnerClassesForResolve$1"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "lambda$getInnerClassesForResolve$1"));
            }
            ArrayList result = new ArrayList();
            for (CandidateInfo info : CollectClassMembersUtil.getAllInnerClasses(grType, includeSynthetic).values()) {
                PsiClass inner = (PsiClass)info.getElement();
                PsiClass containingClass = inner.getContainingClass();
                assert (containingClass != null);
                if (lastParent != null && containingClass.isInterface() && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)place, (boolean)false)) continue;
                ContainerUtil.addIfNotNull(result, (Object)inner);
            }
            return result;
        });
        if (classes == null) {
            List<PsiClass> list = Arrays.asList(grType.getCodeInnerClasses());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getInnerClassesForResolve"));
            }
            return list;
        }
        List list = classes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getInnerClassesForResolve"));
        }
        return list;
    }

    public static boolean isSameDeclaration(PsiElement place, PsiElement element) {
        if (element instanceof GrAccessorMethod) {
            element = ((GrAccessorMethod)element).getProperty();
        }
        if (!(element instanceof GrField)) {
            return false;
        }
        if (element instanceof GrScriptField) {
            element = ((GrScriptField)element).getOriginalVariable();
        }
        while (place != null) {
            if (place == element) {
                return true;
            }
            if ((place = place.getParent()) instanceof GrClosableBlock) {
                return false;
            }
            if (!(place instanceof GrEnumConstantInitializer)) continue;
            return false;
        }
        return false;
    }

    private static boolean isMethodVisible(boolean isPlaceGroovy, PsiMethod method) {
        return isPlaceGroovy || !(method instanceof GrGdkMethod);
    }

    @Nullable
    public static PsiMethod findMethodBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, false)) {
            MethodSignature signature = GrClassImplUtil.getSignatureForInheritor(method, grType);
            if (!patternSignature.equals(signature)) continue;
            return method;
        }
        return null;
    }

    private static PsiMethod[] findMethodsByName(GrTypeDefinition grType, String name, boolean checkBases, boolean includeSyntheticAccessors) {
        if (!checkBases) {
            ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
            for (PsiMethod method : CollectClassMembersUtil.getMethods(grType, includeSyntheticAccessors)) {
                if (!name.equals(method.getName())) continue;
                result.add(method);
            }
            return result.toArray(new PsiMethod[result.size()]);
        }
        Map<String, List<CandidateInfo>> methodsMap = CollectClassMembersUtil.getAllMethods(grType, includeSyntheticAccessors);
        return PsiImplUtil.mapToMethods(methodsMap.get(name));
    }

    @NotNull
    public static PsiMethod[] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, true);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "findMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findCodeMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsBySignature(grType, patternMethod, checkBases, false);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "findCodeMethodsBySignature"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static PsiMethod[] findMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsByName(grType, name, checkBases, true);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "findMethodsByName"));
        }
        return psiMethodArray;
    }

    private static PsiMethod[] findMethodsBySignature(GrTypeDefinition grType, PsiMethod patternMethod, boolean checkBases, boolean includeSynthetic) {
        ArrayList<PsiMethod> result = new ArrayList<PsiMethod>();
        MethodSignature patternSignature = patternMethod.getSignature(PsiSubstitutor.EMPTY);
        for (PsiMethod method : GrClassImplUtil.findMethodsByName(grType, patternMethod.getName(), checkBases, includeSynthetic)) {
            MethodSignature signature = GrClassImplUtil.getSignatureForInheritor(method, grType);
            if (!patternSignature.equals(signature)) continue;
            result.add(method);
        }
        return result.toArray(new PsiMethod[result.size()]);
    }

    @Nullable
    private static MethodSignature getSignatureForInheritor(@NotNull PsiMethod methodFromSuperClass, @NotNull GrTypeDefinition inheritor) {
        if (methodFromSuperClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodFromSuperClass", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getSignatureForInheritor"));
        }
        if (inheritor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getSignatureForInheritor"));
        }
        PsiClass clazz = methodFromSuperClass.getContainingClass();
        if (clazz == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)clazz, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return null;
        }
        return methodFromSuperClass.getSignature(superSubstitutor);
    }

    @NotNull
    public static PsiMethod[] findCodeMethodsByName(GrTypeDefinition grType, @NonNls String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = GrClassImplUtil.findMethodsByName(grType, name, checkBases, false);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "findCodeMethodsByName"));
        }
        return psiMethodArray;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(GrTypeDefinition grType, String name, boolean checkBases) {
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        if (!checkBases) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = grType.findMethodsByName(name, false)) {
                result.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)method, (Object)PsiSubstitutor.EMPTY));
            }
        } else {
            Map<String, List<CandidateInfo>> map = CollectClassMembersUtil.getAllMethods(grType, true);
            List<CandidateInfo> candidateInfos = map.get(name);
            if (candidateInfos != null) {
                for (CandidateInfo info : candidateInfos) {
                    PsiElement element = info.getElement();
                    result.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)element), (Object)info.getSubstitutor()));
                }
            }
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "findMethodsAndTheirSubstitutorsByName"));
        }
        return arrayList;
    }

    @NotNull
    public static List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors(GrTypeDefinition grType) {
        Map<String, List<CandidateInfo>> allMethodsMap = CollectClassMembersUtil.getAllMethods(grType, true);
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> result = new ArrayList<Pair<PsiMethod, PsiSubstitutor>>();
        for (List<CandidateInfo> infos : allMethodsMap.values()) {
            for (CandidateInfo info : infos) {
                result.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)info.getElement()), (Object)info.getSubstitutor()));
            }
        }
        ArrayList<Pair<PsiMethod, PsiSubstitutor>> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getAllMethodsAndTheirSubstitutors"));
        }
        return arrayList;
    }

    @Nullable
    public static PsiField findFieldByName(GrTypeDefinition grType, String name, boolean checkBases, boolean includeSynthetic) {
        if (!checkBases) {
            for (PsiField field : CollectClassMembersUtil.getFields(grType, includeSynthetic)) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
            return null;
        }
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType, includeSynthetic);
        CandidateInfo info = fieldsMap.get(name);
        return info == null ? null : (PsiField)info.getElement();
    }

    public static PsiField[] getAllFields(GrTypeDefinition grType) {
        return GrClassImplUtil.getAllFields(grType, true);
    }

    public static PsiField[] getAllFields(GrTypeDefinition grType, boolean includeSynthetic) {
        Map<String, CandidateInfo> fieldsMap = CollectClassMembersUtil.getAllFields(grType, includeSynthetic);
        return (PsiField[])ContainerUtil.map2Array(fieldsMap.values(), PsiField.class, entry -> (PsiField)entry.getElement());
    }

    public static boolean isClassEquivalentTo(GrTypeDefinitionImpl definition, PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo((PsiClass)definition, (PsiElement)another);
    }

    @NotNull
    public static Collection<? extends PsiMethod> expandReflectedMethods(@NotNull PsiMethod method) {
        Object[] methods;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "expandReflectedMethods"));
        }
        if (method instanceof GrMethod && (methods = ((GrMethod)method).getReflectedMethods()).length > 0) {
            List list = ContainerUtil.newSmartList((Object[])methods);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "expandReflectedMethods"));
            }
            return list;
        }
        List<PsiMethod> list = Collections.singletonList(method);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "expandReflectedMethods"));
        }
        return list;
    }

    @NotNull
    public static Set<MethodSignature> getDuplicatedSignatures(@NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getDuplicatedSignatures"));
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)clazz, () -> {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "lambda$getDuplicatedSignatures$3"));
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory();
            MostlySingularMultiMap signatures = MostlySingularMultiMap.newMap();
            for (PsiMethod method : clazz.getMethods()) {
                MethodSignature signature = method.getSignature(factory.createRawSubstitutor((PsiTypeParameterListOwner)method));
                signatures.add((Object)signature, (Object)method);
            }
            HashSet result = ContainerUtil.newHashSet();
            for (MethodSignature signature : signatures.keySet()) {
                if (signatures.valuesForKey((Object)signature) <= 1) continue;
                result.add(signature);
            }
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{clazz});
        });
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "getDuplicatedSignatures"));
        }
        return set;
    }

    public static GrAccessorMethod findSetter(GrField field) {
        return (GrAccessorMethod)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.doGetSetter(field), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
    }

    @Nullable
    private static GrAccessorMethod doGetSetter(GrField field) {
        PsiMethod[] setters;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        for (PsiMethod setter : setters = containingClass.findMethodsByName(GroovyPropertyUtils.getSetterName(field.getName()), false)) {
            if (!(setter instanceof GrAccessorMethod)) continue;
            return (GrAccessorMethod)setter;
        }
        return null;
    }

    public static GrAccessorMethod[] findGetters(GrField field) {
        return (GrAccessorMethod[])CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.doGetGetters(field), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
    }

    @NotNull
    private static GrAccessorMethod[] doGetGetters(GrField field) {
        PsiMethod[] booleanGetters;
        PsiMethod[] getters;
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            if (GrAccessorMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "doGetGetters"));
            }
            return GrAccessorMethod.EMPTY_ARRAY;
        }
        GrAccessorMethod getter = null;
        GrAccessorMethod booleanGetter = null;
        for (PsiMethod method : getters = containingClass.findMethodsByName(GroovyPropertyUtils.getGetterNameNonBoolean(field.getName()), false)) {
            if (!(method instanceof GrAccessorMethod)) continue;
            getter = (GrAccessorMethod)method;
            break;
        }
        for (PsiMethod method : booleanGetters = containingClass.findMethodsByName(GroovyPropertyUtils.getGetterNameBoolean(field.getName()), false)) {
            if (!(method instanceof GrAccessorMethod)) continue;
            booleanGetter = (GrAccessorMethod)method;
            break;
        }
        if (getter != null && booleanGetter != null) {
            GrAccessorMethod[] grAccessorMethodArray = new GrAccessorMethod[]{getter, booleanGetter};
            if (grAccessorMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "doGetGetters"));
            }
            return grAccessorMethodArray;
        }
        if (getter != null) {
            GrAccessorMethod[] grAccessorMethodArray = new GrAccessorMethod[]{getter};
            if (grAccessorMethodArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "doGetGetters"));
            }
            return grAccessorMethodArray;
        }
        if (GrAccessorMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/util/GrClassImplUtil", "doGetGetters"));
        }
        return GrAccessorMethod.EMPTY_ARRAY;
    }
}

