/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.CssValueDeclaration;
import com.intellij.psi.css.CssValueImportedAlias;
import com.intellij.psi.css.CssValueRule;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.impl.CssAtRuleImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueRuleImpl
extends CssAtRuleImpl
implements CssValueRule {
    public CssValueRuleImpl() {
        super(CssContextType.ANY, CssElementTypes.CSS_VALUE_RULE);
    }

    @NotNull
    public Collection<String> getValueNames() {
        SmartList result = new SmartList();
        this.processValueDeclaringElements((Processor<CssNamedElement>)((Processor)arg_0 -> CssValueRuleImpl.lambda$getValueNames$0((Collection)result, arg_0)));
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssValueRuleImpl", "getValueNames"));
        }
        return smartList;
    }

    public boolean processValueDeclaringElements(@NotNull Processor<CssNamedElement> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/impl/CssValueRuleImpl", "processValueDeclaringElements"));
        }
        for (PsiElement element : this.getChildren()) {
            PsiElement list;
            if (element instanceof CssValueDeclaration) {
                if (processor.process((Object)((CssValueDeclaration)element))) continue;
                return false;
            }
            if (element.getNode().getElementType() != CssElementTypes.CSS_VALUE_IMPORT) continue;
            for (list = element.getFirstChild(); list != null && list.getNode().getElementType() != CssElementTypes.CSS_VALUE_IMPORTED_ALIAS_LIST; list = list.getNextSibling()) {
            }
            if (list == null || list.getNode().getElementType() != CssElementTypes.CSS_VALUE_IMPORTED_ALIAS_LIST) continue;
            for (PsiElement alias : list.getChildren()) {
                if (!(alias instanceof CssValueImportedAlias) || processor.process((Object)((CssValueImportedAlias)alias))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemPresentation getPresentation() {
        final String text = StringUtil.join(this.getValueNames(), (String)", ");
        if (text.isEmpty()) {
            return super.getPresentation();
        }
        return new ItemPresentation(){

            @NotNull
            public String getPresentableText() {
                String string = text;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssValueRuleImpl$1", "getPresentableText"));
                }
                return string;
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @NotNull
            public Icon getIcon(boolean unused) {
                Icon icon = CssValueRule.ICON;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/CssValueRuleImpl$1", "getIcon"));
                }
                return icon;
            }
        };
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/css/impl/CssValueRuleImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitAtRule((CssAtRule)this);
        } else {
            super.accept(visitor);
        }
    }

    private static /* synthetic */ boolean lambda$getValueNames$0(Collection result, CssNamedElement element) {
        ContainerUtil.addIfNotNull((Collection)result, (Object)element.getName());
        return true;
    }
}

