/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.descriptor.visitor;

import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueDescriptorVisitor;
import com.intellij.psi.css.impl.descriptor.value.CssFunctionInvocationValue;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssPropertyReferenceValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueDescriptorVisitorImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssParameterInfoValueDescriptorsVisitor
extends CssValueDescriptorVisitorImpl {
    @NotNull
    private final StringBuilder myParameterInfoBuilder = new StringBuilder();
    private final HashSet<CssValueDescriptor> myHighlightingDescriptors = ContainerUtil.newHashSet();
    private final boolean myEscapeXml;
    private final boolean myAddLinksForReferenceValues;
    private int myHighlightingStart = -1;
    private int myHighlightingEnd = -1;

    public CssParameterInfoValueDescriptorsVisitor(@Nullable CssValueDescriptor highlightingDescriptor, boolean escapeXml, boolean addLinksForReferenceValues) {
        this.myEscapeXml = escapeXml;
        this.myAddLinksForReferenceValues = addLinksForReferenceValues;
        for (highlightingDescriptor = CssParameterInfoValueDescriptorsVisitor.adjustHighlightingDescriptor(highlightingDescriptor); highlightingDescriptor != null; highlightingDescriptor = highlightingDescriptor.getParent()) {
            this.myHighlightingDescriptors.add(highlightingDescriptor);
        }
    }

    @NotNull
    public String getParameterInfo() {
        String string = this.myParameterInfoBuilder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/descriptor/visitor/CssParameterInfoValueDescriptorsVisitor", "getParameterInfo"));
        }
        return string;
    }

    public int getHighlightingStart() {
        return this.myHighlightingStart;
    }

    public int getHighlightingEnd() {
        return this.myHighlightingEnd;
    }

    @Override
    public void visitGroupValue(@NotNull CssGroupValue groupValue) {
        String presentableName;
        if (groupValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupValue", "com/intellij/psi/css/impl/descriptor/visitor/CssParameterInfoValueDescriptorsVisitor", "visitGroupValue"));
        }
        if (this.isHighlightingDescriptor(groupValue)) {
            this.updateHighlightingStart();
        }
        if ((presentableName = groupValue.getPresentableName()).isEmpty()) {
            CssValueDescriptor separator;
            String separatorString;
            boolean withBrackets;
            Collection<CssValueDescriptor> children = groupValue.getChildren();
            Iterator<CssValueDescriptor> childrenIterator = children.iterator();
            CssValueDescriptor parent = groupValue.getParent();
            CssGroupValue.Type groupValueType = groupValue.getType();
            boolean bl = withBrackets = parent != null && children.size() > 1 && (groupValueType != CssGroupValue.Type.ALL || groupValue.getMinOccur() < 1 || groupValue.getMaxOccur() < 1) || groupValue.isCommaSeparated();
            if (withBrackets) {
                this.append("[");
            }
            String string = separatorString = (separator = groupValue.getValuesSeparator()) != null ? separator.getPresentableName() : CssParameterInfoValueDescriptorsVisitor.getDefaultGroupSeparator(groupValueType);
            while (childrenIterator.hasNext()) {
                childrenIterator.next().accept((CssValueDescriptorVisitor)this);
                if (!childrenIterator.hasNext()) continue;
                this.append(separatorString);
            }
            if (withBrackets) {
                this.append("]");
            }
        } else {
            this.append(presentableName);
        }
        this.addExtraQualifiers(groupValue);
        if (this.isHighlightingDescriptor(groupValue)) {
            this.updateHighlightingEnd();
        }
    }

    @Override
    public void visitFunctionValue(@NotNull CssFunctionInvocationValue functionValue) {
        if (functionValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionValue", "com/intellij/psi/css/impl/descriptor/visitor/CssParameterInfoValueDescriptorsVisitor", "visitFunctionValue"));
        }
        if (this.myAddLinksForReferenceValues && !"url".equals(functionValue.getFunctionName())) {
            this.myParameterInfoBuilder.append("<a href=\"psi_element://F:").append(functionValue.getId()).append("\">");
            super.visitFunctionValue(functionValue);
            this.myParameterInfoBuilder.append("</a>");
        } else {
            super.visitFunctionValue(functionValue);
        }
    }

    @Override
    public void visitPropertyReferenceValue(@NotNull CssPropertyReferenceValue propertyReferenceValue) {
        if (propertyReferenceValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyReferenceValue", "com/intellij/psi/css/impl/descriptor/visitor/CssParameterInfoValueDescriptorsVisitor", "visitPropertyReferenceValue"));
        }
        if (this.myAddLinksForReferenceValues) {
            this.myParameterInfoBuilder.append("<a href=\"psi_element://P:").append(propertyReferenceValue.getId()).append("\">");
            super.visitPropertyReferenceValue(propertyReferenceValue);
            this.myParameterInfoBuilder.append("</a>");
        } else {
            super.visitPropertyReferenceValue(propertyReferenceValue);
        }
    }

    @Override
    public void visitValue(@NotNull CssValueDescriptor value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/descriptor/visitor/CssParameterInfoValueDescriptorsVisitor", "visitValue"));
        }
        if (this.isHighlightingDescriptor(value)) {
            this.updateHighlightingStart();
        }
        this.append(value.getPresentableName());
        this.addExtraQualifiers(value);
        if (this.isHighlightingDescriptor(value)) {
            this.updateHighlightingEnd();
        }
    }

    private void updateHighlightingStart() {
        if (this.myHighlightingStart < 0 || this.myHighlightingStart < this.myParameterInfoBuilder.length()) {
            this.myHighlightingStart = this.myParameterInfoBuilder.length();
        }
    }

    private void updateHighlightingEnd() {
        if (this.myHighlightingEnd < 0 || this.myHighlightingEnd > this.myParameterInfoBuilder.length()) {
            this.myHighlightingEnd = this.myParameterInfoBuilder.length();
        }
    }

    private boolean isHighlightingDescriptor(CssValueDescriptor value) {
        return ContainerUtil.containsIdentity(this.myHighlightingDescriptors, (Object)value);
    }

    private static String getDefaultGroupSeparator(CssGroupValue.Type groupValueType) {
        if (groupValueType == CssGroupValue.Type.OR) {
            return " | ";
        }
        if (groupValueType == CssGroupValue.Type.ANY) {
            return " || ";
        }
        if (groupValueType == CssGroupValue.Type.AND) {
            return " && ";
        }
        return " ";
    }

    private void addExtraQualifiers(@NotNull CssValueDescriptor value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/css/impl/descriptor/visitor/CssParameterInfoValueDescriptorsVisitor", "addExtraQualifiers"));
        }
        int minOccur = value.getMinOccur();
        int maxOccur = value.getMaxOccur();
        if (value.isCommaSeparated()) {
            this.append("#");
        } else if (maxOccur < 1 && minOccur < 1) {
            this.append("*");
        } else if (minOccur == maxOccur && minOccur > 1) {
            this.append("{").append(minOccur).append("}");
        } else if (maxOccur > 1 && minOccur > 0) {
            this.append("{").append(minOccur).append(",").append(maxOccur).append("}");
        } else if (maxOccur < 1) {
            this.append("+");
        } else if (minOccur < 1) {
            this.append("?");
        }
    }

    private StringBuilder append(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/psi/css/impl/descriptor/visitor/CssParameterInfoValueDescriptorsVisitor", "append"));
        }
        return this.myParameterInfoBuilder.append(this.myEscapeXml ? XmlStringUtil.escapeString((String)string) : string);
    }

    @Nullable
    private static CssValueDescriptor adjustHighlightingDescriptor(@Nullable CssValueDescriptor descriptor) {
        CssValueDescriptor firstChild;
        CssGroupValue.Type type;
        if (descriptor == null) {
            return null;
        }
        for (CssValueDescriptor parent = descriptor.getParent(); parent != null && parent instanceof CssGroupValue && parent.getParent() != null && ((type = ((CssGroupValue)parent).getType()) != CssGroupValue.Type.ALL || (firstChild = (CssValueDescriptor)ContainerUtil.getFirstItem(((CssGroupValue)parent).getChildren())) == descriptor); parent = parent.getParent()) {
            descriptor = parent;
        }
        return descriptor;
    }
}

