/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.completion;

import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupValueWithPriority;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.css.impl.util.completion.CssUserLookupBase;
import com.intellij.psi.css.impl.util.completion.handler.CssPropertyValueInsertHandler;
import com.intellij.psi.css.impl.util.table.CssColorValue;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.util.ColorSampleLookupValue;
import com.intellij.xml.util.UserColorLookup;
import icons.ImagesIcons;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCompletionUtil {
    public static final int CSS_VALUE_BASE_PRIORITY = 100;
    public static final int CSS_CUSTOM_PROPERTY_PRIORITY = 110;
    private static final int CSS_COLOR_VALUE_PRIORITY = 80;
    private static final int CSS_POPULAR_COLOR_VALUE_PRIORITY = 81;
    private static final int CSS_USER_COLOR_LOOKUP_PRIORITY = 90;
    private static final int CSS_IMAGE_SIZE_PRIORITY = 110;
    public static final int CSS_COMMON_FUNCTIONS_PRIORITY = 95;
    public static final int CSS_MEDIA_FEATURE_PRIORITY = 10;
    private static final Function<Color, String> COLOR_TO_STRING_CONVERTER = color -> color.getAlpha() < 255 ? CssPsiColorUtil.toRgbColor(color) : CssPsiColorUtil.toHexColor(color);

    @NotNull
    public static LookupElement lookupItemForImageSize(int size, @Nullable PsiFile imageFile) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)String.valueOf(size + "px")).withIcon(ImagesIcons.ImagesFileType);
        lookupElementBuilder = imageFile != null ? lookupElementBuilder.withTypeText(SymbolPresentationUtil.getFilePathPresentation((PsiFile)imageFile), true) : lookupElementBuilder;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElementBuilder, (double)110.0);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemForImageSize"));
        }
        return lookupElement;
    }

    @NotNull
    public static LookupElement lookupItemForValue(String value) {
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)value).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE), (double)100.0);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupItemForValue"));
        }
        return lookupElement;
    }

    public static LookupElement valueLookupElement(Object o) {
        LookupElement lookupElement = null;
        if (o instanceof LookupElement) {
            lookupElement = (LookupElement)o;
        } else if (o instanceof String) {
            lookupElement = LookupElementBuilder.create((Object)o).withInsertHandler(CssPropertyValueInsertHandler.INSTANCE);
        } else if (o instanceof CssUserLookupBase) {
            lookupElement = ((CssUserLookupBase)o).lookup();
        } else if (o instanceof ColorSampleLookupValue) {
            lookupElement = LookupElementDecorator.withInsertHandler((LookupElement)CompletionData.objectToLookupItem((Object)o), CssPropertyValueInsertHandler.INSTANCE);
        }
        return lookupElement != null ? PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)CssCompletionUtil.priority(o)) : null;
    }

    private CssCompletionUtil() {
    }

    private static int priority(Object o) {
        int priority = o instanceof CssColorValue.MyPopularColorLookupValue ? 81 + ((ColorSampleLookupValue)o).getPriority() : (o instanceof ColorSampleLookupValue ? 80 + ((ColorSampleLookupValue)o).getPriority() : (o instanceof LookupValueWithPriority ? 100 + ((LookupValueWithPriority)o).getPriority() : 100));
        return priority;
    }

    public static UserColorLookup lookupForUserColorLookup() {
        return new UserColorLookup(COLOR_TO_STRING_CONVERTER, 90);
    }

    @NotNull
    public static LookupElement lookupForCustomProperty(@NotNull String name, @NotNull CssNamedElement element, @Nullable PsiFile contextFile, int priority, @Nullable InsertHandler<LookupElement> insertHandler) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupForCustomProperty"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupForCustomProperty"));
        }
        PsiFile containingFile = element.getContainingFile();
        if (contextFile == containingFile) {
            ++priority;
        }
        ItemPresentation itemPresentation = element.getPresentation();
        assert (itemPresentation != null);
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)element).withPresentableText((String)ObjectUtils.notNull((Object)itemPresentation.getPresentableText(), (Object)name)).withIcon(itemPresentation.getIcon(false)).withTypeText(itemPresentation.getLocationString(), true).withInsertHandler(insertHandler), (double)priority);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/impl/util/completion/CssCompletionUtil", "lookupForCustomProperty"));
        }
        return lookupElement;
    }
}

