/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssUnknownTargetInspection
extends CssBaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"css.inspections.unknown.target", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssUnknownTargetInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssUnknownTargetInspection", "buildVisitor"));
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssString(CssString string) {
                CssUnknownTargetInspection.processElement((PsiElement)string, holder);
            }

            public void visitCssUri(CssUri uri) {
                PsiElement element = uri.getValueElement();
                if (element != null && !(element instanceof CssString)) {
                    CssUnknownTargetInspection.processElement(element, holder);
                }
            }
        };
        if (cssElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/inspections/invalid/CssUnknownTargetInspection", "buildVisitor"));
        }
        return cssElementVisitor;
    }

    private static void processElement(@NotNull PsiElement element, ProblemsHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/inspections/invalid/CssUnknownTargetInspection", "processElement"));
        }
        if (!element.isValid() || PsiTreeUtil.getChildOfType((PsiElement)element, OuterLanguageElement.class) != null) {
            return;
        }
        PsiReference[] references = element.getReferences();
        for (PsiFileReference reference : CssUnknownTargetInspection.findUnresolvedFileReferences(references)) {
            CssUnknownTargetInspection.registerProblem(holder, (PsiReference)reference, reference.isSoft() ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        for (PsiReference reference : references) {
            PsiElement resolve;
            if (!(reference instanceof UrlReference) || (resolve = reference.resolve()) != null) continue;
            CssUnknownTargetInspection.registerProblem(holder, reference, ProblemHighlightType.WEAK_WARNING);
        }
    }

    private static void registerProblem(ProblemsHolder holder, PsiReference reference, ProblemHighlightType highlightType) {
        String errorMessage = ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference);
        holder.registerProblem(reference, errorMessage, highlightType);
    }

    private static Collection<PsiFileReference> findUnresolvedFileReferences(PsiReference[] references) {
        HashMap rangeToUnresolvedRef = ContainerUtil.newHashMap();
        HashSet resolvedRanges = ContainerUtil.newHashSet();
        for (PsiReference reference : references) {
            if (!(reference instanceof PsiFileReference)) continue;
            TextRange range = reference.getRangeInElement();
            if (reference instanceof FileReference && ((FileReference)reference).getIndex() == 0 && ((FileReference)reference).getText().startsWith("~")) {
                range = TextRange.create((int)(range.getStartOffset() + 1), (int)range.getEndOffset());
            }
            if (((PsiFileReference)reference).multiResolve(false).length > 0) {
                resolvedRanges.add(range);
                rangeToUnresolvedRef.remove(range);
                continue;
            }
            if (resolvedRanges.contains(range) || reference.isSoft() && rangeToUnresolvedRef.containsKey(range)) continue;
            rangeToUnresolvedRef.put(range, (PsiFileReference)reference);
        }
        return rangeToUnresolvedRef.values();
    }
}

