/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceProviderType;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.resolve.StylesheetFileReferenceSet;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssReferenceProviderUtil {
    public static final ReferenceProviderType CSS_CLASS_OR_ID_KEY_PROVIDER = new ReferenceProviderType("Css Class or ID Provider");

    @NotNull
    public static PsiReference[] getFileReferences(@Nullable PsiElement element, boolean typedReference, boolean isImageReference, FileType ... suitableFileTypes) {
        Pair<String, TextRange> referenceData = CssReferenceProviderUtil.getFileReferenceData(element);
        if (referenceData != null) {
            if (HtmlUtil.hasHtmlPrefix((String)((String)referenceData.first))) {
                PsiReference[] psiReferenceArray = new PsiReference[]{new UrlReference(element, (FileType)(typedReference ? CssFileType.INSTANCE : null), !typedReference)};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/CssReferenceProviderUtil", "getFileReferences"));
                }
                return psiReferenceArray;
            }
            StylesheetFileReferenceSet referenceSet = new StylesheetFileReferenceSet(element, (String)referenceData.first, (TextRange)referenceData.second, isImageReference, suitableFileTypes);
            FileReference[] fileReferenceArray = referenceSet.getAllReferences();
            if (fileReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/CssReferenceProviderUtil", "getFileReferences"));
            }
            return fileReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/resolve/CssReferenceProviderUtil", "getFileReferences"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Nullable
    public static Pair<String, TextRange> getFileReferenceData(@Nullable PsiElement element) {
        TextRange resultRange;
        String resultText;
        int lastPosOfURL;
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)parent))) {
            return null;
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        String elementText = element.getText();
        int indexOfBang = elementText.lastIndexOf(33, endOffset);
        if (indexOfBang >= 0 && startOffset <= indexOfBang && indexOfBang < endOffset) {
            startOffset = indexOfBang + 1;
        }
        if (elementText.startsWith("CSS:", startOffset)) {
            startOffset += 4;
        }
        int n = endOffset = (lastPosOfURL = PathReferenceProviderBase.getLastPosOfURL((int)startOffset, (String)elementText)) >= 0 ? lastPosOfURL : endOffset;
        if (element instanceof CssString) {
            PsiElement[] children;
            for (PsiElement child : children = element.getChildren()) {
                IElementType type = child.getNode().getElementType();
                if (type == CssElementTypes.CSS_STRING_TOKEN) continue;
                if (lastPosOfURL != -1 && lastPosOfURL < child.getStartOffsetInParent()) break;
                return null;
            }
        }
        if (startOffset > endOffset) {
            return null;
        }
        int indexOfNewLine = elementText.indexOf(10, startOffset);
        if (indexOfNewLine > -1) {
            endOffset = indexOfNewLine;
        }
        if (CssReferenceProviderUtil.isDataUrl(resultText = (resultRange = TextRange.create((int)startOffset, (int)endOffset)).substring(elementText))) {
            return null;
        }
        return Pair.create((Object)resultText, (Object)resultRange);
    }

    private static boolean isDataUrl(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/psi/css/resolve/CssReferenceProviderUtil", "isDataUrl"));
        }
        return string.startsWith("data:");
    }

    private CssReferenceProviderUtil() {
    }
}

