/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UastUtils;

public class HandlerDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("HandlerLeak", "Handler reference leaks", "Since this Handler is declared as an inner class, it may prevent the outer class from being garbage collected. If the Handler is using a Looper or MessageQueue for a thread other than the main thread, then there is no issue. If the Handler is using the Looper or MessageQueue of the main thread, you need to fix your Handler declaration, as follows: Declare the Handler as a static class; In the outer class, instantiate a WeakReference to the outer class and pass this object to your Handler when you instantiate the Handler; Make all references to members of the outer class using the WeakReference object.", Category.PERFORMANCE, 4, Severity.WARNING, new Implementation(HandlerDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String LOOPER_CLS = "android.os.Looper";
    private static final String HANDLER_CLS = "android.os.Handler";

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(HANDLER_CLS);
    }

    @Override
    public void checkClass(JavaContext context, UClass declaration2) {
        if (context.getEvaluator().isStatic((PsiModifierListOwner)declaration2)) {
            return;
        }
        boolean isAnonymous = declaration2 instanceof UAnonymousClass;
        if (declaration2.getContainingClass() == null && !isAnonymous) {
            return;
        }
        UCallExpression invocation = (UCallExpression)UastUtils.getParentOfType((UElement)declaration2, UObjectLiteralExpression.class, (boolean)true, (Class[])new Class[]{UMethod.class});
        if (invocation != null) {
            if (isAnonymous && invocation.getValueArgumentCount() > 0) {
                for (UExpression expression2 : invocation.getValueArguments()) {
                    PsiType type2 = expression2.getExpressionType();
                    if (!(type2 instanceof PsiClassType) || !LOOPER_CLS.equals(type2.getCanonicalText())) continue;
                    return;
                }
            }
        } else if (HandlerDetector.hasLooperConstructorParameter((PsiClass)declaration2)) {
            return;
        }
        Location location = context.getUastNameLocation((UElement)declaration2);
        String name = isAnonymous ? "anonymous " + ((UAnonymousClass)declaration2).getBaseClassReference().getQualifiedName() : declaration2.getQualifiedName();
        context.reportUast(ISSUE, (UElement)declaration2, location, String.format("This Handler class should be static or leaks might occur (%1$s)", name));
    }

    private static boolean hasLooperConstructorParameter(PsiClass cls) {
        for (PsiMethod constructor : cls.getConstructors()) {
            for (PsiParameter parameter : constructor.getParameterList().getParameters()) {
                PsiType type2 = parameter.getType();
                if (!LOOPER_CLS.equals(type2.getCanonicalText())) continue;
                return true;
            }
        }
        return false;
    }
}

