/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collections;
import java.util.List;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;

public class ParcelDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("ParcelCreator", "Missing Parcelable `CREATOR` field", "According to the `Parcelable` interface documentation, \"Classes implementing the Parcelable interface must also have a static field called `CREATOR`, which is an object implementing the `Parcelable.Creator` interface.\"", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ParcelDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcelable.html");

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.os.Parcelable");
    }

    @Override
    public void checkClass(JavaContext context, UClass declaration2) {
        if (declaration2 instanceof UAnonymousClass) {
            return;
        }
        if (declaration2.isInterface()) {
            return;
        }
        if (declaration2.hasModifierProperty("abstract")) {
            return;
        }
        if (InheritanceUtil.isInheritor((PsiClass)declaration2, (boolean)false, (String)"android.text.ParcelableSpan")) {
            return;
        }
        if (declaration2.findAnnotation(Parcelize.class.getName()) != null) {
            return;
        }
        PsiField field = declaration2.findFieldByName("CREATOR", false);
        if (field == null) {
            Location location = context.getUastNameLocation((UElement)declaration2);
            context.reportUast(ISSUE, (UElement)declaration2, location, "This class implements `Parcelable` but does not provide a `CREATOR` field");
        }
    }
}

