/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.braces;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSAddBracesIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String ELSE_KEYWORD = "else";
    @NonNls
    private static final String ARROW_FUNCTION_KEYWORD = "arrow function";

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        AddBracesPredicate addBracesPredicate = new AddBracesPredicate();
        if (addBracesPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "getElementPredicate"));
        }
        return addBracesPredicate;
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        String keyword;
        JSElement parent = (JSElement)element.getParent();
        assert (parent != null);
        if (JSAddBracesIntention.isShorthandArrowFunction(element)) {
            keyword = ARROW_FUNCTION_KEYWORD;
        } else if (parent instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement elseBranch = ifStatement.getElse();
            keyword = JSAddBracesIntention.quote(element.equals(elseBranch) ? ELSE_KEYWORD : IF_KEYWORD);
        } else {
            PsiElement firstChild = parent.getFirstChild();
            assert (firstChild != null);
            keyword = JSAddBracesIntention.quote(firstChild.getText());
        }
        return this.getText(keyword);
    }

    private static String quote(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "quote"));
        }
        return '\'' + s + '\'';
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "processIntention"));
        }
        if (JSAddBracesIntention.isShorthandArrowFunction(element)) {
            JSAddBracesIntention.addBracesToShorthandArrowFunction(element);
            return;
        }
        if (!(element instanceof JSStatement)) {
            return;
        }
        JSStatement statement = (JSStatement)element;
        JSElement parent = (JSElement)element.getParent();
        String text = element.getText();
        String newText = parent.getLastChild() instanceof PsiComment ? '{' + text + "\n}" : '{' + text + '}';
        JSAddBracesIntention.replaceAndReformat(statement, newText);
    }

    private static void replaceAndReformat(@NotNull JSStatement statement, @NotNull String text) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "replaceAndReformat"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "replaceAndReformat"));
        }
        Ref newStatement = Ref.create();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)statement.getProject());
        codeStyleManager.performActionWithFormatterDisabled(() -> {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "lambda$replaceAndReformat$0"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "lambda$replaceAndReformat$0"));
            }
            newStatement.set((Object)JSElementFactory.replaceStatement((JSStatement)statement, (String)text));
        });
        PsiElement formatted = codeStyleManager.reformat((PsiElement)newStatement.get());
        codeStyleManager.reformatNewlyAddedElement(formatted.getNode().getTreeParent(), formatted.getNode());
    }

    private static void addBracesToShorthandArrowFunction(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "addBracesToShorthandArrowFunction"));
        }
        JSFunction dummyFunction = JSAddBracesIntention.createDummyArrowFunctionWithReturn(element);
        ASTNode arrow = JSPsiImplUtils.getFunctionArrowNode((JSFunction)((JSFunction)element));
        if (arrow == null) {
            return;
        }
        JSExpression expression = (JSExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)arrow.getPsi(), JSExpression.class);
        if (expression == null) {
            return;
        }
        JSReturnStatement returnStatement = (JSReturnStatement)PsiTreeUtil.findChildOfType((PsiElement)dummyFunction, JSReturnStatement.class);
        assert (returnStatement != null);
        returnStatement.getExpression().replace(expression);
        List<PsiElement> prefixElements = JSAddBracesIntention.collectSiblingsInRange(arrow.getPsi(), (PsiElement)expression);
        if (!prefixElements.isEmpty()) {
            prefixElements.forEach(el -> JSChangeUtil.doDoAddBeforePure((PsiElement)returnStatement.getParent(), (PsiElement)el, (PsiElement)returnStatement));
            element.getNode().removeRange(prefixElements.get(0).getNode(), expression.getNode());
        }
        JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)dummyFunction, JSBlockStatement.class);
        assert (block != null);
        PsiElement replacedBody = expression.replace((PsiElement)block);
        FormatFixer.create((PsiElement)replacedBody, (FormatFixer.Mode)FormatFixer.Mode.ReformatExactRange).fixFormat();
    }

    @NotNull
    private static JSFunction createDummyArrowFunctionWithReturn(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "createDummyArrowFunctionWithReturn"));
        }
        JSExpressionStatement dummySt = (JSExpressionStatement)JSChangeUtil.createStatementPsiFromTextWithContext((String)String.format("()=>{return a%s}", JSCodeStyleSettings.getSemicolon((PsiFile)element.getContainingFile())), (PsiElement)element, JSExpressionStatement.class);
        assert (dummySt != null && dummySt.getExpression() instanceof JSFunction);
        JSFunction jSFunction = (JSFunction)dummySt.getExpression();
        if (jSFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "createDummyArrowFunctionWithReturn"));
        }
        return jSFunction;
    }

    @NotNull
    private static List<PsiElement> collectSiblingsInRange(@NotNull PsiElement from, @NotNull PsiElement toExcluding) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "collectSiblingsInRange"));
        }
        if (toExcluding == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toExcluding", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "collectSiblingsInRange"));
        }
        SmartList elements = new SmartList();
        for (PsiElement current = from.getNextSibling(); current != null && !current.equals(toExcluding); current = current.getNextSibling()) {
            elements.add(current);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "collectSiblingsInRange"));
        }
        return smartList;
    }

    private static boolean isShorthandArrowFunction(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention", "isShorthandArrowFunction"));
        }
        return element instanceof JSFunctionExpression && JSPsiImplUtils.isArrowFunction((JSFunction)((JSFunction)element)) && PsiTreeUtil.getChildOfType((PsiElement)element, JSBlockStatement.class) == null;
    }

    private static class AddBracesPredicate
    implements JSElementPredicate {
        private AddBracesPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/braces/JSAddBracesIntention$AddBracesPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSStatement)) {
                return JSAddBracesIntention.isShorthandArrowFunction(element);
            }
            if (element instanceof JSBlockStatement) {
                return false;
            }
            PsiElement parentElement = element.getParent();
            if (!(parentElement instanceof JSElement)) {
                return false;
            }
            JSElement parent = (JSElement)parentElement;
            if (parent instanceof JSIfStatement) {
                JSIfStatement ifStatement = (JSIfStatement)parent;
                return !(element instanceof JSIfStatement) || !element.equals(ifStatement.getElse());
            }
            if (parent instanceof JSForStatement || parent instanceof JSForInStatement) {
                return element.equals(((JSLoopStatement)parent).getBody());
            }
            return parent instanceof JSWhileStatement || parent instanceof JSDoWhileStatement;
        }
    }
}

