/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.icons.AllIcons;
import com.intellij.j2ee.webSphere.WebSphereBundle;
import com.intellij.j2ee.webSphere.configuration.LooseAppBuildTask;
import com.intellij.j2ee.webSphere.configuration.WebSphereBuildLooseAppBeforeRunTask;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProviderBase;
import com.intellij.task.ProjectTask;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WebSphereBuildLooseAppsBeforeRunTaskProvider
extends BuildArtifactsBeforeRunTaskProviderBase<WebSphereBuildLooseAppBeforeRunTask> {
    @NonNls
    public static final String BUILD_LOOSE_APPS_ID = "BuildLooseApps";
    public static final Key<WebSphereBuildLooseAppBeforeRunTask> ID = Key.create((String)"BuildLooseApps");
    public static final Key<Artifact[]> LOOSE_APPS_KEY = Key.create((String)"loose-apps");

    public WebSphereBuildLooseAppsBeforeRunTaskProvider(Project project) {
        super(WebSphereBuildLooseAppBeforeRunTask.class, project);
    }

    public Key<WebSphereBuildLooseAppBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return WebSphereBundle.message("build.loose.apps.before.run.description.empty", new Object[0]);
    }

    public String getDescription(WebSphereBuildLooseAppBeforeRunTask task) {
        List pointers = task.getArtifactPointers();
        if (pointers.isEmpty()) {
            return WebSphereBundle.message("build.loose.apps.before.run.description.empty", new Object[0]);
        }
        if (pointers.size() == 1) {
            return WebSphereBundle.message("build.loose.apps.before.run.description.single", ((ArtifactPointer)pointers.get(0)).getArtifactName());
        }
        return WebSphereBundle.message("build.loose.apps.before.run.description.multiple", pointers.size());
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Xml;
    }

    public Icon getTaskIcon(WebSphereBuildLooseAppBeforeRunTask task) {
        return this.getIcon();
    }

    protected WebSphereBuildLooseAppBeforeRunTask doCreateTask(Project project) {
        return new WebSphereBuildLooseAppBeforeRunTask(project);
    }

    protected ProjectTask createProjectTask(Project project, List<Artifact> artifacts) {
        return artifacts.size() == 1 ? new LooseAppBuildTask(artifacts.get(0), true) : new ProjectTaskList((Collection)ContainerUtil.map(artifacts, artifact -> new LooseAppBuildTask((Artifact)artifact, true)));
    }

    public static void setBuildLooseAppBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, Project project, @NotNull Artifact artifact, boolean enable) {
        if (runConfigurationEditorComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigurationEditorComponent", "com/intellij/j2ee/webSphere/configuration/WebSphereBuildLooseAppsBeforeRunTaskProvider", "setBuildLooseAppBeforeRunOption"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/j2ee/webSphere/configuration/WebSphereBuildLooseAppsBeforeRunTaskProvider", "setBuildLooseAppBeforeRunOption"));
        }
        BeforeRunTaskProvider provider = WebSphereBuildLooseAppsBeforeRunTaskProvider.getProvider((Project)project, ID);
        if (provider != null) {
            ((WebSphereBuildLooseAppsBeforeRunTaskProvider)provider).setBuildArtifactBeforeRunOption(runConfigurationEditorComponent, artifact, enable);
        }
    }

    public static CompileScope setupLooseAppsCompileScope(CompileScope baseScope, List<Artifact> artifacts) {
        baseScope.putUserData(LOOSE_APPS_KEY, (Object)artifacts.toArray(new Artifact[artifacts.size()]));
        return baseScope;
    }
}

