/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.j2ee.webSphere.configuration.WebSphereCell;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfileUtil;
import com.intellij.j2ee.webSphere.configuration.WebSphereServerConfiguration;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class WebSphereNode {
    private final WebSphereCell myCell;
    private final File myNodeDirectory;
    private final String myNodeName;

    public WebSphereNode(@NotNull WebSphereCell cell, @NotNull File nodeDir, @NotNull String name) {
        if (cell == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cell", "com/intellij/j2ee/webSphere/configuration/WebSphereNode", "<init>"));
        }
        if (nodeDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeDir", "com/intellij/j2ee/webSphere/configuration/WebSphereNode", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/j2ee/webSphere/configuration/WebSphereNode", "<init>"));
        }
        this.myCell = cell;
        this.myNodeDirectory = nodeDir;
        this.myNodeName = name;
    }

    public File getNodeDirectory() {
        return this.myNodeDirectory;
    }

    public WebSphereCell getCell() {
        return this.myCell;
    }

    public WebSphereServerConfiguration[] getServers() {
        return WebSphereProfileUtil.getServerConfigurations(this);
    }

    public String getNodeName() {
        return this.myNodeName;
    }

    public String toString() {
        return this.myNodeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSphereNode that = (WebSphereNode)o;
        return this.myCell.equals(that.myCell) && this.myNodeDirectory.equals(that.myNodeDirectory);
    }

    public int hashCode() {
        int result = this.myCell.hashCode();
        result = 29 * result + this.myNodeDirectory.hashCode();
        return result;
    }
}

