/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.PositionManagersFactory;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.j2ee.webSphere.WebSphereBundle;
import com.intellij.j2ee.webSphere.configuration.WebSphereBuildLooseAppsBeforeRunTaskProvider;
import com.intellij.j2ee.webSphere.configuration.WebSphereLibertyConfigAccessor;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersionUtil;
import com.intellij.j2ee.webSphere.deploymentSource.LooseApplicationDeploymentSource;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereDefaultProfileHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereDeploymentModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereFullHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereLibertyHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereProfileHandler;
import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebSphereModel
extends JavaeeServerModel {
    private static final Logger LOG = Logger.getInstance(WebSphereModel.class);
    private static final Pattern JAR_MASK = Pattern.compile(".+\\.jar");
    private static final String SOAP_CONNECTOR_CLIENT_CLASS_NAME = "com.ibm.ws.management.connector.soap.SOAPConnectorClient";
    private static final String SSL_SOCKET_FACTORY_CLASS_NAME = "com.ibm.websphere.ssl.protocol.SSLSocketFactory";
    @NonNls
    private static final String WEBSPHERE_LOG_FILE_ID = "WebSphere";
    private WebSphereLibertyConfigAccessor myLibertyConfigAccessor;
    public String PROFILE_PATH = "";
    public int SOAP_PORT = 8880;
    @NonNls
    public String CELL_NAME = "";
    @NonNls
    public String NODE_NAME = "";
    @NonNls
    public String SERVER_NAME = "";
    public boolean SECURED = false;
    @NonNls
    public String CLIENT_TRUST_FILE_PATH = "";
    @NonNls
    public String CLIENT_TRUST_PASSWORD = "WebAS";
    @NonNls
    public String CLIENT_KEY_FILE_PATH = "";
    @NonNls
    public String CLIENT_KEY_PASSWORD = "WebAS";

    public WebSphereLibertyConfigAccessor getLibertyConfigAccessor() {
        if (this.myLibertyConfigAccessor == null || this.myLibertyConfigAccessor.getServerModel() != this) {
            this.myLibertyConfigAccessor = new WebSphereLibertyConfigAccessor(this);
        }
        return this.myLibertyConfigAccessor;
    }

    protected String getLogFileId() {
        return WEBSPHERE_LOG_FILE_ID;
    }

    protected String getDefaultUsername() {
        return "";
    }

    protected String getDefaultPassword() {
        return "";
    }

    public boolean isLibertyProfile() {
        WebSphereVersion version = this.getWebSphereVersion();
        return version != null && version.isLibertyProfile();
    }

    @NotNull
    protected final WebSphereProfileHandler createValidProfileHandler() throws RuntimeConfigurationException {
        WebSphereVersion version = this.getWebSphereVersion();
        if (version == null) {
            throw new RuntimeConfigurationError(WebSphereBundle.message("error.websphere.server.is.not.specified", new Object[0]));
        }
        WebSphereProfileHandler result = version.isLibertyProfile() ? this.createLibertyHandler() : this.createFullHandler(version);
        result.checkConfiguration();
        WebSphereProfileHandler webSphereProfileHandler = result;
        if (webSphereProfileHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2ee/webSphere/runDebug/configuration/WebSphereModel", "createValidProfileHandler"));
        }
        return webSphereProfileHandler;
    }

    public WebSphereProfileHandler getProfileHandler() {
        try {
            return this.createValidProfileHandler();
        }
        catch (RuntimeConfigurationException e) {
            LOG.debug((Throwable)e);
            return new WebSphereDefaultProfileHandler(this);
        }
    }

    protected abstract WebSphereLibertyHandler createLibertyHandler() throws RuntimeConfigurationException;

    protected abstract WebSphereFullHandler createFullHandler(WebSphereVersion var1) throws RuntimeConfigurationException;

    protected JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        return this.createValidProfileHandler().createServerAdmin(serverInstance);
    }

    public List<File> getLibraries() throws ExecutionException {
        ArrayList<File> libraries = new ArrayList<File>();
        WebSphereVersion version = this.getWebSphereVersion();
        if (version == null || !version.isLoadLibFolder()) {
            this.addJarForServerClass(libraries, SOAP_CONNECTOR_CLIENT_CLASS_NAME, "runtimes");
            this.addJarForServerClass(libraries, SSL_SOCKET_FACTORY_CLASS_NAME, "plugins");
        } else {
            libraries.addAll(this.findJars("lib"));
        }
        return libraries;
    }

    private List<File> findJars(String homeSubFolder) {
        File folder = this.getPathUnderHome(homeSubFolder);
        if (folder.exists() && folder.isDirectory()) {
            return FileUtil.findFilesByMask((Pattern)JAR_MASK, (File)folder);
        }
        return Collections.emptyList();
    }

    private void addJarForServerClass(List<File> libraries, String className, String homeSubFolder) throws ExecutionException {
        String classEntry = className.replace('.', '/') + ".class";
        for (File jarFile : this.findJars(homeSubFolder)) {
            try {
                ZipFile zip = new ZipFile(jarFile);
                if (zip.getEntry(classEntry) == null) continue;
                libraries.add(jarFile);
                return;
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        throw new ExecutionException("Can't find JAR for class: " + className);
    }

    @Nullable
    protected final WebSphereVersion getWebSphereVersion() {
        ApplicationServer applicationServer = this.getCommonModel().getApplicationServer();
        return WebSphereVersionUtil.createVersion(applicationServer);
    }

    public int getDefaultPort() {
        WebSphereVersion version = this.getWebSphereVersion();
        if (version != null) {
            return version.getDefaultHttpPort();
        }
        return 9080;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.PROFILE_PATH = FileUtil.toSystemIndependentName((String)this.PROFILE_PATH);
    }

    public PositionManager createPositionManager(DebugProcess process, JavaeeFacet[] facets) {
        WebSphereVersion version = this.getWebSphereVersion();
        if (version == null) {
            return super.createPositionManager(process, facets);
        }
        if (version.isJspLineMappingCorrectionNeeded()) {
            return PositionManagersFactory.getInstance().createWebSphereSpecificPositionManager(process, facets, version.getJspPackage());
        }
        return PositionManagersFactory.getInstance().createJSR45PositionManager(process, facets, version.getJspPackage());
    }

    public boolean undeployBeforeDeploy() {
        return false;
    }

    public void updateChangedFiles(Set<String> changedFilesPaths) {
        this.getProfileHandler().updateChangedFiles(changedFilesPaths);
    }

    public int getLocalPort() {
        return this.getProfileHandler().getLocalHttpPort();
    }

    protected int getServerPort() {
        return this.getProfileHandler().getServerPort();
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.createValidProfileHandler();
        for (DeploymentModel model : this.getCommonModel().getDeploymentModels()) {
            WebSphereDeploymentModel deploymentModel = (WebSphereDeploymentModel)model;
            if (deploymentModel.isContextValid()) continue;
            throw new RuntimeConfigurationWarning(WebSphereBundle.message("warning.configuration.nondefault.context.root", new Object[0]));
        }
    }

    public boolean isPingSupported() {
        return !this.isLibertyProfile();
    }

    public String getServerSpecificContext(DeploymentModel model) {
        Artifact artifact = model.getArtifact();
        if (this.isLibertyProfile() && artifact != null && WebArtifactUtil.getInstance().isWebApplication(artifact.getArtifactType())) {
            return WebSphereModel.getLibertyDeploymentId(model);
        }
        return super.getServerSpecificContext(model);
    }

    public static String getLibertyDeploymentId(DeploymentModel model) {
        return JavaeeDeploymentProvider.getDefaultDeploymentName((DeploymentModel)model);
    }

    public CompileScope getCompileScope(@NotNull CompileScope baseScope) {
        if (baseScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseScope", "com/intellij/j2ee/webSphere/runDebug/configuration/WebSphereModel", "getCompileScope"));
        }
        List<Artifact> artifacts = this.getCommonModel().getDeploymentModels().stream().filter(deploymentModel -> deploymentModel.getDeploymentSource() instanceof LooseApplicationDeploymentSource).map(DeploymentModel::getArtifact).collect(Collectors.toList());
        return ContainerUtil.isEmpty(artifacts) ? baseScope : WebSphereBuildLooseAppsBeforeRunTaskProvider.setupLooseAppsCompileScope(baseScope, artifacts);
    }
}

