/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.uibuilder.mockup.editor.AnimatedComponentSplitter;
import com.android.tools.idea.uibuilder.mockup.editor.MockupEditor;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import icons.AndroidIcons;
import java.awt.Dimension;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MockupToggleAction
extends ToggleAction {
    public static final Dimension CLOSED_DIMENSION = new Dimension(0, 0);
    public static final Dimension OPEN_DIMENSION = new Dimension(200, 200);
    private final DesignSurface mySurface;
    private static final String SHOW_ACTION_TITLE = "Show Mockup Editor";
    private static final String HIDE_ACTION_TITLE = "Hide Mockup Editor";

    public MockupToggleAction(@NotNull DesignSurface surface) {
        if (surface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/actions/MockupToggleAction", "<init>"));
        }
        this.mySurface = surface;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(MockupToggleAction.getDesignIcon());
        presentation.setDescription(this.getDescription());
    }

    @NotNull
    private String getDescription() {
        String string = this.mySurface.isCanvasResizing() ? HIDE_ACTION_TITLE : SHOW_ACTION_TITLE;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/actions/MockupToggleAction", "getDescription"));
        }
        return string;
    }

    private static Icon getDesignIcon() {
        return AndroidIcons.Mockup.Mockup;
    }

    public boolean isSelected(AnActionEvent e) {
        return this.mySurface.isMockupVisible();
    }

    public void setSelected(AnActionEvent e, boolean state) {
        this.getTemplatePresentation().setEnabled(state);
        this.mySurface.setMockupVisible(state);
        MockupEditor mockupEditor = this.mySurface.getMockupEditor();
        if (mockupEditor != null) {
            if (mockupEditor.getParent() instanceof AnimatedComponentSplitter) {
                mockupEditor.setMaximumSize(state ? OPEN_DIMENSION : CLOSED_DIMENSION);
                AnimatedComponentSplitter animatedComponentSplitter = (AnimatedComponentSplitter)((Object)mockupEditor.getParent());
                animatedComponentSplitter.showAnimateChild(mockupEditor, state);
                animatedComponentSplitter.setDividerMouseZoneSize(state ? 1 : 0);
                animatedComponentSplitter.setDividerWidth(state ? 1 : 0);
            } else {
                mockupEditor.setSize(this.mySurface.getWidth() / 3, this.mySurface.getHeight());
            }
        }
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/actions/MockupToggleAction", "update"));
        }
        event.getPresentation().setEnabledAndVisible(false);
        event.getPresentation().setIcon(MockupToggleAction.getDesignIcon());
        this.getTemplatePresentation().setDescription(this.getDescription());
    }
}

