/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.assistant.view.TutorialButton;
import com.android.tools.idea.assistant.view.UIUtils;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;

public class FeatureEntryPoint
extends JPanel {
    private boolean myExpanded;
    private JPanel myTutorialsList;
    private ActionListener myListener;
    private JLabel myArrow;
    private JPanel myTargetPane;
    private AnalyticsProvider myAnalyticsProvider;
    private FeatureData myFeature;
    private Project myProject;

    public FeatureEntryPoint(@NotNull FeatureData feature, @NotNull ActionListener listener, @NotNull AnalyticsProvider analyticsProvider, @NotNull Project project) {
        if (feature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "feature", "com/android/tools/idea/assistant/view/FeatureEntryPoint", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/assistant/view/FeatureEntryPoint", "<init>"));
        }
        if (analyticsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyticsProvider", "com/android/tools/idea/assistant/view/FeatureEntryPoint", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/assistant/view/FeatureEntryPoint", "<init>"));
        }
        super((LayoutManager)new VerticalFlowLayout(0, 0));
        this.myExpanded = false;
        this.setOpaque(false);
        this.myListener = listener;
        this.myAnalyticsProvider = analyticsProvider;
        this.myFeature = feature;
        this.myProject = project;
        String label = this.myFeature.getName();
        String description = this.myFeature.getDescription();
        this.myTargetPane = new JPanel();
        this.myTargetPane.setOpaque(false);
        this.myTargetPane.setLayout(new BoxLayout(this.myTargetPane, 0));
        this.add(this.myTargetPane);
        SummaryHandler summaryMouseHandler = new SummaryHandler();
        this.myArrow = new JLabel();
        this.myArrow.addMouseListener(summaryMouseHandler);
        this.myArrow.setIcon(AllIcons.Nodes.TreeRightArrow);
        this.myArrow.setFocusable(true);
        this.myArrow.setBorder(BorderFactory.createEmptyBorder(9, 5, 0, 10));
        this.myArrow.setAlignmentY(0.0f);
        this.myTargetPane.add(this.myArrow);
        JPanel summary = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
        summary.setOpaque(false);
        summary.setAlignmentY(0.0f);
        this.myTargetPane.add(summary);
        int innerContentsOffset = 0;
        JBLabel featureLabel = new JBLabel();
        featureLabel.addMouseListener((MouseListener)summaryMouseHandler);
        featureLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        featureLabel.setFont(featureLabel.getFont().deriveFont(1));
        featureLabel.setText(label);
        Icon featureIcon = this.myFeature.getIcon();
        if (featureIcon != null) {
            featureLabel.setIcon(featureIcon);
            featureLabel.setIconTextGap(5);
            innerContentsOffset += featureIcon.getIconWidth() + featureLabel.getIconTextGap();
        }
        summary.add((Component)featureLabel);
        JTextPane descriptionPane = new JTextPane();
        descriptionPane.setOpaque(false);
        descriptionPane.addMouseListener(summaryMouseHandler);
        UIUtils.setHtml(descriptionPane, description, "body {color: " + UIUtils.getCssColor(UIUtils.getSecondaryColor()) + "}");
        descriptionPane.setBorder(BorderFactory.createEmptyBorder(0, innerContentsOffset, 5, 10));
        summary.add(descriptionPane);
        this.myTutorialsList = new JPanel();
        this.myTutorialsList.setOpaque(false);
        this.myTutorialsList.setLayout(new BoxLayout(this.myTutorialsList, 1));
        this.myTutorialsList.setBorder(BorderFactory.createEmptyBorder(5, this.myArrow.getPreferredSize().width + innerContentsOffset, 0, 5));
        this.myTutorialsList.setVisible(false);
        for (TutorialData tutorialData : this.myFeature.getTutorials()) {
            this.addTutorial(tutorialData.getLabel(), tutorialData.getKey());
        }
        this.add(this.myTutorialsList);
    }

    private static Logger getLog() {
        return Logger.getInstance(FeatureEntryPoint.class);
    }

    private void addTutorial(String label, String key) {
        TutorialButton t = new TutorialButton(label, key, this.myListener);
        this.myTutorialsList.add(t);
        this.myTutorialsList.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    private void toggleTutorials() {
        this.myExpanded = !this.myExpanded;
        FeatureEntryPoint.getLog().debug("Toggled feature summary view to expand state: " + this.myExpanded);
        if (this.myExpanded) {
            this.myAnalyticsProvider.trackFeatureGroupExpanded(this.myFeature.getName(), this.myProject);
        }
        this.myArrow.setIcon(this.myExpanded ? AllIcons.Nodes.TreeDownArrow : AllIcons.Nodes.TreeRightArrow);
        this.myTutorialsList.setVisible(this.myExpanded);
    }

    private class SummaryHandler
    extends MouseAdapter {
        private SummaryHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FeatureEntryPoint.this.toggleTutorials();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            FeatureEntryPoint.this.myTargetPane.setBackground(null);
            FeatureEntryPoint.this.myTargetPane.setOpaque(true);
            FeatureEntryPoint.this.myTargetPane.setBackground(UIUtils.getBackgroundHoverColor());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FeatureEntryPoint.this.myTargetPane.setOpaque(false);
            FeatureEntryPoint.this.myTargetPane.setBackground(null);
        }
    }
}

