/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.swing.ui.SwatchComponent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.annotations.NotNull;

public class ColorRendererEditor
extends GraphicalResourceRendererEditor {
    public ColorRendererEditor(@NotNull ThemeEditorContext context, @NotNull AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "<init>"));
        }
        if (previewPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previewPanel", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "<init>"));
        }
        super(context, previewPanel, isEditor);
    }

    @Override
    protected void updateComponent(@NotNull ThemeEditorContext context, @NotNull ResourceComponent component, @NotNull EditedStyleItem item) {
        SwatchComponent.SwatchIcon icon;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "updateComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "updateComponent"));
        }
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "updateComponent"));
        }
        ResourceResolver resourceResolver = context.getResourceResolver();
        assert (resourceResolver != null);
        List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)resourceResolver, (ResourceValue)item.getSelectedValue(), context.getProject());
        if (colors.isEmpty()) {
            icon = SwatchComponent.WARNING_ICON;
        } else {
            icon = new SwatchComponent.ColorIcon((Color)Iterables.getLast(colors));
            icon.setIsStack(colors.size() > 1);
        }
        component.setSwatchIcon(icon);
        component.setNameText(item.getQualifiedName());
        component.setValueText(item.getValue());
        if (!colors.isEmpty()) {
            Color color = (Color)Iterables.getLast(colors);
            String attributeName = item.getName();
            ImmutableMap<String, Color> contrastColorsWithDescription = ColorUtils.getContrastColorsWithDescription(context, attributeName);
            component.setWarning(ColorUtils.getContrastWarningMessage(contrastColorsWithDescription, color, ColorUtils.isBackgroundAttribute(attributeName)));
        } else {
            component.setWarning(null);
        }
    }

    @Override
    @NotNull
    protected EnumSet<ResourceType> getAllowedResourceTypes() {
        AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(this.myContext.getConfiguration(), this.myItem.getSelectedValue());
        String attributeName = this.myItem.getName().toLowerCase(Locale.ENGLISH);
        if (attributeName.contains("color") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Reference)) {
            EnumSet enumSet = COLORS_ONLY;
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "getAllowedResourceTypes"));
            }
            return enumSet;
        }
        if (attributeName.contains("drawable") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.Color)) {
            EnumSet enumSet = DRAWABLES_ONLY;
            if (enumSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "getAllowedResourceTypes"));
            }
            return enumSet;
        }
        EnumSet enumSet = COLORS_AND_DRAWABLES;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor", "getAllowedResourceTypes"));
        }
        return enumSet;
    }
}

