/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.debugger;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Location;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunPositionManager
extends PositionManagerImpl {
    private static final boolean DISABLED = true;
    private Map<AndroidVersion, VirtualFile> mySourceFoldersByApiLevel;

    public InstantRunPositionManager(DebugProcessImpl debugProcess) {
        super(debugProcess);
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project, Location location) {
        PsiFile file = super.getPsiFileByLocation(project, location);
        if (file == null) {
            return null;
        }
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return file;
        }
        if (!AndroidFacet.isInAndroidSdk((PsiElement)file)) {
            return file;
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (session == null) {
            return file;
        }
        String relPath = InstantRunPositionManager.getRelPathFromSourceRoot(project, file);
        if (relPath == null) {
            return file;
        }
        AndroidVersion version = (AndroidVersion)session.getDebugProcess().getProcessHandler().getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
        if (version == null) {
            return file;
        }
        PsiFile source = this.getSourceForApiLevel(project, version, relPath);
        return source == null ? file : source;
    }

    @Nullable
    private PsiFile getSourceForApiLevel(@NotNull Project project, @NotNull AndroidVersion version, @NotNull String relPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/debugger/InstantRunPositionManager", "getSourceForApiLevel"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/fd/debugger/InstantRunPositionManager", "getSourceForApiLevel"));
        }
        if (relPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relPath", "com/android/tools/idea/fd/debugger/InstantRunPositionManager", "getSourceForApiLevel"));
        }
        VirtualFile sourceFolder = this.getSourceFolder(version);
        if (sourceFolder == null) {
            return null;
        }
        VirtualFile vfile = sourceFolder.findFileByRelativePath(relPath);
        return vfile == null ? null : PsiManager.getInstance((Project)project).findFile(vfile);
    }

    @Nullable
    private VirtualFile getSourceFolder(@NotNull AndroidVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/fd/debugger/InstantRunPositionManager", "getSourceFolder"));
        }
        if (this.mySourceFoldersByApiLevel == null) {
            this.mySourceFoldersByApiLevel = InstantRunPositionManager.createSourcesByApiLevel();
        }
        return this.mySourceFoldersByApiLevel.get(version);
    }

    private static Map<AndroidVersion, VirtualFile> createSourcesByApiLevel() {
        Collection<? extends LocalPackage> sourcePackages = InstantRunPositionManager.getAllPlatformSourcePackages();
        HashMap sourcesByApi = Maps.newHashMap();
        for (LocalPackage localPackage : sourcePackages) {
            TypeDetails typeDetails = localPackage.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.ApiDetailsType)) {
                Logger.getInstance(InstantRunPositionManager.class).warn("Unable to get type details for source package @ " + localPackage.getLocation().getPath());
                continue;
            }
            DetailsTypes.ApiDetailsType details = (DetailsTypes.ApiDetailsType)typeDetails;
            AndroidVersion version = details.getAndroidVersion();
            VirtualFile sourceFolder = VfsUtil.findFileByIoFile((File)localPackage.getLocation(), (boolean)true);
            if (sourceFolder == null || !sourceFolder.isValid()) continue;
            sourcesByApi.put(version, sourceFolder);
        }
        return ImmutableMap.copyOf((Map)sourcesByApi);
    }

    private static Collection<? extends LocalPackage> getAllPlatformSourcePackages() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(InstantRunPositionManager.class));
        return sdkManager.getPackages().getLocalPackagesForPrefix("sources");
    }

    @Nullable
    private static String getRelPathFromSourceRoot(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/debugger/InstantRunPositionManager", "getRelPathFromSourceRoot"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/fd/debugger/InstantRunPositionManager", "getRelPathFromSourceRoot"));
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file.getVirtualFile());
        if (sourceRoot == null) {
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)file.getVirtualFile(), (VirtualFile)sourceRoot);
    }
}

