/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.common;

import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInitScripts {
    @NotNull
    private final ContentCreator myContentCreator;

    @NotNull
    public static GradleInitScripts getInstance() {
        GradleInitScripts gradleInitScripts = (GradleInitScripts)ServiceManager.getService(GradleInitScripts.class);
        if (gradleInitScripts == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/common/GradleInitScripts", "getInstance"));
        }
        return gradleInitScripts;
    }

    public GradleInitScripts() {
        this(new ContentCreator());
    }

    @VisibleForTesting
    GradleInitScripts(@NotNull ContentCreator contentCreator) {
        if (contentCreator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentCreator", "com/android/tools/idea/gradle/project/common/GradleInitScripts", "<init>"));
        }
        this.myContentCreator = contentCreator;
    }

    public void addLocalMavenRepoInitScriptCommandLineArgTo(@NotNull List<String> allArgs) {
        if (allArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allArgs", "com/android/tools/idea/gradle/project/common/GradleInitScripts", "addLocalMavenRepoInitScriptCommandLineArgTo"));
        }
        File initScriptFile = this.createLocalMavenRepoInitScriptFile();
        if (initScriptFile != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @VisibleForTesting
    @Nullable
    File createLocalMavenRepoInitScriptFile() {
        List<File> repoPaths = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
        String content = this.myContentCreator.createLocalMavenRepoInitScriptContent(repoPaths);
        if (content != null) {
            return GradleInitScripts.createInitScriptFile("asLocalRepo", content);
        }
        return null;
    }

    public void addProfilerClasspathInitScriptCommandLineArgTo(@NotNull List<String> allArgs) {
        if (allArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allArgs", "com/android/tools/idea/gradle/project/common/GradleInitScripts", "addProfilerClasspathInitScriptCommandLineArgTo"));
        }
        String content = "allprojects {\n  buildscript {\n    dependencies {\n      classpath 'com.android.tools:studio-profiler-plugin:1.0'\n    }\n  }\n}\n";
        File initScriptFile = GradleInitScripts.createInitScriptFile("asPerfClasspath", content);
        if (initScriptFile != null) {
            GradleInitScripts.addInitScriptCommandLineArg(initScriptFile, allArgs);
        }
    }

    @Nullable
    private static File createInitScriptFile(@NotNull String fileName, @NotNull String content) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/android/tools/idea/gradle/project/common/GradleInitScripts", "createInitScriptFile"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/android/tools/idea/gradle/project/common/GradleInitScripts", "createInitScriptFile"));
        }
        try {
            File file = FileUtil.createTempFile((String)fileName, (String)".gradle");
            file.deleteOnExit();
            FileUtil.writeToFile((File)file, (String)content);
            return file;
        }
        catch (Throwable e) {
            String message = String.format("Failed to set up  Gradle init script: '%1$s'", fileName);
            Logger.getInstance(GradleInitScripts.class).warn(message, e);
            return null;
        }
    }

    private static void addInitScriptCommandLineArg(@NotNull File initScriptFile, @NotNull List<String> allArgs) {
        if (initScriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initScriptFile", "com/android/tools/idea/gradle/project/common/GradleInitScripts", "addInitScriptCommandLineArg"));
        }
        if (allArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allArgs", "com/android/tools/idea/gradle/project/common/GradleInitScripts", "addInitScriptCommandLineArg"));
        }
        allArgs.add("--init-script");
        allArgs.add(initScriptFile.getAbsolutePath());
    }

    @VisibleForTesting
    static class ContentCreator {
        ContentCreator() {
        }

        @Nullable
        String createLocalMavenRepoInitScriptContent(@NotNull List<File> repoPaths) {
            if (repoPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPaths", "com/android/tools/idea/gradle/project/common/GradleInitScripts$ContentCreator", "createLocalMavenRepoInitScriptContent"));
            }
            if (repoPaths.isEmpty()) {
                return null;
            }
            String paths = "";
            for (File file : repoPaths) {
                String path = GradleImport.escapeGroovyStringLiteral(file.getPath());
                paths = paths + "      maven { url '" + path + "'}\n";
            }
            return "allprojects {\n  buildscript {\n    repositories {\n" + paths + "    }\n  }\n  repositories {\n" + paths + "  }\n}\n";
        }
    }
}

