/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.JavaCompileOptions;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.gradle.AndroidGradleClassJarProvider;
import com.android.tools.idea.gradle.project.build.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.model.AndroidModelFeatures;
import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ProxyUtil;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidModuleModel
implements AndroidModel,
ModuleModel {
    public static final String EXPLODED_AAR = "exploded-aar";
    private static final long serialVersionUID = 1L;
    private static final String[] TEST_ARTIFACT_NAMES = new String[]{"_unit_test_", "_android_test_"};
    @NotNull
    private ProjectSystemId myProjectSystemId;
    @NotNull
    private String myModuleName;
    @NotNull
    private File myRootDirPath;
    @NotNull
    private AndroidProject myAndroidProject;
    @NotNull
    private transient AndroidModelFeatures myFeatures;
    @Nullable
    private transient GradleVersion myModelVersion;
    @Nullable
    private transient CountDownLatch myProxyAndroidProjectLatch;
    @Nullable
    private AndroidProject myProxyAndroidProject;
    @NotNull
    private String mySelectedVariantName;
    private transient VirtualFile myRootDir;
    @Nullable
    private Boolean myOverridesManifestPackage;
    @Nullable
    private transient AndroidVersion myMinSdkVersion;
    @NotNull
    private Map<String, BuildTypeContainer> myBuildTypesByName;
    @NotNull
    private Map<String, ProductFlavorContainer> myProductFlavorsByName;
    @NotNull
    private Map<String, Variant> myVariantsByName;
    @NotNull
    private Set<File> myExtraGeneratedSourceFolders;
    private static final AndroidVersion NOT_SPECIFIED = new AndroidVersion(0, null);

    @Nullable
    public static AndroidModuleModel get(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "get"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? AndroidModuleModel.get(facet) : null;
    }

    @Nullable
    public static AndroidModuleModel get(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidFacet", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "get"));
        }
        AndroidModel androidModel = androidFacet.getAndroidModel();
        return androidModel instanceof AndroidModuleModel ? (AndroidModuleModel)androidModel : null;
    }

    public AndroidModuleModel(@NotNull String moduleName, @NotNull File rootDirPath, @NotNull AndroidProject androidProject, @NotNull String selectedVariantName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "<init>"));
        }
        if (rootDirPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDirPath", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "<init>"));
        }
        if (androidProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidProject", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "<init>"));
        }
        if (selectedVariantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedVariantName", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "<init>"));
        }
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.myProjectSystemId = GradleUtil.GRADLE_SYSTEM_ID;
        this.myModuleName = moduleName;
        this.myRootDirPath = rootDirPath;
        this.myAndroidProject = androidProject;
        this.parseAndSetModelVersion();
        this.myFeatures = new AndroidModelFeatures(this.myModelVersion);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.myProxyAndroidProjectLatch = new CountDownLatch(1);
            try {
                this.myProxyAndroidProject = ProxyUtil.reproxy(AndroidProject.class, this.myAndroidProject);
            }
            finally {
                this.myProxyAndroidProjectLatch.countDown();
            }
        });
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.mySelectedVariantName = this.findVariantToSelect(selectedVariantName);
    }

    private void populateBuildTypesByName() {
        for (BuildTypeContainer container : this.myAndroidProject.getBuildTypes()) {
            String name = container.getBuildType().getName();
            this.myBuildTypesByName.put(name, container);
        }
    }

    private void populateProductFlavorsByName() {
        for (ProductFlavorContainer container : this.myAndroidProject.getProductFlavors()) {
            String name = container.getProductFlavor().getName();
            this.myProductFlavorsByName.put(name, container);
        }
    }

    private void populateVariantsByName() {
        for (Variant variant : this.myAndroidProject.getVariants()) {
            this.myVariantsByName.put(variant.getName(), variant);
        }
    }

    @NotNull
    public Dependencies getSelectedMainCompileDependencies() {
        AndroidArtifact mainArtifact = this.getMainArtifact();
        Dependencies dependencies = GradleUtil.getDependencies((BaseArtifact)mainArtifact, this.getModelVersion());
        if (dependencies == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getSelectedMainCompileDependencies"));
        }
        return dependencies;
    }

    @Nullable
    public Dependencies getSelectedAndroidTestCompileDependencies() {
        AndroidArtifact androidTestArtifact = this.getAndroidTestArtifactInSelectedVariant();
        if (androidTestArtifact == null) {
            return null;
        }
        return GradleUtil.getDependencies((BaseArtifact)androidTestArtifact, this.getModelVersion());
    }

    @NotNull
    public AndroidModelFeatures getFeatures() {
        AndroidModelFeatures androidModelFeatures = this.myFeatures;
        if (androidModelFeatures == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getFeatures"));
        }
        return androidModelFeatures;
    }

    @Nullable
    public GradleVersion getModelVersion() {
        return this.myModelVersion;
    }

    @NotNull
    public AndroidArtifact getMainArtifact() {
        AndroidArtifact androidArtifact = this.getSelectedVariant().getMainArtifact();
        if (androidArtifact == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getMainArtifact"));
        }
        return androidArtifact;
    }

    @Override
    @NotNull
    public SourceProvider getDefaultSourceProvider() {
        SourceProvider sourceProvider = this.getAndroidProject().getDefaultConfig().getSourceProvider();
        if (sourceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getDefaultSourceProvider"));
        }
        return sourceProvider;
    }

    @Override
    @NotNull
    public List<SourceProvider> getActiveSourceProviders() {
        List<SourceProvider> list = this.getMainSourceProviders(this.mySelectedVariantName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getActiveSourceProviders"));
        }
        return list;
    }

    @NotNull
    public List<SourceProvider> getMainSourceProviders(@NotNull String variantName) {
        if (variantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getMainSourceProviders"));
        }
        Variant variant = this.myVariantsByName.get(variantName);
        if (variant == null) {
            AndroidModuleModel.getLogger().error("Unknown variant name '" + variantName + "' found in the module '" + this.myModuleName + "'");
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getMainSourceProviders"));
            }
            return immutableList;
        }
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        SourceProvider multiFlavorProvider = mainArtifact.getMultiFlavorSourceProvider();
        if (multiFlavorProvider != null) {
            providers.add(multiFlavorProvider);
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.add(buildType.getSourceProvider());
        SourceProvider variantProvider = mainArtifact.getVariantSourceProvider();
        if (variantProvider != null) {
            providers.add(variantProvider);
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getMainSourceProviders"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<SourceProvider> getTestSourceProviders(@NotNull Iterable<SourceProviderContainer> containers) {
        if (containers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containers", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestSourceProviders"));
        }
        Collection<SourceProvider> collection = AndroidModuleModel.getSourceProvidersForArtifacts(containers, TEST_ARTIFACT_NAMES);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestSourceProviders"));
        }
        return collection;
    }

    @Override
    @NotNull
    public List<SourceProvider> getTestSourceProviders() {
        List<SourceProvider> list = this.getTestSourceProviders(this.mySelectedVariantName, TEST_ARTIFACT_NAMES);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestSourceProviders"));
        }
        return list;
    }

    @NotNull
    public List<SourceProvider> getTestSourceProviders(@NotNull String artifactName) {
        if (artifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestSourceProviders"));
        }
        List<SourceProvider> list = this.getTestSourceProviders(this.mySelectedVariantName, artifactName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestSourceProviders"));
        }
        return list;
    }

    @NotNull
    public List<SourceProvider> getTestSourceProviders(@NotNull String variantName, String ... testArtifactNames) {
        if (variantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestSourceProviders"));
        }
        if (testArtifactNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testArtifactNames", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestSourceProviders"));
        }
        AndroidModuleModel.validateTestArtifactNames(testArtifactNames);
        ArrayList providers = Lists.newArrayList();
        Collection extraSourceProviders = this.getAndroidProject().getDefaultConfig().getExtraSourceProviders();
        providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(extraSourceProviders, testArtifactNames));
        Variant variant = this.myVariantsByName.get(variantName);
        assert (variant != null);
        for (String flavor : variant.getProductFlavors()) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(productFlavor.getExtraSourceProviders(), testArtifactNames));
        }
        BuildTypeContainer buildType = this.findBuildType(variant.getBuildType());
        assert (buildType != null);
        providers.addAll(AndroidModuleModel.getSourceProvidersForArtifacts(buildType.getExtraSourceProviders(), testArtifactNames));
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestSourceProviders"));
        }
        return arrayList;
    }

    private static void validateTestArtifactNames(@NotNull String[] testArtifactNames) {
        if (testArtifactNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testArtifactNames", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "validateTestArtifactNames"));
        }
        for (String name : testArtifactNames) {
            if (AndroidModuleModel.isTestArtifact(name)) continue;
            String msg = String.format("'%1$s' is not a test artifact", name);
            throw new IllegalArgumentException(msg);
        }
    }

    @NotNull
    public Collection<BaseArtifact> getTestArtifactsInSelectedVariant() {
        Collection<BaseArtifact> collection = AndroidModuleModel.getTestArtifacts(this.getSelectedVariant());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestArtifactsInSelectedVariant"));
        }
        return collection;
    }

    @NotNull
    public static Collection<BaseArtifact> getTestArtifacts(@NotNull Variant variant) {
        if (variant == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestArtifacts"));
        }
        HashSet testArtifacts = Sets.newHashSet();
        for (BaseArtifact artifact : variant.getExtraAndroidArtifacts()) {
            if (!AndroidModuleModel.isTestArtifact(artifact)) continue;
            testArtifacts.add(artifact);
        }
        for (BaseArtifact artifact : variant.getExtraJavaArtifacts()) {
            if (!AndroidModuleModel.isTestArtifact(artifact)) continue;
            testArtifacts.add(artifact);
        }
        HashSet hashSet = testArtifacts;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getTestArtifacts"));
        }
        return hashSet;
    }

    @Nullable
    public AndroidArtifact getAndroidTestArtifactInSelectedVariant() {
        for (AndroidArtifact artifact : this.getSelectedVariant().getExtraAndroidArtifacts()) {
            if (!AndroidModuleModel.isTestArtifact((BaseArtifact)artifact)) continue;
            return artifact;
        }
        return null;
    }

    @Nullable
    public JavaArtifact getUnitTestArtifactInSelectedVariant() {
        for (JavaArtifact artifact : this.getSelectedVariant().getExtraJavaArtifacts()) {
            if (!AndroidModuleModel.isTestArtifact((BaseArtifact)artifact)) continue;
            return artifact;
        }
        return null;
    }

    public static boolean isTestArtifact(@NotNull BaseArtifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "isTestArtifact"));
        }
        String artifactName = artifact.getName();
        return AndroidModuleModel.isTestArtifact(artifactName);
    }

    private static boolean isTestArtifact(@Nullable String artifactName) {
        return ArrayUtil.contains((String)artifactName, (String[])TEST_ARTIFACT_NAMES);
    }

    @Override
    @NotNull
    public List<SourceProvider> getAllSourceProviders() {
        Collection variants = this.myAndroidProject.getVariants();
        ArrayList providers = Lists.newArrayList();
        providers.add(this.getDefaultSourceProvider());
        Collection flavors = this.myAndroidProject.getProductFlavors();
        for (ProductFlavorContainer pfc : flavors) {
            providers.add(pfc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getMultiFlavorSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        Collection buildTypes = this.myAndroidProject.getBuildTypes();
        for (BuildTypeContainer btc : buildTypes) {
            providers.add(btc.getSourceProvider());
        }
        for (Variant v : variants) {
            SourceProvider provider = v.getMainArtifact().getVariantSourceProvider();
            if (provider == null) continue;
            providers.add(provider);
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getAllSourceProviders"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        String string = this.getSelectedVariant().getMainArtifact().getApplicationId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getApplicationId"));
        }
        return string;
    }

    @Override
    @NotNull
    public Set<String> getAllApplicationIds() {
        HashSet ids = Sets.newHashSet();
        for (Variant v : this.myAndroidProject.getVariants()) {
            String applicationId = v.getMergedFlavor().getApplicationId();
            if (applicationId == null) continue;
            ids.add(applicationId);
        }
        HashSet hashSet = ids;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getAllApplicationIds"));
        }
        return hashSet;
    }

    @Override
    public Boolean isDebuggable() {
        BuildTypeContainer buildTypeContainer = this.findBuildType(this.getSelectedVariant().getBuildType());
        if (buildTypeContainer != null) {
            return buildTypeContainer.getBuildType().isDebuggable();
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getMinSdkVersion() {
        if (this.myMinSdkVersion == null) {
            ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
            if (minSdkVersion != null && minSdkVersion.getCodename() != null) {
                ApiVersion defaultConfigVersion = this.getAndroidProject().getDefaultConfig().getProductFlavor().getMinSdkVersion();
                if (defaultConfigVersion != null) {
                    minSdkVersion = defaultConfigVersion;
                }
                List flavors = this.getSelectedVariant().getProductFlavors();
                for (String flavor : flavors) {
                    ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                    assert (productFlavor != null);
                    ApiVersion flavorVersion = productFlavor.getProductFlavor().getMinSdkVersion();
                    if (flavorVersion == null) continue;
                    minSdkVersion = flavorVersion;
                    break;
                }
            }
            this.myMinSdkVersion = minSdkVersion != null ? LintUtils.convertVersion((ApiVersion)minSdkVersion, null) : NOT_SPECIFIED;
        }
        return this.myMinSdkVersion != NOT_SPECIFIED ? this.myMinSdkVersion : null;
    }

    @Override
    @Nullable
    public AndroidVersion getRuntimeMinSdkVersion() {
        ApiVersion minSdkVersion = this.getSelectedVariant().getMergedFlavor().getMinSdkVersion();
        if (minSdkVersion != null) {
            return new AndroidVersion(minSdkVersion.getApiLevel(), minSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    @Nullable
    public AndroidVersion getTargetSdkVersion() {
        ApiVersion targetSdkVersion = this.getSelectedVariant().getMergedFlavor().getTargetSdkVersion();
        if (targetSdkVersion != null) {
            return new AndroidVersion(targetSdkVersion.getApiLevel(), targetSdkVersion.getCodename());
        }
        return null;
    }

    @Override
    @Nullable
    public Integer getVersionCode() {
        Variant variant = this.getSelectedVariant();
        ProductFlavor flavor = variant.getMergedFlavor();
        return flavor.getVersionCode();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        ProjectSystemId projectSystemId = this.myProjectSystemId;
        if (projectSystemId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getProjectSystemId"));
        }
        return projectSystemId;
    }

    @Nullable
    public BuildTypeContainer findBuildType(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "findBuildType"));
        }
        return this.myBuildTypesByName.get(name);
    }

    @NotNull
    public Set<String> getBuildTypes() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getBuildTypes"));
        }
        return set;
    }

    @NotNull
    public Set<String> getProductFlavors() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getProductFlavors"));
        }
        return set;
    }

    @Nullable
    public ProductFlavorContainer findProductFlavor(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "findProductFlavor"));
        }
        return this.myProductFlavorsByName.get(name);
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getModuleName"));
        }
        return string;
    }

    @Override
    @NotNull
    public File getRootDirPath() {
        File file = this.myRootDirPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getRootDirPath"));
        }
        return file;
    }

    @Override
    @NotNull
    public VirtualFile getRootDir() {
        if (this.myRootDir == null) {
            VirtualFile found = VfsUtil.findFileByIoFile((File)this.myRootDirPath, (boolean)true);
            assert (found != null);
            this.myRootDir = found;
        }
        VirtualFile virtualFile = this.myRootDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getRootDir"));
        }
        return virtualFile;
    }

    @Override
    public boolean isGenerated(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "isGenerated"));
        }
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)this.myAndroidProject.getBuildFolder(), (boolean)false);
        return buildFolder != null && VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }

    @NotNull
    public AndroidProject getAndroidProject() {
        AndroidProject androidProject = this.myAndroidProject;
        if (androidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getAndroidProject"));
        }
        return androidProject;
    }

    @NotNull
    public AndroidProject waitForAndGetProxyAndroidProject() {
        this.waitForProxyAndroidProject();
        assert (this.myProxyAndroidProject != null);
        AndroidProject androidProject = this.myProxyAndroidProject;
        if (androidProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "waitForAndGetProxyAndroidProject"));
        }
        return androidProject;
    }

    public void waitForProxyAndroidProject() {
        if (this.myProxyAndroidProjectLatch != null) {
            try {
                this.myProxyAndroidProjectLatch.await();
            }
            catch (InterruptedException e) {
                AndroidModuleModel.getLogger().error((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(AndroidModuleModel.class);
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getLogger"));
        }
        return logger;
    }

    @NotNull
    public Variant getSelectedVariant() {
        Variant selected = this.myVariantsByName.get(this.mySelectedVariantName);
        assert (selected != null);
        Variant variant = selected;
        if (variant == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getSelectedVariant"));
        }
        return variant;
    }

    @Nullable
    public Variant findVariantByName(@NotNull String variantName) {
        if (variantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "findVariantByName"));
        }
        return this.myVariantsByName.get(variantName);
    }

    public void setSelectedVariantName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "setSelectedVariantName"));
        }
        this.mySelectedVariantName = this.findVariantToSelect(name);
        this.myOverridesManifestPackage = null;
        this.myMinSdkVersion = null;
    }

    @NotNull
    private String findVariantToSelect(@NotNull String variantName) {
        String newVariantName;
        if (variantName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variantName", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "findVariantToSelect"));
        }
        Collection<String> variantNames = this.getVariantNames();
        if (variantNames.contains(variantName)) {
            newVariantName = variantName;
        } else {
            ArrayList sorted = Lists.newArrayList(variantNames);
            Collections.sort(sorted);
            newVariantName = (String)sorted.get(0);
        }
        String string = newVariantName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "findVariantToSelect"));
        }
        return string;
    }

    @NotNull
    private static Collection<SourceProvider> getSourceProvidersForArtifacts(@NotNull Iterable<SourceProviderContainer> containers, String ... artifactNames) {
        if (containers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containers", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getSourceProvidersForArtifacts"));
        }
        if (artifactNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactNames", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getSourceProvidersForArtifacts"));
        }
        HashSet providers = Sets.newHashSet();
        block0: for (SourceProviderContainer container : containers) {
            for (String artifactName : artifactNames) {
                if (!artifactName.equals(container.getArtifactName())) continue;
                providers.add(container.getSourceProvider());
                continue block0;
            }
        }
        HashSet hashSet = providers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getSourceProvidersForArtifacts"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getBuildTypeNames() {
        Set<String> set = this.myBuildTypesByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getBuildTypeNames"));
        }
        return set;
    }

    @NotNull
    public Collection<String> getProductFlavorNames() {
        Set<String> set = this.myProductFlavorsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getProductFlavorNames"));
        }
        return set;
    }

    @NotNull
    public Collection<String> getVariantNames() {
        Set<String> set = this.myVariantsByName.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getVariantNames"));
        }
        return set;
    }

    @Nullable
    public LanguageLevel getJavaLanguageLevel() {
        JavaCompileOptions compileOptions = this.myAndroidProject.getJavaCompileOptions();
        String sourceCompatibility = compileOptions.getSourceCompatibility();
        return LanguageLevel.parse((String)sourceCompatibility);
    }

    public int getProjectType() {
        try {
            return this.getAndroidProject().getProjectType();
        }
        catch (UnsupportedMethodException e) {
            return this.getAndroidProject().isLibrary() ? 1 : 0;
        }
    }

    @Override
    public boolean overridesManifestPackage() {
        if (this.myOverridesManifestPackage == null) {
            this.myOverridesManifestPackage = this.getAndroidProject().getDefaultConfig().getProductFlavor().getApplicationId() != null;
            Variant variant = this.getSelectedVariant();
            List flavors = variant.getProductFlavors();
            for (String flavor : flavors) {
                ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
                assert (productFlavor != null);
                if (productFlavor.getProductFlavor().getApplicationId() == null) continue;
                this.myOverridesManifestPackage = true;
                break;
            }
        }
        return this.myOverridesManifestPackage;
    }

    public void registerExtraGeneratedSourceFolder(@NotNull File folderPath) {
        if (folderPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folderPath", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "registerExtraGeneratedSourceFolder"));
        }
        this.myExtraGeneratedSourceFolders.add(folderPath);
    }

    @NotNull
    public List<File> getExcludedFolderPaths() {
        File buildFolderPath = this.getAndroidProject().getBuildFolder();
        ArrayList excludedFolderPaths = Lists.newArrayList();
        if (buildFolderPath.isDirectory()) {
            for (File folderPath : FileUtil.notNullize((File[])buildFolderPath.listFiles())) {
                String folderName = folderPath.getName();
                if (folderName.equals("intermediates") || folderName.equals("generated")) continue;
                excludedFolderPaths.add(folderPath);
            }
            File intermediates = new File(buildFolderPath, "intermediates");
            if (intermediates.isDirectory()) {
                for (File folderPath : FileUtil.notNullize((File[])intermediates.listFiles())) {
                    String folderName = folderPath.getName();
                    if (folderName.equals(EXPLODED_AAR) || folderName.equals("manifest")) continue;
                    excludedFolderPaths.add(folderPath);
                }
            }
        } else {
            excludedFolderPaths.add(new File(buildFolderPath, "outputs"));
            excludedFolderPaths.add(new File(buildFolderPath, "tmp"));
        }
        ArrayList arrayList = excludedFolderPaths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getExcludedFolderPaths"));
        }
        return arrayList;
    }

    @NotNull
    public File[] getExtraGeneratedSourceFolderPaths() {
        File[] fileArray = this.myExtraGeneratedSourceFolders.toArray(new File[this.myExtraGeneratedSourceFolders.size()]);
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getExtraGeneratedSourceFolderPaths"));
        }
        return fileArray;
    }

    @Nullable
    public Collection<SyncIssue> getSyncIssues() {
        if (this.getFeatures().isIssueReportingSupported()) {
            return this.myAndroidProject.getSyncIssues();
        }
        return null;
    }

    @Nullable
    public SourceFileContainerInfo containsSourceFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "containsSourceFile"));
        }
        ProductFlavorContainer defaultConfig = this.myAndroidProject.getDefaultConfig();
        if (AndroidModuleModel.containsSourceFile(defaultConfig, file)) {
            return new SourceFileContainerInfo();
        }
        for (Variant variant : this.myAndroidProject.getVariants()) {
            AndroidArtifact artifact = variant.getMainArtifact();
            if (AndroidModuleModel.containsSourceFile((BaseArtifact)artifact, file)) {
                return new SourceFileContainerInfo(variant, (BaseArtifact)artifact);
            }
            for (AndroidArtifact extraArtifact : variant.getExtraAndroidArtifacts()) {
                if (!AndroidModuleModel.containsSourceFile((BaseArtifact)extraArtifact, file)) continue;
                return new SourceFileContainerInfo(variant, (BaseArtifact)extraArtifact);
            }
            String buildTypeName = variant.getBuildType();
            BuildTypeContainer buildTypeContainer = this.findBuildType(buildTypeName);
            if (buildTypeContainer != null) {
                if (AndroidModuleModel.containsFile(buildTypeContainer.getSourceProvider(), file)) {
                    return new SourceFileContainerInfo(variant);
                }
                for (SourceProviderContainer extraSourceProvider : buildTypeContainer.getExtraSourceProviders()) {
                    if (!AndroidModuleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
                    return new SourceFileContainerInfo(variant);
                }
            }
            for (String flavorName : variant.getProductFlavors()) {
                ProductFlavorContainer flavor = this.findProductFlavor(flavorName);
                if (flavor == null || !AndroidModuleModel.containsSourceFile(flavor, file)) continue;
                return new SourceFileContainerInfo(variant);
            }
        }
        return null;
    }

    private static boolean containsSourceFile(@NotNull ProductFlavorContainer flavorContainer, @NotNull File file) {
        if (flavorContainer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavorContainer", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "containsSourceFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "containsSourceFile"));
        }
        if (AndroidModuleModel.containsFile(flavorContainer.getSourceProvider(), file)) {
            return true;
        }
        for (SourceProviderContainer extraSourceProvider : flavorContainer.getExtraSourceProviders()) {
            if (!AndroidModuleModel.containsFile(extraSourceProvider.getSourceProvider(), file)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsSourceFile(@NotNull BaseArtifact artifact, @NotNull File file) {
        AndroidArtifact androidArtifact;
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "containsSourceFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "containsSourceFile"));
        }
        if (artifact instanceof AndroidArtifact && (AndroidModuleModel.containsFile(GradleUtil.getGeneratedSourceFolders((BaseArtifact)(androidArtifact = (AndroidArtifact)artifact)), file) || AndroidModuleModel.containsFile(androidArtifact.getGeneratedResourceFolders(), file))) {
            return true;
        }
        SourceProvider sourceProvider = artifact.getVariantSourceProvider();
        if (sourceProvider != null && AndroidModuleModel.containsFile(sourceProvider, file)) {
            return true;
        }
        sourceProvider = artifact.getMultiFlavorSourceProvider();
        return sourceProvider != null && AndroidModuleModel.containsFile(sourceProvider, file);
    }

    private static boolean containsFile(@NotNull SourceProvider sourceProvider, @NotNull File file) {
        if (sourceProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceProvider", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "containsFile"));
        }
        return AndroidModuleModel.containsFile(sourceProvider.getAidlDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getAssetsDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getCDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getCppDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getJavaDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getRenderscriptDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getResDirectories(), file) || AndroidModuleModel.containsFile(sourceProvider.getResourcesDirectories(), file);
    }

    private static boolean containsFile(@NotNull Collection<File> directories, @NotNull File file) {
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "containsFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "containsFile"));
        }
        for (File directory : directories) {
            if (!FileUtil.isAncestor((File)directory, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.waitForProxyAndroidProject();
        out.writeObject(this.myProjectSystemId);
        out.writeObject(this.myModuleName);
        out.writeObject(this.myRootDirPath);
        out.writeObject(this.myProxyAndroidProject);
        out.writeObject(this.mySelectedVariantName);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myProjectSystemId = (ProjectSystemId)in.readObject();
        this.myModuleName = (String)in.readObject();
        this.myRootDirPath = (File)in.readObject();
        this.myAndroidProject = (AndroidProject)in.readObject();
        this.parseAndSetModelVersion();
        this.myFeatures = new AndroidModelFeatures(this.myModelVersion);
        this.myProxyAndroidProject = this.myAndroidProject;
        this.myBuildTypesByName = Maps.newHashMap();
        this.myProductFlavorsByName = Maps.newHashMap();
        this.myVariantsByName = Maps.newHashMap();
        this.myExtraGeneratedSourceFolders = Sets.newHashSet();
        this.populateBuildTypesByName();
        this.populateProductFlavorsByName();
        this.populateVariantsByName();
        this.setSelectedVariantName((String)in.readObject());
    }

    private void parseAndSetModelVersion() {
        this.myModelVersion = GradleVersion.tryParse((String)this.myAndroidProject.getModelVersion());
    }

    @NotNull
    public SourceProvider getBuildTypeSourceProvider() {
        Variant selectedVariant = this.getSelectedVariant();
        BuildTypeContainer buildType = this.findBuildType(selectedVariant.getBuildType());
        assert (buildType != null);
        SourceProvider sourceProvider = buildType.getSourceProvider();
        if (sourceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getBuildTypeSourceProvider"));
        }
        return sourceProvider;
    }

    @NotNull
    public List<SourceProvider> getFlavorSourceProviders() {
        Variant selectedVariant = this.getSelectedVariant();
        List productFlavors = selectedVariant.getProductFlavors();
        ArrayList providers = Lists.newArrayList();
        for (String flavor : productFlavors) {
            ProductFlavorContainer productFlavor = this.findProductFlavor(flavor);
            assert (productFlavor != null);
            providers.add(productFlavor.getSourceProvider());
        }
        ArrayList arrayList = providers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getFlavorSourceProviders"));
        }
        return arrayList;
    }

    public void syncSelectedVariantAndTestArtifact(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "syncSelectedVariantAndTestArtifact"));
        }
        Variant variant = this.getSelectedVariant();
        JpsAndroidModuleProperties state = facet.getProperties();
        state.SELECTED_BUILD_VARIANT = variant.getName();
        AndroidArtifact mainArtifact = variant.getMainArtifact();
        AndroidModuleModel.updateGradleTaskNames(state, mainArtifact, null);
    }

    @VisibleForTesting
    static void updateGradleTaskNames(@NotNull JpsAndroidModuleProperties state, @NotNull AndroidArtifact mainArtifact, @Nullable BaseArtifact testArtifact) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "updateGradleTaskNames"));
        }
        if (mainArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainArtifact", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "updateGradleTaskNames"));
        }
        state.ASSEMBLE_TASK_NAME = mainArtifact.getAssembleTaskName();
        state.COMPILE_JAVA_TASK_NAME = mainArtifact.getCompileTaskName();
        state.AFTER_SYNC_TASK_NAMES = Sets.newHashSet(AndroidModuleModel.getIdeSetupTasks((BaseArtifact)mainArtifact));
        if (testArtifact != null) {
            state.ASSEMBLE_TEST_TASK_NAME = testArtifact.getAssembleTaskName();
            state.COMPILE_JAVA_TEST_TASK_NAME = testArtifact.getCompileTaskName();
            state.AFTER_SYNC_TASK_NAMES.addAll(AndroidModuleModel.getIdeSetupTasks(testArtifact));
        } else {
            state.ASSEMBLE_TEST_TASK_NAME = "";
            state.COMPILE_JAVA_TEST_TASK_NAME = "";
        }
    }

    @NotNull
    public static Set<String> getIdeSetupTasks(@NotNull BaseArtifact artifact) {
        block9: {
            Set set;
            if (artifact == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getIdeSetupTasks"));
            }
            try {
                set = artifact.getIdeSetupTaskNames();
            }
            catch (NoSuchMethodError e) {
                if (artifact instanceof AndroidArtifact) {
                    HashSet hashSet = Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
                    if (hashSet == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getIdeSetupTasks"));
                    }
                    return hashSet;
                }
            }
            catch (UnsupportedMethodException e) {
                if (!(artifact instanceof AndroidArtifact)) break block9;
                HashSet hashSet = Sets.newHashSet((Object[])new String[]{((AndroidArtifact)artifact).getSourceGenTaskName()});
                if (hashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getIdeSetupTasks"));
                }
                return hashSet;
            }
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getIdeSetupTasks"));
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getIdeSetupTasks"));
        }
        return set;
    }

    @Nullable
    public SourceProvider getMultiFlavorSourceProvider() {
        AndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getMultiFlavorSourceProvider();
    }

    @Nullable
    public SourceProvider getVariantSourceProvider() {
        AndroidArtifact mainArtifact = this.getSelectedVariant().getMainArtifact();
        return mainArtifact.getVariantSourceProvider();
    }

    @Override
    public boolean getDataBindingEnabled() {
        return GradleUtil.dependsOn(this, "com.android.databinding:library");
    }

    @Override
    @NotNull
    public ClassJarProvider getClassJarProvider() {
        AndroidGradleClassJarProvider androidGradleClassJarProvider = new AndroidGradleClassJarProvider();
        if (androidGradleClassJarProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getClassJarProvider"));
        }
        return androidGradleClassJarProvider;
    }

    @Override
    @Nullable
    public Long getLastBuildTimestamp(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/model/AndroidModuleModel", "getLastBuildTimestamp"));
        }
        return PostProjectBuildTasksExecutor.getInstance(project).getLastBuildTimestamp();
    }

    public static class SourceFileContainerInfo {
        @Nullable
        public final Variant variant;
        @Nullable
        public final BaseArtifact artifact;

        SourceFileContainerInfo() {
            this(null);
        }

        SourceFileContainerInfo(@Nullable Variant variant) {
            this(variant, null);
        }

        SourceFileContainerInfo(@Nullable Variant variant, @Nullable BaseArtifact artifact) {
            this.variant = variant;
            this.artifact = artifact;
        }

        public void updateSelectedVariantIn(@NotNull DataNode<ModuleData> moduleNode) {
            DataNode androidProjectNode;
            if (moduleNode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleNode", "com/android/tools/idea/gradle/project/model/AndroidModuleModel$SourceFileContainerInfo", "updateSelectedVariantIn"));
            }
            if (this.variant != null && (androidProjectNode = ExternalSystemApiUtil.find(moduleNode, AndroidProjectKeys.ANDROID_MODEL)) != null) {
                ((AndroidModuleModel)androidProjectNode.getData()).setSelectedVariantName(this.variant.getName());
            }
        }
    }
}

