/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncAction
implements BuildAction<ProjectModels>,
Serializable {
    @NotNull
    private final Collection<Class<?>> myModelTypes;

    public SyncAction(@NotNull Collection<Class<?>> modelTypes) {
        if (modelTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelTypes", "com/android/tools/idea/gradle/project/sync/SyncAction", "<init>"));
        }
        this.myModelTypes = new HashSet();
        this.myModelTypes.addAll(modelTypes);
    }

    @Nullable
    public ProjectModels execute(@NotNull BuildController controller) {
        if (controller == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/android/tools/idea/gradle/project/sync/SyncAction", "execute"));
        }
        IdeaProject project = (IdeaProject)controller.getModel(IdeaProject.class);
        if (project == null) {
            return null;
        }
        ProjectModels models = new ProjectModels(project);
        models.populate(controller, this.myModelTypes);
        return models;
    }

    public static class ModuleModels
    implements Serializable {
        @NotNull
        private final IdeaModule myModule;
        @NotNull
        private final Map<Class<?>, Object> myModelsByType;

        public ModuleModels(@NotNull IdeaModule module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/SyncAction$ModuleModels", "<init>"));
            }
            this.myModelsByType = Maps.newHashMap();
            this.myModule = module;
        }

        public void populate(@NotNull BuildController controller, @NotNull Collection<Class<?>> modelTypes) {
            if (controller == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/android/tools/idea/gradle/project/sync/SyncAction$ModuleModels", "populate"));
            }
            if (modelTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelTypes", "com/android/tools/idea/gradle/project/sync/SyncAction$ModuleModels", "populate"));
            }
            for (Class<?> modelType : modelTypes) {
                Object model = controller.findModel((Model)this.myModule, modelType);
                if (model == null) continue;
                this.myModelsByType.put(modelType, model);
            }
        }

        public <T> boolean hasModel(@NotNull Class<T> modelType) {
            if (modelType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelType", "com/android/tools/idea/gradle/project/sync/SyncAction$ModuleModels", "hasModel"));
            }
            return this.findModel(modelType) != null;
        }

        @Nullable
        public <T> T findModel(@NotNull Class<T> modelType) {
            if (modelType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelType", "com/android/tools/idea/gradle/project/sync/SyncAction$ModuleModels", "findModel"));
            }
            Object model = this.myModelsByType.get(modelType);
            if (model != null) {
                assert (modelType.isInstance(model));
                return modelType.cast(model);
            }
            return null;
        }

        @NotNull
        public IdeaModule getModule() {
            IdeaModule ideaModule = this.myModule;
            if (ideaModule == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/SyncAction$ModuleModels", "getModule"));
            }
            return ideaModule;
        }
    }

    public static class ProjectModels
    implements Serializable {
        @NotNull
        private final IdeaProject myProject;
        @NotNull
        private final Map<String, ModuleModels> myModelsByModule;

        public ProjectModels(@NotNull IdeaProject project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "<init>"));
            }
            this.myModelsByModule = Maps.newHashMap();
            this.myProject = project;
        }

        public void populate(@NotNull BuildController controller, @NotNull Collection<Class<?>> modelTypes) {
            if (controller == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controller", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "populate"));
            }
            if (modelTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelTypes", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "populate"));
            }
            for (IdeaModule module : this.myProject.getModules()) {
                String key = ProjectModels.createMapKey(module);
                ModuleModels models = new ModuleModels(module);
                models.populate(controller, modelTypes);
                this.myModelsByModule.put(key, models);
            }
        }

        @NotNull
        public ModuleModels getModels(@NotNull IdeaModule module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "getModels"));
            }
            String key = ProjectModels.createMapKey(module);
            ModuleModels moduleModels = this.getModels(key);
            if (moduleModels == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "getModels"));
            }
            return moduleModels;
        }

        @NotNull
        private static String createMapKey(@NotNull IdeaModule module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "createMapKey"));
            }
            String string = module.getGradleProject().getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "createMapKey"));
            }
            return string;
        }

        @NotNull
        public ModuleModels getModels(@NotNull String gradlePath) {
            if (gradlePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "getModels"));
            }
            ModuleModels moduleModels = this.myModelsByModule.get(gradlePath);
            if (moduleModels == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "getModels"));
            }
            return moduleModels;
        }

        @NotNull
        public IdeaProject getProject() {
            IdeaProject ideaProject = this.myProject;
            if (ideaProject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/SyncAction$ProjectModels", "getProject"));
            }
            return ideaProject;
        }
    }
}

