/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility.version;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.google.common.base.Splitter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildFileComponentVersionReader
implements ComponentVersionReader {
    @NotNull
    private final String myComponentName;
    @Nullable
    private final BuildFileKey myKey;

    public BuildFileComponentVersionReader(@NotNull String keyPath) {
        if (keyPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyPath", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader", "<init>"));
        }
        List segments = Splitter.on((char)'/').splitToList((CharSequence)keyPath);
        this.myComponentName = (String)segments.get(segments.size() - 1);
        this.myKey = BuildFileKey.findByPath(keyPath);
    }

    @Override
    public boolean appliesTo(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader", "appliesTo"));
        }
        return GradleFacet.getInstance(module) != null && GradleBuildFile.get(module) != null;
    }

    @Override
    @Nullable
    public String getComponentVersion(@NotNull Module module) {
        Object value;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader", "getComponentVersion"));
        }
        GradleBuildFile buildFile = GradleBuildFile.get(module);
        if (buildFile != null && this.myKey != null && (value = buildFile.getValue(this.myKey)) != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    @Nullable
    public PositionInFile getVersionSource(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader", "getVersionSource"));
        }
        GradleBuildFile buildFile = GradleBuildFile.get(module);
        if (buildFile != null) {
            return new PositionInFile(buildFile.getFile());
        }
        return null;
    }

    @Override
    @NotNull
    public List<NotificationHyperlink> getQuickFixes(@NotNull Module module, @Nullable VersionRange expectedVersion, @Nullable PositionInFile location) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader", "getQuickFixes"));
        }
        PositionInFile source = location;
        if (source == null) {
            source = this.getVersionSource(module);
        }
        if (source != null) {
            OpenBuildFileHyperlink quickFix = new OpenBuildFileHyperlink(module, source);
            List<NotificationHyperlink> list = Collections.singletonList(quickFix);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader", "getQuickFixes"));
            }
            return list;
        }
        List<NotificationHyperlink> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader", "getQuickFixes"));
        }
        return list;
    }

    @Override
    public boolean isProjectLevel() {
        return false;
    }

    @Override
    @NotNull
    public String getComponentName() {
        String string = "'" + this.myComponentName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader", "getComponentName"));
        }
        return string;
    }

    private static class OpenBuildFileHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final PositionInFile myFileLocation;

        OpenBuildFileHyperlink(@NotNull Module module, @NotNull PositionInFile fileLocation) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader$OpenBuildFileHyperlink", "<init>"));
            }
            if (fileLocation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileLocation", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader$OpenBuildFileHyperlink", "<init>"));
            }
            super("openFile", String.format("Open build.gradle file in module '%1$s'", module.getName()));
            this.myFileLocation = fileLocation;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/compatibility/version/BuildFileComponentVersionReader$OpenBuildFileHyperlink", "execute"));
            }
            OpenFileDescriptor openFile = new OpenFileDescriptor(project, this.myFileLocation.file, this.myFileLocation.line, this.myFileLocation.column, false);
            if (openFile.canNavigate()) {
                openFile.navigate(true);
            }
        }
    }
}

