/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility.version;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.sync.compatibility.version.ComponentVersionReader;
import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.android.tools.idea.gradle.project.sync.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GradleVersionReader
implements ComponentVersionReader {
    GradleVersionReader() {
    }

    @Override
    public boolean appliesTo(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/version/GradleVersionReader", "appliesTo"));
        }
        return GradleFacet.getInstance(module) != null;
    }

    @Override
    @Nullable
    public String getComponentVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/version/GradleVersionReader", "getComponentVersion"));
        }
        GradleVersion gradleVersion = GradleVersions.getInstance().getGradleVersion(module.getProject());
        return gradleVersion != null ? gradleVersion.toString() : null;
    }

    @Override
    @Nullable
    public PositionInFile getVersionSource(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/version/GradleVersionReader", "getVersionSource"));
        }
        return null;
    }

    @Override
    @NotNull
    public List<NotificationHyperlink> getQuickFixes(@NotNull Module module, @Nullable VersionRange expectedVersion, @Nullable PositionInFile location) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/project/sync/compatibility/version/GradleVersionReader", "getQuickFixes"));
        }
        ArrayList<NotificationHyperlink> quickFixes = new ArrayList<NotificationHyperlink>();
        AndroidPluginInfo pluginInfo = AndroidPluginInfo.find(module.getProject());
        if (pluginInfo != null) {
            GradleVersion pluginVersion = GradleVersion.parse((String)pluginInfo.getPluginGeneration().getLatestKnownVersion());
            GradleVersion gradleVersion = GradleVersion.parse((String)"3.3");
            String text = "Fix Gradle version (as part of the update, the Android plugin will be updated to version " + pluginVersion + ")";
            quickFixes.add(new FixAndroidGradlePluginVersionHyperlink(text, pluginVersion, gradleVersion));
        }
        quickFixes.add(new OpenUrlHyperlink("https://developer.android.com/studio/releases/index.html#Revisions", "Open Documentation"));
        ArrayList<NotificationHyperlink> arrayList = quickFixes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/version/GradleVersionReader", "getQuickFixes"));
        }
        return arrayList;
    }

    @Override
    public boolean isProjectLevel() {
        return true;
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("Gradle" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/compatibility/version/GradleVersionReader", "getComponentName"));
        }
        return "Gradle";
    }
}

