/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.AndroidGradleProjectComponent;
import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.importing.GradleProjectImporter;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProjectSetUpTask
implements ExternalProjectRefreshCallback {
    private static final Logger LOG = Logger.getInstance(ProjectSetUpTask.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final PostSyncProjectSetup.Request mySetupRequest;
    @Nullable
    private final GradleSyncListener mySyncListener;
    private final boolean myProjectIsNew;
    private final boolean mySelectModulesToImport;
    private final boolean mySyncSkipped;

    ProjectSetUpTask(@NotNull Project project, @NotNull PostSyncProjectSetup.Request setupRequest, @Nullable GradleSyncListener syncListener, boolean projectIsNew, boolean selectModulesToImport, boolean syncSkipped) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask", "<init>"));
        }
        if (setupRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setupRequest", "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask", "<init>"));
        }
        this.myProject = project;
        this.mySetupRequest = setupRequest;
        this.mySyncListener = syncListener;
        this.myProjectIsNew = projectIsNew;
        this.mySelectModulesToImport = selectModulesToImport;
        this.mySyncSkipped = syncSkipped;
    }

    public void onSuccess(@Nullable DataNode<ProjectData> projectInfo) {
        assert (projectInfo != null);
        if (this.mySyncListener != null) {
            this.mySyncListener.setupStarted(this.myProject);
        }
        GradleSyncState.getInstance(this.myProject).setupStarted();
        this.populateProject(projectInfo);
        Runnable runnable = () -> {
            boolean isTest = ApplicationManager.getApplication().isUnitTestMode();
            if (!isTest || !GradleProjectImporter.ourSkipSetupFromTest) {
                if (this.myProjectIsNew) {
                    Projects.open(this.myProject);
                }
                if (!isTest) {
                    this.myProject.save();
                }
            }
            if (this.myProjectIsNew) {
                AndroidGradleProjectComponent projectComponent = AndroidGradleProjectComponent.getInstance(this.myProject);
                projectComponent.configureGradleProject();
            }
            if (this.mySyncListener != null) {
                if (this.mySyncSkipped) {
                    this.mySyncListener.syncSkipped(this.myProject);
                } else {
                    this.mySyncListener.syncSucceeded(this.myProject);
                }
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            GuiUtils.invokeLaterIfNeeded((Runnable)runnable, (ModalityState)ModalityState.defaultModalityState());
        }
    }

    private void populateProject(@NotNull DataNode<ProjectData> projectInfo) {
        if (projectInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask", "populateProject"));
        }
        if (!this.myProjectIsNew && ApplicationManager.getApplication().isUnitTestMode()) {
            Projects.populate(this.myProject, projectInfo, this.mySetupRequest, this.mySelectModulesToImport);
            return;
        }
        StartupManager startupManager = StartupManager.getInstance((Project)this.myProject);
        startupManager.runWhenProjectIsInitialized(() -> {
            if (projectInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectInfo", "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask", "lambda$populateProject$1"));
            }
            Projects.populate(this.myProject, projectInfo, this.mySetupRequest, this.mySelectModulesToImport);
        });
    }

    public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask", "onFailure"));
        }
        UIUtil.invokeAndWaitIfNeeded(() -> ExternalSystemUtil.ensureToolWindowContentInitialized((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID));
        if (errorDetails != null) {
            LOG.warn(errorDetails);
        }
        this.handleSyncFailure(errorMessage);
    }

    private void handleSyncFailure(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/idea/gradle/project/sync/idea/ProjectSetUpTask", "handleSyncFailure"));
        }
        String newMessage = ExternalSystemBundle.message((String)"error.resolve.with.reason", (Object[])new Object[]{errorMessage});
        LOG.info(newMessage);
        GradleProjectSyncData.removeFrom(this.myProject);
        GradleSyncState.getInstance(this.myProject).syncFailed(newMessage);
        if (this.mySyncListener != null) {
            this.mySyncListener.syncFailed(this.myProject, newMessage);
        }
    }
}

