/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.messages;

import com.android.tools.idea.gradle.notification.QuickFixNotificationListener;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.PositionInFile;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncMessages {
    private static final NotificationSource NOTIFICATION_SOURCE = NotificationSource.PROJECT_SYNC;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemNotificationManager myNotificationManager;

    @NotNull
    public static SyncMessages getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "getInstance"));
        }
        SyncMessages syncMessages = (SyncMessages)ServiceManager.getService((Project)project, SyncMessages.class);
        if (syncMessages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "getInstance"));
        }
        return syncMessages;
    }

    public SyncMessages(@NotNull Project project, @NotNull ExternalSystemNotificationManager manager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "<init>"));
        }
        this.myProject = project;
        this.myNotificationManager = manager;
    }

    public int getErrorCount() {
        return this.getMessageCount(NotificationCategory.ERROR);
    }

    public int getMessageCount(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "getMessageCount"));
        }
        return this.myNotificationManager.getMessageCount(groupName, NOTIFICATION_SOURCE, null, GradleUtil.GRADLE_SYSTEM_ID);
    }

    public boolean isEmpty() {
        return this.getMessageCount((NotificationCategory)null) == 0;
    }

    private int getMessageCount(@Nullable NotificationCategory category) {
        return this.myNotificationManager.getMessageCount(NOTIFICATION_SOURCE, category, GradleUtil.GRADLE_SYSTEM_ID);
    }

    public void removeProjectMessages() {
        this.removeMessages("Project Structure Issues", "Missing Dependencies", "Variant Selection Conflicts", "Generated Sources", "Gradle Sync Issues");
    }

    public void removeMessages(String ... groupNames) {
        if (groupNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupNames", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "removeMessages"));
        }
        for (String groupName : groupNames) {
            this.myNotificationManager.clearNotifications(groupName, NOTIFICATION_SOURCE, GradleUtil.GRADLE_SYSTEM_ID);
        }
    }

    public void report(@NotNull SyncMessage message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "report"));
        }
        String title = message.getGroup();
        String text = StringUtil.join((String[])message.getText(), (String)"\n");
        NotificationCategory category = message.getType().convertToCategory();
        PositionInFile position = message.getPosition();
        NotificationData notification = this.createNotification(title, text, category, position);
        Navigatable navigatable = message.getNavigatable();
        notification.setNavigatable(navigatable);
        List<NotificationHyperlink> quickFixes = message.getQuickFixes();
        if (!quickFixes.isEmpty()) {
            this.updateNotification(notification, text, quickFixes);
        }
        this.report(notification);
    }

    @NotNull
    public NotificationData createNotification(@NotNull String title, @NotNull String text, @NotNull NotificationCategory category, @Nullable PositionInFile position) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "createNotification"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "createNotification"));
        }
        if (category == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "createNotification"));
        }
        NotificationSource source = NotificationSource.PROJECT_SYNC;
        if (position != null) {
            String filePath = VfsUtilCore.virtualToIoFile((VirtualFile)position.file).getPath();
            NotificationData notificationData = new NotificationData(title, text, category, source, filePath, position.line, position.column, false);
            if (notificationData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "createNotification"));
            }
            return notificationData;
        }
        NotificationData notificationData = new NotificationData(title, text, category, source);
        if (notificationData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "createNotification"));
        }
        return notificationData;
    }

    public void updateNotification(@NotNull NotificationData notification, @NotNull String text, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "updateNotification"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "updateNotification"));
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "updateNotification"));
        }
        String message = text;
        int hyperlinkCount = quickFixes.size();
        if (hyperlinkCount > 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < hyperlinkCount; ++i) {
                b.append(quickFixes.get(i).toHtml());
                if (i >= hyperlinkCount - 1) continue;
                b.append("<br>");
            }
            message = message + '\n' + b.toString();
        }
        notification.setMessage(message);
        this.addNotificationListener(notification, quickFixes);
    }

    public void addNotificationListener(@NotNull NotificationData notification, @NotNull List<NotificationHyperlink> quickFixes) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "addNotificationListener"));
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "addNotificationListener"));
        }
        for (NotificationHyperlink quickFix : quickFixes) {
            notification.setListener(quickFix.getUrl(), (NotificationListener)new QuickFixNotificationListener(this.myProject, quickFix));
        }
    }

    public void report(@NotNull NotificationData notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/project/sync/messages/SyncMessages", "report"));
        }
        this.myNotificationManager.showNotification(GradleUtil.GRADLE_SYSTEM_ID, notification);
    }
}

