/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.precheck;

import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.messages.MessageType;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessage;
import com.android.tools.idea.gradle.project.sync.messages.SyncMessages;
import com.android.tools.idea.gradle.project.sync.precheck.AndroidStudioSyncCheck;
import com.android.tools.idea.gradle.project.sync.precheck.PreSyncCheckResult;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class JdkPreSyncCheck
extends AndroidStudioSyncCheck {
    JdkPreSyncCheck() {
    }

    @Override
    @NotNull
    PreSyncCheckResult doCheckCanSync(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/precheck/JdkPreSyncCheck", "doCheckCanSync"));
        }
        Sdk jdk = IdeSdks.getInstance().getJdk();
        if (!JdkPreSyncCheck.isValidJdk(jdk)) {
            String msg = "Please use JDK 8 or newer.";
            SyncMessage message = new SyncMessage("Project sync error", MessageType.ERROR, msg);
            List<NotificationHyperlink> quickFixes = Jdks.getInstance().getWrongJdkQuickFixes(project);
            message.add(quickFixes);
            SyncMessages.getInstance(project).report(message);
            PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.failure(msg);
            if (preSyncCheckResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/JdkPreSyncCheck", "doCheckCanSync"));
            }
            return preSyncCheckResult;
        }
        PreSyncCheckResult preSyncCheckResult = PreSyncCheckResult.SUCCESS;
        if (preSyncCheckResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/precheck/JdkPreSyncCheck", "doCheckCanSync"));
        }
        return preSyncCheckResult;
    }

    private static boolean isValidJdk(Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        String jdkHomePath = jdk.getHomePath();
        return jdkHomePath != null && JdkUtil.checkForJdk((File)new File(jdkHomePath)) && Jdks.getInstance().isApplicableJdk(jdk, LanguageLevel.JDK_1_8);
    }
}

