/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module;

import com.android.tools.idea.gradle.project.sync.setup.post.project.DisposedModules;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ModuleDisposer {
    public void disposeModulesAndMarkImlFilesForDeletion(@NotNull Collection<Module> modules, @NotNull Project project, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleDisposer", "disposeModulesAndMarkImlFilesForDeletion"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleDisposer", "disposeModulesAndMarkImlFilesForDeletion"));
        }
        if (ideModelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideModelsProvider", "com/android/tools/idea/gradle/project/sync/setup/module/ModuleDisposer", "disposeModulesAndMarkImlFilesForDeletion"));
        }
        if (!modules.isEmpty()) {
            ModifiableModuleModel moduleModel = ideModelsProvider.getModifiableModuleModel();
            ArrayList<File> imlFilesToRemove = new ArrayList<File>();
            for (Module toDispose : modules) {
                File imlFilePath = new File(FileUtil.toSystemDependentName((String)toDispose.getModuleFilePath()));
                imlFilesToRemove.add(imlFilePath);
                moduleModel.disposeModule(toDispose);
            }
            DisposedModules.getInstance(project).markImlFilesForDeletion(imlFilesToRemove);
        }
    }
}

